/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.start;

import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.start.EPStatementStartMethodBase;
import com.espertech.esper.core.start.EPStatementStartResult;
import com.espertech.esper.core.start.EPStatementStopMethod;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.named.NamedWindowProcessor;
import com.espertech.esper.epl.named.NamedWindowProcessorInstance;
import com.espertech.esper.epl.spec.CreateIndexDesc;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import com.espertech.esper.epl.virtualdw.VirtualDWView;
import com.espertech.esper.view.ViewProcessingException;
import com.espertech.esper.view.ViewableDefaultImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EPStatementStartMethodCreateIndex
extends EPStatementStartMethodBase {
    private static final Log log = LogFactory.getLog(EPStatementStartMethodCreateIndex.class);

    public EPStatementStartMethodCreateIndex(StatementSpecCompiled statementSpec, EPServicesContext services, StatementContext statementContext) {
        super(statementSpec, services, statementContext);
    }

    @Override
    public EPStatementStartResult startInternal(boolean isNewStatement, boolean isRecoveringStatement, boolean isRecoveringResilient) throws ExprValidationException, ViewProcessingException {
        EPStatementStopMethod stopMethod;
        final CreateIndexDesc spec = this.statementSpec.getCreateIndexDesc();
        NamedWindowProcessor processor = this.services.getNamedWindowService().getProcessor(spec.getWindowName());
        if (processor == null) {
            throw new ExprValidationException("A named window by name '" + spec.getWindowName() + "' does not exist");
        }
        final NamedWindowProcessorInstance processorInstance = processor.getProcessorInstance(this.getDefaultAgentInstanceContext());
        if (processor.isVirtualDataWindow()) {
            final VirtualDWView virtualDWView = processorInstance.getRootViewInstance().getVirtualDataWindow();
            virtualDWView.handleStartIndex(spec);
            stopMethod = new EPStatementStopMethod(){

                @Override
                public void stop() {
                    virtualDWView.handleStopIndex(spec);
                }
            };
        } else {
            processorInstance.getRootViewInstance().addExplicitIndex(spec.getWindowName(), spec.getIndexName(), spec.getColumns());
            stopMethod = new EPStatementStopMethod(){

                @Override
                public void stop() {
                    processorInstance.getRootViewInstance().removeExplicitIndex(spec.getIndexName());
                }
            };
        }
        ViewableDefaultImpl viewable = new ViewableDefaultImpl(processor.getNamedWindowType());
        return new EPStatementStartResult(viewable, stopMethod, null);
    }
}

