/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.start;

import com.espertech.esper.client.ConfigurationEventTypeLegacy;
import com.espertech.esper.client.ConfigurationEventTypeMap;
import com.espertech.esper.client.ConfigurationVariantStream;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.start.EPStatementStartMethodBase;
import com.espertech.esper.core.start.EPStatementStartResult;
import com.espertech.esper.core.start.EPStatementStopMethod;
import com.espertech.esper.epl.core.EngineImportException;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.CreateSchemaDesc;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import com.espertech.esper.event.EventAdapterException;
import com.espertech.esper.event.EventTypeUtility;
import com.espertech.esper.view.ViewProcessingException;
import com.espertech.esper.view.ViewableDefaultImpl;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EPStatementStartMethodCreateSchema
extends EPStatementStartMethodBase {
    private static final Log log = LogFactory.getLog(EPStatementStartMethodCreateSchema.class);

    public EPStatementStartMethodCreateSchema(StatementSpecCompiled statementSpec, EPServicesContext services, StatementContext statementContext) {
        super(statementSpec, services, statementContext);
    }

    @Override
    public EPStatementStartResult startInternal(boolean isNewStatement, boolean isRecoveringStatement, boolean isRecoveringResilient) throws ExprValidationException, ViewProcessingException {
        EventType eventType;
        CreateSchemaDesc spec;
        block17: {
            spec = this.statementSpec.getCreateSchemaDesc();
            eventType = null;
            try {
                Serializable config;
                if (!spec.isVariant()) {
                    if (spec.getTypes().isEmpty()) {
                        Map<String, Object> typing = EventTypeUtility.buildType(spec.getColumns(), this.services.getEventAdapterService(), spec.getCopyFrom());
                        config = new ConfigurationEventTypeMap();
                        if (spec.getInherits() != null) {
                            ((ConfigurationEventTypeMap)config).getSuperTypes().addAll(spec.getInherits());
                        }
                        ((ConfigurationEventTypeMap)config).setStartTimestampPropertyName(spec.getStartTimestampProperty());
                        ((ConfigurationEventTypeMap)config).setEndTimestampPropertyName(spec.getEndTimestampProperty());
                        eventType = this.services.getEventAdapterService().addNestableMapType(spec.getSchemaName(), typing, (ConfigurationEventTypeMap)config, false, false, true, false, false);
                        break block17;
                    }
                    if (spec.getCopyFrom() != null && !spec.getCopyFrom().isEmpty()) {
                        throw new ExprValidationException("Copy-from types are not allowed with class-provided types");
                    }
                    if (spec.getTypes().size() != 1) break block17;
                    String typeName = spec.getTypes().iterator().next();
                    try {
                        config = this.services.getEventAdapterService().getClassLegacyConfigs(typeName);
                        if (spec.getStartTimestampProperty() != null || spec.getEndTimestampProperty() != null) {
                            if (config == null) {
                                config = new ConfigurationEventTypeLegacy();
                            }
                            ((ConfigurationEventTypeLegacy)config).setStartTimestampPropertyName(spec.getStartTimestampProperty());
                            ((ConfigurationEventTypeLegacy)config).setEndTimestampPropertyName(spec.getEndTimestampProperty());
                            this.services.getEventAdapterService().setClassLegacyConfigs(Collections.singletonMap(typeName, config));
                        }
                        eventType = this.services.getEventAdapterService().addBeanType(spec.getSchemaName(), spec.getTypes().iterator().next(), false, false, false, true);
                        break block17;
                    }
                    catch (EventAdapterException ex) {
                        try {
                            Class clazz = this.services.getEngineImportService().resolveClass(typeName);
                            eventType = this.services.getEventAdapterService().addBeanType(spec.getSchemaName(), clazz, false, false, true);
                            break block17;
                        }
                        catch (EngineImportException e) {
                            log.debug((Object)("Engine import failed to resolve event type '" + typeName + "'"));
                            throw ex;
                        }
                    }
                }
                if (spec.getCopyFrom() != null && !spec.getCopyFrom().isEmpty()) {
                    throw new ExprValidationException("Copy-from types are not allowed with variant types");
                }
                boolean isAny = false;
                config = new ConfigurationVariantStream();
                for (String typeName : spec.getTypes()) {
                    if (typeName.trim().equals("*")) {
                        isAny = true;
                        break;
                    }
                    ((ConfigurationVariantStream)config).addEventTypeName(typeName);
                }
                if (!isAny) {
                    ((ConfigurationVariantStream)config).setTypeVariance(ConfigurationVariantStream.TypeVariance.PREDEFINED);
                } else {
                    ((ConfigurationVariantStream)config).setTypeVariance(ConfigurationVariantStream.TypeVariance.ANY);
                }
                this.services.getValueAddEventService().addVariantStream(spec.getSchemaName(), (ConfigurationVariantStream)config, this.services.getEventAdapterService(), this.services.getEventTypeIdGenerator());
                eventType = this.services.getValueAddEventService().getValueAddProcessor(spec.getSchemaName()).getValueAddEventType();
            }
            catch (RuntimeException ex) {
                throw new ExprValidationException(ex.getMessage(), ex);
            }
        }
        this.services.getStatementEventTypeRefService().addReferences(this.statementContext.getStatementName(), Collections.singleton(spec.getSchemaName()));
        final EventType allocatedEventType = eventType;
        EPStatementStopMethod stopMethod = new EPStatementStopMethod(){

            @Override
            public void stop() {
                EPStatementStartMethodCreateSchema.this.services.getStatementEventTypeRefService().removeReferencesStatement(EPStatementStartMethodCreateSchema.this.statementContext.getStatementName());
                if (EPStatementStartMethodCreateSchema.this.services.getStatementEventTypeRefService().getStatementNamesForType(spec.getSchemaName()).isEmpty()) {
                    EPStatementStartMethodCreateSchema.this.services.getEventAdapterService().removeType(allocatedEventType.getName());
                    EPStatementStartMethodCreateSchema.this.services.getFilterService().removeType(allocatedEventType);
                }
            }
        };
        ViewableDefaultImpl viewable = new ViewableDefaultImpl(eventType);
        return new EPStatementStartResult(viewable, stopMethod, null);
    }
}

