/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.start;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.mgr.ContextPropertyRegistryImpl;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.ExprEvaluatorContextStatement;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.start.EPStatementDestroyMethod;
import com.espertech.esper.core.start.EPStatementStartMethodBase;
import com.espertech.esper.core.start.EPStatementStartMethodHelperAssignExpr;
import com.espertech.esper.core.start.EPStatementStartResult;
import com.espertech.esper.core.start.EPStatementStopMethod;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.core.ResultSetProcessorFactoryDesc;
import com.espertech.esper.epl.core.ResultSetProcessorFactoryFactory;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.CreateVariableDesc;
import com.espertech.esper.epl.spec.SelectClauseElementWildcard;
import com.espertech.esper.epl.spec.SelectClauseStreamSelectorEnum;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import com.espertech.esper.epl.variable.CreateVariableView;
import com.espertech.esper.epl.variable.VariableDeclarationException;
import com.espertech.esper.epl.variable.VariableExistsException;
import com.espertech.esper.epl.view.OutputProcessViewBase;
import com.espertech.esper.epl.view.OutputProcessViewFactory;
import com.espertech.esper.epl.view.OutputProcessViewFactoryFactory;
import com.espertech.esper.view.StatementStopCallback;
import com.espertech.esper.view.ViewProcessingException;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EPStatementStartMethodCreateVariable
extends EPStatementStartMethodBase {
    private static final Log log = LogFactory.getLog(EPStatementStartMethodCreateVariable.class);

    public EPStatementStartMethodCreateVariable(StatementSpecCompiled statementSpec, EPServicesContext services, StatementContext statementContext) {
        super(statementSpec, services, statementContext);
    }

    @Override
    public EPStatementStartResult startInternal(boolean isNewStatement, boolean isRecoveringStatement, boolean isRecoveringResilient) throws ExprValidationException, ViewProcessingException {
        final CreateVariableDesc createDesc = this.statementSpec.getCreateVariableDesc();
        Object value = null;
        if (createDesc.getAssignment() != null) {
            StreamTypeServiceImpl typeService = new StreamTypeServiceImpl(new EventType[0], new String[0], new boolean[0], this.services.getEngineURI(), false);
            ExprEvaluatorContextStatement evaluatorContextStmt = new ExprEvaluatorContextStatement(this.statementContext);
            ExprValidationContext validationContext = new ExprValidationContext(typeService, this.statementContext.getMethodResolutionService(), null, this.statementContext.getSchedulingService(), this.statementContext.getVariableService(), evaluatorContextStmt, this.statementContext.getEventAdapterService(), this.statementContext.getStatementName(), this.statementContext.getStatementId(), this.statementContext.getAnnotations(), this.statementContext.getContextDescriptor());
            ExprNode validated = ExprNodeUtility.getValidatedSubtree(createDesc.getAssignment(), validationContext);
            value = validated.getExprEvaluator().evaluate(null, true, evaluatorContextStmt);
        }
        try {
            this.services.getVariableService().createNewVariable(createDesc.getVariableName(), createDesc.getVariableType(), value, this.statementContext.getExtensionServicesContext());
        }
        catch (VariableExistsException ex) {
            if (isNewStatement) {
                throw new ExprValidationException("Cannot create variable: " + ex.getMessage());
            }
        }
        catch (VariableDeclarationException ex) {
            throw new ExprValidationException("Cannot create variable: " + ex.getMessage());
        }
        final CreateVariableView createView = new CreateVariableView(this.statementContext.getStatementId(), this.services.getEventAdapterService(), this.services.getVariableService(), createDesc.getVariableName(), this.statementContext.getStatementResultService());
        final int variableNum = this.services.getVariableService().getReader(createDesc.getVariableName()).getVariableNumber();
        this.services.getVariableService().registerCallback(variableNum, createView);
        this.statementContext.getStatementStopService().addSubscriber(new StatementStopCallback(){

            @Override
            public void statementStopped() {
                EPStatementStartMethodCreateVariable.this.services.getVariableService().unregisterCallback(variableNum, createView);
            }
        });
        this.statementSpec.getSelectClauseSpec().getSelectExprList().clear();
        this.statementSpec.getSelectClauseSpec().add(new SelectClauseElementWildcard());
        this.statementSpec.setSelectStreamDirEnum(SelectClauseStreamSelectorEnum.RSTREAM_ISTREAM_BOTH);
        StreamTypeServiceImpl typeService = new StreamTypeServiceImpl(new EventType[]{createView.getEventType()}, new String[]{"create_variable"}, new boolean[]{true}, this.services.getEngineURI(), false);
        AgentInstanceContext agentInstanceContext = this.getDefaultAgentInstanceContext();
        ResultSetProcessorFactoryDesc resultSetProcessorPrototype = ResultSetProcessorFactoryFactory.getProcessorPrototype(this.statementSpec, agentInstanceContext, typeService, null, new boolean[0], true, ContextPropertyRegistryImpl.EMPTY_REGISTRY);
        ResultSetProcessor resultSetProcessor = EPStatementStartMethodHelperAssignExpr.getAssignResultSetProcessor(agentInstanceContext, resultSetProcessorPrototype);
        OutputProcessViewFactory outputViewFactory = OutputProcessViewFactoryFactory.make(this.statementSpec, this.services.getInternalEventRouter(), agentInstanceContext.getStatementContext(), resultSetProcessor.getResultEventType());
        OutputProcessViewBase outputView = outputViewFactory.makeView(resultSetProcessor, agentInstanceContext);
        createView.addView(outputView);
        this.services.getStatementVariableRefService().addReferences(this.statementContext.getStatementName(), Collections.singleton(createDesc.getVariableName()));
        EPStatementDestroyMethod destroyMethod = new EPStatementDestroyMethod(){

            @Override
            public void destroy() {
                try {
                    EPStatementStartMethodCreateVariable.this.services.getStatementVariableRefService().removeReferencesStatement(EPStatementStartMethodCreateVariable.this.statementContext.getStatementName());
                }
                catch (RuntimeException ex) {
                    log.error((Object)("Error removing variable '" + createDesc.getVariableName() + "': " + ex.getMessage()));
                }
            }
        };
        EPStatementStopMethod stopMethod = new EPStatementStopMethod(){

            @Override
            public void stop() {
            }
        };
        return new EPStatementStartResult(outputView, stopMethod, destroyMethod);
    }
}

