/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.start;

import com.espertech.esper.client.EventType;
import com.espertech.esper.client.annotation.HintEnum;
import com.espertech.esper.core.context.activator.ViewableActivatorFilterProxy;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactoryCreateWindow;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactoryCreateWindowResult;
import com.espertech.esper.core.context.mgr.ContextManagedStatementCreateWindowDesc;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.ContextMergeView;
import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.start.EPStatementDestroyMethod;
import com.espertech.esper.core.start.EPStatementStartMethodBase;
import com.espertech.esper.core.start.EPStatementStartResult;
import com.espertech.esper.core.start.EPStatementStopMethod;
import com.espertech.esper.core.start.EPStatementStopMethodImpl;
import com.espertech.esper.epl.core.ResultSetProcessorFactoryDesc;
import com.espertech.esper.epl.core.ResultSetProcessorFactoryFactory;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.named.NamedWindowProcessor;
import com.espertech.esper.epl.spec.FilterStreamSpecCompiled;
import com.espertech.esper.epl.spec.SelectClauseElementWildcard;
import com.espertech.esper.epl.spec.SelectClauseStreamSelectorEnum;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import com.espertech.esper.epl.view.OutputProcessViewFactory;
import com.espertech.esper.epl.view.OutputProcessViewFactoryFactory;
import com.espertech.esper.epl.virtualdw.VirtualDWViewFactory;
import com.espertech.esper.event.vaevent.ValueAddEventProcessor;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.DataWindowBatchingViewFactory;
import com.espertech.esper.view.DataWindowViewFactory;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryChain;
import com.espertech.esper.view.ViewProcessingException;
import com.espertech.esper.view.Viewable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EPStatementStartMethodCreateWindow
extends EPStatementStartMethodBase {
    private static final Log log = LogFactory.getLog(EPStatementStartMethodCreateWindow.class);

    public EPStatementStartMethodCreateWindow(StatementSpecCompiled statementSpec, EPServicesContext services, StatementContext statementContext) {
        super(statementSpec, services, statementContext);
    }

    @Override
    public EPStatementStartResult startInternal(boolean isNewStatement, boolean isRecoveringStatement, boolean isRecoveringResilient) throws ExprValidationException, ViewProcessingException {
        EPStatementDestroyMethod destroyStatementMethod;
        EPStatementStopMethod stopStatementMethod;
        Viewable finalViewable;
        boolean isEnableSubqueryIndexShare;
        ArrayList<StopCallback> stopCallbacks = new ArrayList<StopCallback>();
        final EPStatementStopMethodImpl stopMethod = new EPStatementStopMethodImpl(this.statementContext, stopCallbacks);
        final String contextName = this.statementSpec.getOptionalContextName();
        boolean singleInstanceContext = contextName == null ? false : this.services.getContextManagementService().getContextDescriptor(contextName).isSingleInstanceContext();
        EPStatementAgentInstanceHandle epStatementAgentInstanceHandle = this.getDefaultAgentInstanceHandle();
        if (this.services.getSchedulableAgentInstanceDirectory() != null) {
            this.services.getSchedulableAgentInstanceDirectory().add(epStatementAgentInstanceHandle);
        }
        FilterStreamSpecCompiled filterStreamSpec = (FilterStreamSpecCompiled)this.statementSpec.getStreamSpecs().get(0);
        ViewableActivatorFilterProxy activator = new ViewableActivatorFilterProxy(this.services, filterStreamSpec.getFilterSpec(), this.statementContext.getAnnotations(), false);
        ViewFactoryChain unmaterializedViewChain = this.services.getViewService().createFactories(0, filterStreamSpec.getFilterSpec().getResultEventType(), filterStreamSpec.getViewSpecs(), filterStreamSpec.getOptions(), this.statementContext);
        this.verifyDataWindowViewFactoryChain(unmaterializedViewChain.getViewFactoryChain());
        final String windowName = this.statementSpec.getCreateWindowDesc().getWindowName();
        ValueAddEventProcessor optionalRevisionProcessor = this.statementContext.getValueAddEventService().getValueAddProcessor(windowName);
        boolean isPrioritized = this.services.getEngineSettingsService().getEngineSettings().getExecution().isPrioritized();
        boolean bl = isEnableSubqueryIndexShare = HintEnum.ENABLE_WINDOW_SUBQUERY_INDEXSHARE.getHint(this.statementSpec.getAnnotations()) != null;
        if (!isEnableSubqueryIndexShare && unmaterializedViewChain.getViewFactoryChain().get(0) instanceof VirtualDWViewFactory) {
            isEnableSubqueryIndexShare = true;
        }
        boolean isBatchingDataWindow = EPStatementStartMethodCreateWindow.determineBatchingDataWindow(unmaterializedViewChain.getViewFactoryChain());
        boolean isVirtualDataWindow = EPStatementStartMethodCreateWindow.determineVirtualDataWindow(unmaterializedViewChain.getViewFactoryChain());
        NamedWindowProcessor processor = this.services.getNamedWindowService().addProcessor(windowName, contextName, singleInstanceContext, filterStreamSpec.getFilterSpec().getResultEventType(), this.statementContext.getStatementResultService(), optionalRevisionProcessor, this.statementContext.getExpression(), this.statementContext.getStatementName(), isPrioritized, isEnableSubqueryIndexShare, isBatchingDataWindow, isVirtualDataWindow, this.statementContext.getEpStatementHandle().getMetricsHandle());
        stopCallbacks.add(new StopCallback(){

            @Override
            public void stop() {
                EPStatementStartMethodCreateWindow.this.services.getNamedWindowService().removeProcessor(windowName);
            }
        });
        this.statementSpec.getSelectClauseSpec().getSelectExprList().clear();
        this.statementSpec.getSelectClauseSpec().add(new SelectClauseElementWildcard());
        this.statementSpec.setSelectStreamDirEnum(SelectClauseStreamSelectorEnum.RSTREAM_ISTREAM_BOTH);
        StreamTypeServiceImpl typeService = new StreamTypeServiceImpl(new EventType[]{processor.getNamedWindowType()}, new String[]{windowName}, new boolean[]{true}, this.services.getEngineURI(), false);
        ResultSetProcessorFactoryDesc resultSetProcessorPrototype = ResultSetProcessorFactoryFactory.getProcessorPrototype(this.statementSpec, this.getDefaultAgentInstanceContext(), typeService, null, new boolean[0], true, null);
        OutputProcessViewFactory outputViewFactory = OutputProcessViewFactoryFactory.make(this.statementSpec, this.services.getInternalEventRouter(), this.statementContext, resultSetProcessorPrototype.getResultSetProcessorFactory().getResultEventType());
        StatementAgentInstanceFactoryCreateWindow contextFactory = new StatementAgentInstanceFactoryCreateWindow(this.statementContext, this.statementSpec, this.services, activator, unmaterializedViewChain, resultSetProcessorPrototype, outputViewFactory, isRecoveringStatement);
        if (this.statementSpec.getOptionalContextName() != null) {
            ContextMergeView mergeView;
            finalViewable = mergeView = new ContextMergeView(processor.getNamedWindowType());
            ContextManagedStatementCreateWindowDesc statement = new ContextManagedStatementCreateWindowDesc(this.statementSpec, this.statementContext, mergeView, contextFactory);
            this.services.getContextManagementService().addStatement(contextName, statement);
            stopStatementMethod = new EPStatementStopMethod(){

                @Override
                public void stop() {
                    EPStatementStartMethodCreateWindow.this.services.getContextManagementService().stoppedStatement(contextName, EPStatementStartMethodCreateWindow.this.statementContext.getStatementName(), EPStatementStartMethodCreateWindow.this.statementContext.getStatementId());
                    stopMethod.stop();
                }
            };
            destroyStatementMethod = new EPStatementDestroyMethod(){

                @Override
                public void destroy() {
                    EPStatementStartMethodCreateWindow.this.services.getContextManagementService().destroyedStatement(contextName, EPStatementStartMethodCreateWindow.this.statementContext.getStatementName(), EPStatementStartMethodCreateWindow.this.statementContext.getStatementId());
                }
            };
        } else {
            AgentInstanceContext agentInstanceContext = this.getDefaultAgentInstanceContext();
            final StatementAgentInstanceFactoryCreateWindowResult resultOfStart = contextFactory.newContext(agentInstanceContext);
            finalViewable = resultOfStart.getFinalView();
            stopStatementMethod = new EPStatementStopMethod(){

                @Override
                public void stop() {
                    resultOfStart.getStopCallback().stop();
                    stopMethod.stop();
                }
            };
            destroyStatementMethod = null;
        }
        return new EPStatementStartResult(finalViewable, stopStatementMethod, destroyStatementMethod);
    }

    private static boolean determineVirtualDataWindow(List<ViewFactory> viewFactoryChain) {
        for (ViewFactory viewFactory : viewFactoryChain) {
            if (!(viewFactory instanceof VirtualDWViewFactory)) continue;
            return true;
        }
        return false;
    }

    private static boolean determineBatchingDataWindow(List<ViewFactory> viewFactoryChain) {
        for (ViewFactory viewFactory : viewFactoryChain) {
            if (!(viewFactory instanceof DataWindowBatchingViewFactory)) continue;
            return true;
        }
        return false;
    }

    private void verifyDataWindowViewFactoryChain(List<ViewFactory> viewFactories) throws ExprValidationException {
        for (ViewFactory viewFactory : viewFactories) {
            if (!(viewFactory instanceof DataWindowViewFactory)) continue;
            return;
        }
        throw new ExprValidationException("Named windows require one or more child views that are data window views");
    }
}

