/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.start;

import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.start.EPStatementStartMethod;
import com.espertech.esper.core.start.EPStatementStartMethodCreateContext;
import com.espertech.esper.core.start.EPStatementStartMethodCreateIndex;
import com.espertech.esper.core.start.EPStatementStartMethodCreateSchema;
import com.espertech.esper.core.start.EPStatementStartMethodCreateVariable;
import com.espertech.esper.core.start.EPStatementStartMethodCreateWindow;
import com.espertech.esper.core.start.EPStatementStartMethodOnTrigger;
import com.espertech.esper.core.start.EPStatementStartMethodSelect;
import com.espertech.esper.core.start.EPStatementStartMethodUpdate;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EPStatementStartMethodFactory {
    private static final Log log = LogFactory.getLog(EPStatementStartMethodFactory.class);

    public static EPStatementStartMethod makeStartMethod(StatementSpecCompiled statementSpec, EPServicesContext services, StatementContext statementContext) {
        if (statementSpec.getUpdateSpec() != null) {
            return new EPStatementStartMethodUpdate(statementSpec, services, statementContext);
        }
        if (statementSpec.getOnTriggerDesc() != null) {
            return new EPStatementStartMethodOnTrigger(statementSpec, services, statementContext);
        }
        if (statementSpec.getCreateWindowDesc() != null) {
            return new EPStatementStartMethodCreateWindow(statementSpec, services, statementContext);
        }
        if (statementSpec.getCreateIndexDesc() != null) {
            return new EPStatementStartMethodCreateIndex(statementSpec, services, statementContext);
        }
        if (statementSpec.getCreateSchemaDesc() != null) {
            return new EPStatementStartMethodCreateSchema(statementSpec, services, statementContext);
        }
        if (statementSpec.getCreateVariableDesc() != null) {
            return new EPStatementStartMethodCreateVariable(statementSpec, services, statementContext);
        }
        if (statementSpec.getContextDesc() != null) {
            return new EPStatementStartMethodCreateContext(statementSpec, services, statementContext);
        }
        return new EPStatementStartMethodSelect(statementSpec, services, statementContext);
    }
}

