/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.start;

import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.agg.AggregationService;
import com.espertech.esper.epl.core.OrderByProcessor;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.core.ResultSetProcessorFactoryDesc;
import com.espertech.esper.epl.expression.ExprSubselectNode;
import com.espertech.esper.epl.spec.FilterStreamSpecCompiled;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import com.espertech.esper.epl.spec.StreamSpecCompiled;
import com.espertech.esper.event.EventTypeUtility;
import com.espertech.esper.pattern.EvalFactoryNode;
import com.espertech.esper.pattern.EvalFilterFactoryNode;
import com.espertech.esper.view.ViewFactoryChain;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EPStatementStartMethodHelperUtil {
    private static final Log log = LogFactory.getLog(EPStatementStartMethodHelperUtil.class);

    public static Pair<ResultSetProcessor, AggregationService> startResultSetAndAggregation(ResultSetProcessorFactoryDesc resultSetProcessorPrototype, AgentInstanceContext agentInstanceContext) {
        AggregationService aggregationService = null;
        if (resultSetProcessorPrototype.getAggregationServiceFactoryDesc() != null) {
            aggregationService = resultSetProcessorPrototype.getAggregationServiceFactoryDesc().getAggregationServiceFactory().makeService(agentInstanceContext);
        }
        OrderByProcessor orderByProcessor = null;
        if (resultSetProcessorPrototype.getOrderByProcessorFactory() != null) {
            orderByProcessor = resultSetProcessorPrototype.getOrderByProcessorFactory().instantiate(aggregationService);
        }
        ResultSetProcessor resultSetProcessor = resultSetProcessorPrototype.getResultSetProcessorFactory().instantiate(orderByProcessor, aggregationService, agentInstanceContext);
        return new Pair<ResultSetProcessor, AggregationService>(resultSetProcessor, aggregationService);
    }

    protected static String[] determineStreamNames(List<StreamSpecCompiled> streams) {
        String[] streamNames = new String[streams.size()];
        for (int i = 0; i < streams.size(); ++i) {
            streamNames[i] = streams.get(i).getOptionalStreamName();
            if (streamNames[i] != null) continue;
            streamNames[i] = "stream_" + i;
        }
        return streamNames;
    }

    protected static boolean[] getHasIStreamOnly(boolean[] isNamedWindow, ViewFactoryChain[] unmaterializedViewChain) {
        boolean[] result = new boolean[unmaterializedViewChain.length];
        for (int i = 0; i < unmaterializedViewChain.length; ++i) {
            if (isNamedWindow[i]) continue;
            result[i] = unmaterializedViewChain[i].getDataWindowViewFactoryCount() == 0;
        }
        return result;
    }

    protected static boolean determineSubquerySameStream(StatementSpecCompiled statementSpec, FilterStreamSpecCompiled filterStreamSpec) {
        for (ExprSubselectNode subselect : statementSpec.getSubSelectExpressions()) {
            EventType typeFiltered;
            FilterStreamSpecCompiled filterStream;
            EventType typeSubselect;
            StreamSpecCompiled streamSpec = subselect.getStatementSpecCompiled().getStreamSpecs().get(0);
            if (!(streamSpec instanceof FilterStreamSpecCompiled) || !EventTypeUtility.isTypeOrSubTypeOf(typeSubselect = (filterStream = (FilterStreamSpecCompiled)streamSpec).getFilterSpec().getFilterForEventType(), typeFiltered = filterStreamSpec.getFilterSpec().getFilterForEventType()) && !EventTypeUtility.isTypeOrSubTypeOf(typeFiltered, typeSubselect)) continue;
            return true;
        }
        return false;
    }

    protected static boolean isConsumingFilters(EvalFactoryNode evalNode) {
        if (evalNode instanceof EvalFilterFactoryNode) {
            return ((EvalFilterFactoryNode)evalNode).getConsumptionLevel() != null;
        }
        boolean consumption = false;
        for (EvalFactoryNode child : evalNode.getChildNodes()) {
            consumption = consumption || EPStatementStartMethodHelperUtil.isConsumingFilters(child);
        }
        return consumption;
    }
}

