/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.start;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactoryUpdate;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactoryUpdateResult;
import com.espertech.esper.core.context.mgr.ContextManagedStatementOnTriggerDesc;
import com.espertech.esper.core.context.stmt.AIRegistryExpr;
import com.espertech.esper.core.context.stmt.AIRegistrySubselect;
import com.espertech.esper.core.context.subselect.SubSelectActivationCollection;
import com.espertech.esper.core.context.subselect.SubSelectStrategyCollection;
import com.espertech.esper.core.context.subselect.SubSelectStrategyHolder;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.ContextMergeView;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.ExprEvaluatorContextStatement;
import com.espertech.esper.core.service.InternalEventRouterDesc;
import com.espertech.esper.core.service.InternalRoutePreprocessView;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.start.EPStatementDestroyMethod;
import com.espertech.esper.core.start.EPStatementStartMethodBase;
import com.espertech.esper.core.start.EPStatementStartMethodHelperAssignExpr;
import com.espertech.esper.core.start.EPStatementStartMethodHelperSubselect;
import com.espertech.esper.core.start.EPStatementStartMethodHelperValidate;
import com.espertech.esper.core.start.EPStatementStartResult;
import com.espertech.esper.core.start.EPStatementStopMethod;
import com.espertech.esper.core.start.EPStatementStopMethodImpl;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprSubselectNode;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.FilterStreamSpecCompiled;
import com.espertech.esper.epl.spec.NamedWindowConsumerStreamSpec;
import com.espertech.esper.epl.spec.OnTriggerSetAssignment;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import com.espertech.esper.epl.spec.StreamSpecCompiled;
import com.espertech.esper.epl.spec.UpdateDesc;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.ViewProcessingException;
import com.espertech.esper.view.Viewable;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EPStatementStartMethodUpdate
extends EPStatementStartMethodBase {
    private static final Log log = LogFactory.getLog(EPStatementStartMethodUpdate.class);

    public EPStatementStartMethodUpdate(StatementSpecCompiled statementSpec, EPServicesContext services, StatementContext statementContext) {
        super(statementSpec, services, statementContext);
    }

    @Override
    public EPStatementStartResult startInternal(boolean isNewStatement, boolean isRecoveringStatement, boolean isRecoveringResilient) throws ExprValidationException, ViewProcessingException {
        EPStatementDestroyMethod destroyStatementMethod;
        EPStatementStopMethod stopStatementMethod;
        Viewable finalViewable;
        HashMap<ExprSubselectNode, SubSelectStrategyHolder> subselectStrategyInstances;
        String triggereventTypeName;
        LinkedList<StopCallback> stopCallbacks = new LinkedList<StopCallback>();
        final EPStatementStopMethodImpl stopMethod = new EPStatementStopMethodImpl(this.statementContext, stopCallbacks);
        final String contextName = this.statementSpec.getOptionalContextName();
        if (contextName != null) {
            throw new ExprValidationException("Update IStream is not supported in conjunction with a context");
        }
        SubSelectActivationCollection subSelectStreamDesc = EPStatementStartMethodHelperSubselect.createSubSelectActivation(this.services, this.statementSpec, this.statementContext);
        StreamSpecCompiled streamSpec = this.statementSpec.getStreamSpecs().get(0);
        UpdateDesc updateSpec = this.statementSpec.getUpdateSpec();
        if (streamSpec instanceof FilterStreamSpecCompiled) {
            FilterStreamSpecCompiled filterStreamSpec = (FilterStreamSpecCompiled)streamSpec;
            triggereventTypeName = filterStreamSpec.getFilterSpec().getFilterForEventTypeName();
        } else if (streamSpec instanceof NamedWindowConsumerStreamSpec) {
            NamedWindowConsumerStreamSpec namedSpec = (NamedWindowConsumerStreamSpec)streamSpec;
            triggereventTypeName = namedSpec.getWindowName();
        } else {
            throw new ExprValidationException("Unknown stream specification streamEventType: " + streamSpec);
        }
        String streamName = triggereventTypeName;
        if (updateSpec.getOptionalStreamName() != null) {
            streamName = updateSpec.getOptionalStreamName();
        }
        EventType streamEventType = this.services.getEventAdapterService().getExistsTypeByName(triggereventTypeName);
        StreamTypeServiceImpl typeService = new StreamTypeServiceImpl(new EventType[]{streamEventType}, new String[]{streamName}, new boolean[]{true}, this.services.getEngineURI(), false);
        ExprEvaluatorContextStatement evaluatorContextStmt = new ExprEvaluatorContextStatement(this.statementContext);
        this.statementContext.getStatementResultService().setSelectClause(new Class[]{streamEventType.getUnderlyingType()}, new String[]{"*"}, false, null, evaluatorContextStmt);
        SubSelectStrategyCollection subSelectStrategyCollection = EPStatementStartMethodHelperSubselect.planSubSelect(this.services, this.statementContext, this.queryPlanLogging, subSelectStreamDesc, new String[]{streamName}, new EventType[]{streamEventType}, new String[]{triggereventTypeName}, stopCallbacks, this.statementSpec.getAnnotations(), this.statementSpec.getDeclaredExpressions(), null);
        ExprValidationContext validationContext = new ExprValidationContext(typeService, this.statementContext.getMethodResolutionService(), null, this.statementContext.getSchedulingService(), this.statementContext.getVariableService(), evaluatorContextStmt, this.statementContext.getEventAdapterService(), this.statementContext.getStatementName(), this.statementContext.getStatementId(), this.statementContext.getAnnotations(), this.statementContext.getContextDescriptor());
        for (OnTriggerSetAssignment assignment : updateSpec.getAssignments()) {
            ExprNode validated = ExprNodeUtility.getValidatedSubtree(assignment.getExpression(), validationContext);
            assignment.setExpression(validated);
            EPStatementStartMethodHelperValidate.validateNoAggregations(validated, "Aggregation functions may not be used within an update-clause");
        }
        if (updateSpec.getOptionalWhereClause() != null) {
            ExprNode validated = ExprNodeUtility.getValidatedSubtree(updateSpec.getOptionalWhereClause(), validationContext);
            updateSpec.setOptionalWhereClause(validated);
            EPStatementStartMethodHelperValidate.validateNoAggregations(validated, "Aggregation functions may not be used within an update-clause");
        }
        InternalRoutePreprocessView onExprView = new InternalRoutePreprocessView(streamEventType, this.statementContext.getStatementResultService());
        InternalEventRouterDesc routerDesc = this.services.getInternalEventRouter().getValidatePreprocessing(onExprView.getEventType(), updateSpec, this.statementContext.getAnnotations());
        StatementAgentInstanceFactoryUpdate contextFactory = new StatementAgentInstanceFactoryUpdate(this.statementContext, this.services, streamEventType, updateSpec, onExprView, routerDesc, subSelectStrategyCollection);
        if (this.statementSpec.getOptionalContextName() != null) {
            AIRegistryExpr aiRegistryExpr = this.statementContext.getStatementAgentInstanceRegistry().getAgentInstanceExprService();
            subselectStrategyInstances = new HashMap();
            for (ExprSubselectNode node : subSelectStrategyCollection.getSubqueries().keySet()) {
                AIRegistrySubselect specificService = aiRegistryExpr.allocateSubselect(node);
                node.setStrategy(specificService);
                subselectStrategyInstances.put(node, new SubSelectStrategyHolder(null, null, null, null));
            }
            ContextMergeView mergeView = new ContextMergeView(onExprView.getEventType());
            finalViewable = mergeView;
            ContextManagedStatementOnTriggerDesc statement = new ContextManagedStatementOnTriggerDesc(this.statementSpec, this.statementContext, mergeView, contextFactory);
            this.services.getContextManagementService().addStatement(this.statementSpec.getOptionalContextName(), statement);
            stopStatementMethod = new EPStatementStopMethod(){

                @Override
                public void stop() {
                    EPStatementStartMethodUpdate.this.services.getContextManagementService().stoppedStatement(contextName, EPStatementStartMethodUpdate.this.statementContext.getStatementName(), EPStatementStartMethodUpdate.this.statementContext.getStatementId());
                    stopMethod.stop();
                }
            };
            destroyStatementMethod = new EPStatementDestroyMethod(){

                @Override
                public void destroy() {
                    EPStatementStartMethodUpdate.this.services.getContextManagementService().destroyedStatement(EPStatementStartMethodUpdate.this.statementSpec.getOptionalContextName(), EPStatementStartMethodUpdate.this.statementContext.getStatementName(), EPStatementStartMethodUpdate.this.statementContext.getStatementId());
                }
            };
        } else {
            AgentInstanceContext agentInstanceContext = this.getDefaultAgentInstanceContext();
            final StatementAgentInstanceFactoryUpdateResult resultOfStart = contextFactory.newContext(agentInstanceContext);
            finalViewable = resultOfStart.getFinalView();
            stopStatementMethod = new EPStatementStopMethod(){

                @Override
                public void stop() {
                    resultOfStart.getStopCallback().stop();
                    stopMethod.stop();
                }
            };
            destroyStatementMethod = null;
            subselectStrategyInstances = resultOfStart.getSubselectStrategies();
        }
        EPStatementStartMethodHelperAssignExpr.assignSubqueryStrategies(subSelectStrategyCollection, subselectStrategyInstances);
        return new EPStatementStartResult(finalViewable, stopStatementMethod, destroyStatementMethod);
    }
}

