/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.epl.agg.AggregationAccess;
import com.espertech.esper.epl.agg.AggregationAccessorSlotPair;
import com.espertech.esper.epl.agg.AggregationMethod;
import com.espertech.esper.epl.agg.AggregationServiceBaseUngrouped;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import java.util.Collection;

public class AggSvcGroupAllMixedAccessImpl
extends AggregationServiceBaseUngrouped {
    private final AggregationAccessorSlotPair[] accessors;
    private AggregationAccess[] accesses;

    public AggSvcGroupAllMixedAccessImpl(ExprEvaluator[] evaluators, AggregationMethod[] aggregators, AggregationAccessorSlotPair[] accessors, AggregationAccess[] accesses) {
        super(evaluators, aggregators);
        this.accessors = accessors;
        this.accesses = accesses;
    }

    @Override
    public void applyEnter(EventBean[] eventsPerStream, MultiKeyUntyped optionalGroupKeyPerRow, ExprEvaluatorContext exprEvaluatorContext) {
        for (int j = 0; j < this.evaluators.length; ++j) {
            Object columnResult = this.evaluators[j].evaluate(eventsPerStream, true, exprEvaluatorContext);
            this.aggregators[j].enter(columnResult);
        }
        for (AggregationAccess access : this.accesses) {
            access.applyEnter(eventsPerStream);
        }
    }

    @Override
    public void applyLeave(EventBean[] eventsPerStream, MultiKeyUntyped optionalGroupKeyPerRow, ExprEvaluatorContext exprEvaluatorContext) {
        for (int j = 0; j < this.evaluators.length; ++j) {
            Object columnResult = this.evaluators[j].evaluate(eventsPerStream, false, exprEvaluatorContext);
            this.aggregators[j].leave(columnResult);
        }
        for (AggregationAccess access : this.accesses) {
            access.applyLeave(eventsPerStream);
        }
    }

    @Override
    public void setCurrentAccess(MultiKeyUntyped groupKey, int[] agentInstanceIds) {
    }

    @Override
    public Object getValue(int column, int[] agentInstanceIds) {
        if (column < this.aggregators.length) {
            return this.aggregators[column].getValue();
        }
        AggregationAccessorSlotPair pair = this.accessors[column - this.aggregators.length];
        return pair.getAccessor().getValue(this.accesses[pair.getSlot()]);
    }

    @Override
    public Collection<EventBean> getCollection(int column, ExprEvaluatorContext context) {
        if (column < this.aggregators.length) {
            return null;
        }
        AggregationAccessorSlotPair pair = this.accessors[column - this.aggregators.length];
        return pair.getAccessor().getCollectionReadOnly(this.accesses[pair.getSlot()]);
    }

    @Override
    public EventBean getEventBean(int column, ExprEvaluatorContext context) {
        if (column < this.aggregators.length) {
            return null;
        }
        AggregationAccessorSlotPair pair = this.accessors[column - this.aggregators.length];
        return pair.getAccessor().getEventBean(this.accesses[pair.getSlot()]);
    }

    @Override
    public void clearResults(ExprEvaluatorContext exprEvaluatorContext) {
        for (AggregationAccess access : this.accesses) {
            access.clear();
        }
        for (AggregationMethod aggregator : this.aggregators) {
            aggregator.clear();
        }
    }
}

