/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.epl.agg.AggregationAccess;
import com.espertech.esper.epl.agg.AggregationAccessUtil;
import com.espertech.esper.epl.agg.AggregationAccessorSlotPair;
import com.espertech.esper.epl.agg.AggregationResultFuture;
import com.espertech.esper.epl.agg.AggregationService;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class AggSvcGroupByAccessOnlyImpl
implements AggregationService,
AggregationResultFuture {
    private final MethodResolutionService methodResolutionService;
    private final Map<MultiKeyUntyped, AggregationAccess[]> accessMap;
    private final AggregationAccessorSlotPair[] accessors;
    private final int[] streams;
    private final boolean isJoin;
    private AggregationAccess[] currentAccess;

    public AggSvcGroupByAccessOnlyImpl(MethodResolutionService methodResolutionService, AggregationAccessorSlotPair[] accessors, int[] streams, boolean isJoin) {
        this.methodResolutionService = methodResolutionService;
        this.accessMap = new HashMap<MultiKeyUntyped, AggregationAccess[]>();
        this.accessors = accessors;
        this.streams = streams;
        this.isJoin = isJoin;
    }

    @Override
    public void applyEnter(EventBean[] eventsPerStream, MultiKeyUntyped groupKey, ExprEvaluatorContext exprEvaluatorContext) {
        AggregationAccess[] row;
        for (AggregationAccess access : row = this.getAssertRow(exprEvaluatorContext.getAgentInstanceIds(), groupKey)) {
            access.applyEnter(eventsPerStream);
        }
    }

    @Override
    public void applyLeave(EventBean[] eventsPerStream, MultiKeyUntyped groupKey, ExprEvaluatorContext exprEvaluatorContext) {
        AggregationAccess[] row;
        for (AggregationAccess access : row = this.getAssertRow(exprEvaluatorContext.getAgentInstanceIds(), groupKey)) {
            access.applyLeave(eventsPerStream);
        }
    }

    @Override
    public void setCurrentAccess(MultiKeyUntyped groupKey, int[] agentInstanceIds) {
        this.currentAccess = this.getAssertRow(agentInstanceIds, groupKey);
    }

    @Override
    public Object getValue(int column, int[] agentInstanceIds) {
        AggregationAccessorSlotPair pair = this.accessors[column];
        return pair.getAccessor().getValue(this.currentAccess[pair.getSlot()]);
    }

    @Override
    public Collection<EventBean> getCollection(int column, ExprEvaluatorContext context) {
        AggregationAccessorSlotPair pair = this.accessors[column];
        return pair.getAccessor().getCollectionReadOnly(this.currentAccess[pair.getSlot()]);
    }

    @Override
    public EventBean getEventBean(int column, ExprEvaluatorContext context) {
        AggregationAccessorSlotPair pair = this.accessors[column];
        return pair.getAccessor().getEventBean(this.currentAccess[pair.getSlot()]);
    }

    @Override
    public void clearResults(ExprEvaluatorContext exprEvaluatorContext) {
        this.accessMap.clear();
    }

    private AggregationAccess[] getAssertRow(int[] agentInstanceId, MultiKeyUntyped groupKey) {
        AggregationAccess[] row = this.accessMap.get(groupKey);
        if (row != null) {
            return row;
        }
        row = AggregationAccessUtil.getNewAccesses(agentInstanceId, this.isJoin, this.streams, this.methodResolutionService, groupKey);
        this.accessMap.put(groupKey, row);
        return row;
    }
}

