/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.epl.agg.AggregationAccess;
import com.espertech.esper.epl.agg.AggregationAccessUtil;
import com.espertech.esper.epl.agg.AggregationAccessorSlotPair;
import com.espertech.esper.epl.agg.AggregationMethod;
import com.espertech.esper.epl.agg.AggregationMethodFactory;
import com.espertech.esper.epl.agg.AggregationRowPair;
import com.espertech.esper.epl.agg.AggregationServiceBaseGrouped;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class AggSvcGroupByMixedAccessImpl
extends AggregationServiceBaseGrouped {
    private final AggregationAccessorSlotPair[] accessorsFactory;
    private final int[] streams;
    private final boolean isJoin;
    private Map<MultiKeyUntyped, AggregationRowPair> aggregatorsPerGroup;
    private AggregationRowPair currentAggregatorRow;
    private MethodResolutionService methodResolutionService;

    public AggSvcGroupByMixedAccessImpl(ExprEvaluator[] evaluators, AggregationMethodFactory[] prototypes, MethodResolutionService methodResolutionService, AggregationAccessorSlotPair[] accessorsFactory, int[] streams, boolean isJoin) {
        super(evaluators, prototypes);
        this.accessorsFactory = accessorsFactory;
        this.streams = streams;
        this.isJoin = isJoin;
        this.methodResolutionService = methodResolutionService;
        this.aggregatorsPerGroup = new HashMap<MultiKeyUntyped, AggregationRowPair>();
    }

    @Override
    public void clearResults(ExprEvaluatorContext exprEvaluatorContext) {
        this.aggregatorsPerGroup.clear();
    }

    @Override
    public void applyEnter(EventBean[] eventsPerStream, MultiKeyUntyped groupByKey, ExprEvaluatorContext exprEvaluatorContext) {
        AggregationRowPair groupAggregators = this.aggregatorsPerGroup.get(groupByKey);
        if (groupAggregators == null) {
            AggregationMethod[] methods = this.methodResolutionService.newAggregators(this.aggregators, exprEvaluatorContext.getAgentInstanceIds(), groupByKey);
            AggregationAccess[] accesses = AggregationAccessUtil.getNewAccesses(exprEvaluatorContext.getAgentInstanceIds(), this.isJoin, this.streams, this.methodResolutionService, groupByKey);
            groupAggregators = new AggregationRowPair(methods, accesses);
            this.aggregatorsPerGroup.put(groupByKey, groupAggregators);
        }
        this.currentAggregatorRow = groupAggregators;
        AggregationMethod[] groupAggMethods = groupAggregators.getMethods();
        for (int j = 0; j < this.evaluators.length; ++j) {
            Object columnResult = this.evaluators[j].evaluate(eventsPerStream, true, exprEvaluatorContext);
            groupAggMethods[j].enter(columnResult);
        }
        for (AggregationAccess access : this.currentAggregatorRow.getAccesses()) {
            access.applyEnter(eventsPerStream);
        }
    }

    @Override
    public void applyLeave(EventBean[] eventsPerStream, MultiKeyUntyped groupByKey, ExprEvaluatorContext exprEvaluatorContext) {
        AggregationRowPair groupAggregators = this.aggregatorsPerGroup.get(groupByKey);
        if (groupAggregators == null) {
            AggregationMethod[] methods = this.methodResolutionService.newAggregators(this.aggregators, exprEvaluatorContext.getAgentInstanceIds(), groupByKey);
            AggregationAccess[] accesses = AggregationAccessUtil.getNewAccesses(exprEvaluatorContext.getAgentInstanceIds(), this.isJoin, this.streams, this.methodResolutionService, groupByKey);
            groupAggregators = new AggregationRowPair(methods, accesses);
            this.aggregatorsPerGroup.put(groupByKey, groupAggregators);
        }
        this.currentAggregatorRow = groupAggregators;
        AggregationMethod[] groupAggMethods = groupAggregators.getMethods();
        for (int j = 0; j < this.evaluators.length; ++j) {
            Object columnResult = this.evaluators[j].evaluate(eventsPerStream, false, exprEvaluatorContext);
            groupAggMethods[j].leave(columnResult);
        }
        for (AggregationAccess access : this.currentAggregatorRow.getAccesses()) {
            access.applyLeave(eventsPerStream);
        }
    }

    @Override
    public void setCurrentAccess(MultiKeyUntyped groupByKey, int[] agentInstanceIds) {
        this.currentAggregatorRow = this.aggregatorsPerGroup.get(groupByKey);
        if (this.currentAggregatorRow == null) {
            AggregationMethod[] methods = this.methodResolutionService.newAggregators(this.aggregators, agentInstanceIds, groupByKey);
            AggregationAccess[] accesses = AggregationAccessUtil.getNewAccesses(agentInstanceIds, this.isJoin, this.streams, this.methodResolutionService, groupByKey);
            this.currentAggregatorRow = new AggregationRowPair(methods, accesses);
            this.aggregatorsPerGroup.put(groupByKey, this.currentAggregatorRow);
        }
    }

    @Override
    public Object getValue(int column, int[] agentInstanceIds) {
        if (column < this.aggregators.length) {
            return this.currentAggregatorRow.getMethods()[column].getValue();
        }
        AggregationAccessorSlotPair pair = this.accessorsFactory[column - this.aggregators.length];
        return pair.getAccessor().getValue(this.currentAggregatorRow.getAccesses()[pair.getSlot()]);
    }

    @Override
    public Collection<EventBean> getCollection(int column, ExprEvaluatorContext context) {
        if (column < this.aggregators.length) {
            return null;
        }
        AggregationAccessorSlotPair pair = this.accessorsFactory[column - this.aggregators.length];
        return pair.getAccessor().getCollectionReadOnly(this.currentAggregatorRow.getAccesses()[pair.getSlot()]);
    }

    @Override
    public EventBean getEventBean(int column, ExprEvaluatorContext context) {
        if (column < this.aggregators.length) {
            return null;
        }
        AggregationAccessorSlotPair pair = this.accessorsFactory[column - this.aggregators.length];
        return pair.getAccessor().getEventBean(this.currentAggregatorRow.getAccesses()[pair.getSlot()]);
    }
}

