/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.epl.agg.AggregationMethod;
import com.espertech.esper.epl.agg.AggregationMethodFactory;
import com.espertech.esper.epl.agg.AggregationServiceBaseGrouped;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class AggSvcGroupByNoAccessImpl
extends AggregationServiceBaseGrouped {
    private Map<MultiKeyUntyped, AggregationMethod[]> aggregatorsPerGroup;
    private AggregationMethod[] currentAggregatorRow;
    private MethodResolutionService methodResolutionService;

    public AggSvcGroupByNoAccessImpl(ExprEvaluator[] evaluators, AggregationMethodFactory[] prototypes, MethodResolutionService methodResolutionService) {
        super(evaluators, prototypes);
        this.methodResolutionService = methodResolutionService;
        this.aggregatorsPerGroup = new HashMap<MultiKeyUntyped, AggregationMethod[]>();
    }

    @Override
    public void clearResults(ExprEvaluatorContext exprEvaluatorContext) {
        this.aggregatorsPerGroup.clear();
    }

    @Override
    public void applyEnter(EventBean[] eventsPerStream, MultiKeyUntyped groupByKey, ExprEvaluatorContext exprEvaluatorContext) {
        AggregationMethod[] groupAggregators = this.aggregatorsPerGroup.get(groupByKey);
        if (groupAggregators == null) {
            groupAggregators = this.methodResolutionService.newAggregators(this.aggregators, exprEvaluatorContext.getAgentInstanceIds(), groupByKey);
            this.aggregatorsPerGroup.put(groupByKey, groupAggregators);
        }
        this.currentAggregatorRow = groupAggregators;
        for (int j = 0; j < this.evaluators.length; ++j) {
            Object columnResult = this.evaluators[j].evaluate(eventsPerStream, true, exprEvaluatorContext);
            groupAggregators[j].enter(columnResult);
        }
    }

    @Override
    public void applyLeave(EventBean[] eventsPerStream, MultiKeyUntyped groupByKey, ExprEvaluatorContext exprEvaluatorContext) {
        AggregationMethod[] groupAggregators = this.aggregatorsPerGroup.get(groupByKey);
        if (groupAggregators == null) {
            groupAggregators = this.methodResolutionService.newAggregators(this.aggregators, exprEvaluatorContext.getAgentInstanceIds(), groupByKey);
            this.aggregatorsPerGroup.put(groupByKey, groupAggregators);
        }
        this.currentAggregatorRow = groupAggregators;
        for (int j = 0; j < this.evaluators.length; ++j) {
            Object columnResult = this.evaluators[j].evaluate(eventsPerStream, false, exprEvaluatorContext);
            groupAggregators[j].leave(columnResult);
        }
    }

    @Override
    public void setCurrentAccess(MultiKeyUntyped groupByKey, int[] agentInstanceIds) {
        this.currentAggregatorRow = this.aggregatorsPerGroup.get(groupByKey);
        if (this.currentAggregatorRow == null) {
            this.currentAggregatorRow = this.methodResolutionService.newAggregators(this.aggregators, agentInstanceIds, groupByKey);
            this.aggregatorsPerGroup.put(groupByKey, this.currentAggregatorRow);
        }
    }

    @Override
    public Object getValue(int column, int[] agentInstanceIds) {
        return this.currentAggregatorRow[column].getValue();
    }

    @Override
    public Collection<EventBean> getCollection(int column, ExprEvaluatorContext context) {
        return null;
    }

    @Override
    public EventBean getEventBean(int column, ExprEvaluatorContext context) {
        return null;
    }
}

