/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg;

import com.espertech.esper.client.annotation.Hint;
import com.espertech.esper.client.annotation.HintEnum;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.agg.AggSvcGroupByReclaimAgedEvalFunc;
import com.espertech.esper.epl.agg.AggSvcGroupByReclaimAgedEvalFuncConstant;
import com.espertech.esper.epl.agg.AggSvcGroupByReclaimAgedEvalFuncVariable;
import com.espertech.esper.epl.agg.AggSvcGroupByReclaimAgedImpl;
import com.espertech.esper.epl.agg.AggregationAccessorSlotPair;
import com.espertech.esper.epl.agg.AggregationMethodFactory;
import com.espertech.esper.epl.agg.AggregationService;
import com.espertech.esper.epl.agg.AggregationServiceFactoryBase;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.variable.VariableReader;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.type.DoubleValue;
import com.espertech.esper.util.JavaClassHelper;

public class AggSvcGroupByReclaimAgedFactory
extends AggregationServiceFactoryBase {
    private static final long DEFAULT_MAX_AGE_MSEC = 60000L;
    private final AggregationAccessorSlotPair[] accessors;
    private final int[] streams;
    private final boolean isJoin;
    private MethodResolutionService methodResolutionService;
    private final AggSvcGroupByReclaimAgedEvalFunc evaluationFunctionMaxAge;
    private final AggSvcGroupByReclaimAgedEvalFunc evaluationFunctionFrequency;
    private volatile long currentReclaimFrequency = 60000L;

    public AggSvcGroupByReclaimAgedFactory(ExprEvaluator[] evaluators, AggregationMethodFactory[] prototypes, MethodResolutionService methodResolutionService, Hint reclaimGroupAged, Hint reclaimGroupFrequency, VariableService variableService, AggregationAccessorSlotPair[] accessors, int[] streams, boolean isJoin) throws ExprValidationException {
        super(evaluators, prototypes);
        this.methodResolutionService = methodResolutionService;
        this.accessors = accessors;
        this.streams = streams;
        this.isJoin = isJoin;
        String hintValueMaxAge = HintEnum.RECLAIM_GROUP_AGED.getHintAssignedValue(reclaimGroupAged);
        if (hintValueMaxAge == null) {
            throw new ExprValidationException("Required hint value for hint '" + (Object)((Object)HintEnum.RECLAIM_GROUP_AGED) + "' has not been provided");
        }
        this.evaluationFunctionMaxAge = this.getEvaluationFunction(variableService, hintValueMaxAge);
        String hintValueFrequency = HintEnum.RECLAIM_GROUP_FREQ.getHintAssignedValue(reclaimGroupAged);
        if (reclaimGroupFrequency == null || hintValueFrequency == null) {
            this.evaluationFunctionFrequency = this.evaluationFunctionMaxAge;
            this.currentReclaimFrequency = this.getReclaimFrequency(this.currentReclaimFrequency);
        } else {
            this.evaluationFunctionFrequency = this.getEvaluationFunction(variableService, hintValueFrequency);
        }
    }

    @Override
    public AggregationService makeService(AgentInstanceContext agentInstanceContext) {
        return new AggSvcGroupByReclaimAgedImpl(this.evaluators, this.aggregators, this.accessors, this.streams, this.isJoin, this.evaluationFunctionMaxAge, this.evaluationFunctionFrequency, this.methodResolutionService);
    }

    private AggSvcGroupByReclaimAgedEvalFunc getEvaluationFunction(VariableService variableService, String hintValue) throws ExprValidationException {
        Double valueDouble;
        VariableReader variableReader = variableService.getReader(hintValue);
        if (variableReader != null) {
            if (!JavaClassHelper.isNumeric(variableReader.getType())) {
                throw new ExprValidationException("Variable type of variable '" + variableReader.getVariableName() + "' is not numeric");
            }
            return new AggSvcGroupByReclaimAgedEvalFuncVariable(variableReader);
        }
        try {
            valueDouble = DoubleValue.parseString(hintValue);
        }
        catch (RuntimeException ex) {
            throw new ExprValidationException("Failed to parse hint parameter value '" + hintValue + "' as a double-typed seconds value or variable name");
        }
        if (valueDouble <= 0.0) {
            throw new ExprValidationException("Hint parameter value '" + hintValue + "' is an invalid value, expecting a double-typed seconds value or variable name");
        }
        return new AggSvcGroupByReclaimAgedEvalFuncConstant(valueDouble);
    }

    private long getReclaimFrequency(long currentReclaimFrequency) {
        Double frequency = this.evaluationFunctionFrequency.getLongValue();
        if (frequency == null || frequency <= 0.0) {
            return currentReclaimFrequency;
        }
        return Math.round(frequency * 1000.0);
    }
}

