/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.epl.agg.AggSvcGroupByReclaimAgedEvalFunc;
import com.espertech.esper.epl.agg.AggregationAccess;
import com.espertech.esper.epl.agg.AggregationAccessUtil;
import com.espertech.esper.epl.agg.AggregationAccessorSlotPair;
import com.espertech.esper.epl.agg.AggregationMethod;
import com.espertech.esper.epl.agg.AggregationMethodFactory;
import com.espertech.esper.epl.agg.AggregationMethodRowAged;
import com.espertech.esper.epl.agg.AggregationServiceBaseGrouped;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.util.ExecutionPathDebugLog;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AggSvcGroupByReclaimAgedImpl
extends AggregationServiceBaseGrouped {
    private static final Log log = LogFactory.getLog(AggSvcGroupByReclaimAgedImpl.class);
    private static final long DEFAULT_MAX_AGE_MSEC = 60000L;
    private final AggregationAccessorSlotPair[] accessors;
    private final int[] streams;
    private final boolean isJoin;
    private final AggSvcGroupByReclaimAgedEvalFunc evaluationFunctionMaxAge;
    private final AggSvcGroupByReclaimAgedEvalFunc evaluationFunctionFrequency;
    private final MethodResolutionService methodResolutionService;
    private Map<MultiKeyUntyped, AggregationMethodRowAged> aggregatorsPerGroup;
    private AggregationMethod[] currentAggregatorMethods;
    private AggregationAccess[] currentAggregatorAccesses;
    private List<MultiKeyUntyped> removedKeys;
    private Long nextSweepTime = null;
    private volatile long currentMaxAge = 60000L;
    private volatile long currentReclaimFrequency = 60000L;

    public AggSvcGroupByReclaimAgedImpl(ExprEvaluator[] evaluators, AggregationMethodFactory[] aggregators, AggregationAccessorSlotPair[] accessors, int[] streams, boolean join, AggSvcGroupByReclaimAgedEvalFunc evaluationFunctionMaxAge, AggSvcGroupByReclaimAgedEvalFunc evaluationFunctionFrequency, MethodResolutionService methodResolutionService) {
        super(evaluators, aggregators);
        this.accessors = accessors;
        this.streams = streams;
        this.isJoin = join;
        this.evaluationFunctionMaxAge = evaluationFunctionMaxAge;
        this.evaluationFunctionFrequency = evaluationFunctionFrequency;
        this.methodResolutionService = methodResolutionService;
        this.aggregatorsPerGroup = new HashMap<MultiKeyUntyped, AggregationMethodRowAged>();
        this.removedKeys = new ArrayList<MultiKeyUntyped>();
    }

    @Override
    public void clearResults(ExprEvaluatorContext exprEvaluatorContext) {
        this.aggregatorsPerGroup.clear();
    }

    @Override
    public void applyEnter(EventBean[] eventsPerStream, MultiKeyUntyped groupByKey, ExprEvaluatorContext exprEvaluatorContext) {
        AggregationAccess[] groupAccesses;
        AggregationMethod[] groupAggregators;
        AggregationMethodRowAged row;
        long currentTime = exprEvaluatorContext.getTimeProvider().getTime();
        if (this.nextSweepTime == null || this.nextSweepTime <= currentTime) {
            this.currentMaxAge = this.getMaxAge(this.currentMaxAge);
            this.currentReclaimFrequency = this.getReclaimFrequency(this.currentReclaimFrequency);
            if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
                log.debug((Object)("Reclaiming groups older then " + this.currentMaxAge + " msec and every " + this.currentReclaimFrequency + "msec in frequency"));
            }
            this.nextSweepTime = currentTime + this.currentReclaimFrequency;
            this.sweep(currentTime, this.currentMaxAge);
        }
        if (!this.removedKeys.isEmpty()) {
            for (MultiKeyUntyped removedKey : this.removedKeys) {
                this.aggregatorsPerGroup.remove(removedKey);
            }
            this.removedKeys.clear();
        }
        if ((row = this.aggregatorsPerGroup.get(groupByKey)) == null) {
            groupAggregators = this.methodResolutionService.newAggregators(this.aggregators, exprEvaluatorContext.getAgentInstanceIds(), groupByKey);
            groupAccesses = AggregationAccessUtil.getNewAccesses(exprEvaluatorContext.getAgentInstanceIds(), this.isJoin, this.streams, this.methodResolutionService, groupByKey);
            row = new AggregationMethodRowAged(this.methodResolutionService.getCurrentRowCount(groupAggregators, groupAccesses) + 1L, currentTime, groupAggregators, groupAccesses);
            this.aggregatorsPerGroup.put(groupByKey, row);
        } else {
            groupAggregators = row.getMethods();
            groupAccesses = row.getAccesses();
            row.increaseRefcount();
            row.setLastUpdateTime(currentTime);
        }
        this.currentAggregatorMethods = groupAggregators;
        this.currentAggregatorAccesses = groupAccesses;
        for (int j = 0; j < this.evaluators.length; ++j) {
            Object columnResult = this.evaluators[j].evaluate(eventsPerStream, true, exprEvaluatorContext);
            groupAggregators[j].enter(columnResult);
        }
        for (AggregationAccess access : this.currentAggregatorAccesses) {
            access.applyEnter(eventsPerStream);
        }
    }

    private void sweep(long currentTime, long currentMaxAge) {
        ArrayDeque<MultiKeyUntyped> removed = new ArrayDeque<MultiKeyUntyped>();
        for (Map.Entry<MultiKeyUntyped, AggregationMethodRowAged> entry : this.aggregatorsPerGroup.entrySet()) {
            long age = currentTime - entry.getValue().getLastUpdateTime();
            if (age <= currentMaxAge) continue;
            removed.add(entry.getKey());
        }
        for (MultiKeyUntyped key : removed) {
            this.aggregatorsPerGroup.remove(key);
        }
    }

    private long getMaxAge(long currentMaxAge) {
        Double maxAge = this.evaluationFunctionMaxAge.getLongValue();
        if (maxAge == null || maxAge <= 0.0) {
            return currentMaxAge;
        }
        return Math.round(maxAge * 1000.0);
    }

    private long getReclaimFrequency(long currentReclaimFrequency) {
        Double frequency = this.evaluationFunctionFrequency.getLongValue();
        if (frequency == null || frequency <= 0.0) {
            return currentReclaimFrequency;
        }
        return Math.round(frequency * 1000.0);
    }

    @Override
    public void applyLeave(EventBean[] eventsPerStream, MultiKeyUntyped groupByKey, ExprEvaluatorContext exprEvaluatorContext) {
        AggregationAccess[] groupAccesses;
        AggregationMethod[] groupAggregators;
        AggregationMethodRowAged row = this.aggregatorsPerGroup.get(groupByKey);
        long currentTime = exprEvaluatorContext.getTimeProvider().getTime();
        if (row != null) {
            groupAggregators = row.getMethods();
            groupAccesses = row.getAccesses();
        } else {
            groupAggregators = this.methodResolutionService.newAggregators(this.aggregators, exprEvaluatorContext.getAgentInstanceIds(), groupByKey);
            groupAccesses = AggregationAccessUtil.getNewAccesses(exprEvaluatorContext.getAgentInstanceIds(), this.isJoin, this.streams, this.methodResolutionService, groupByKey);
            row = new AggregationMethodRowAged(this.methodResolutionService.getCurrentRowCount(groupAggregators, groupAccesses) + 1L, currentTime, groupAggregators, groupAccesses);
            this.aggregatorsPerGroup.put(groupByKey, row);
        }
        this.currentAggregatorMethods = groupAggregators;
        this.currentAggregatorAccesses = groupAccesses;
        for (int j = 0; j < this.evaluators.length; ++j) {
            Object columnResult = this.evaluators[j].evaluate(eventsPerStream, false, exprEvaluatorContext);
            groupAggregators[j].leave(columnResult);
        }
        for (AggregationAccess access : this.currentAggregatorAccesses) {
            access.applyLeave(eventsPerStream);
        }
        row.decreaseRefcount();
        row.setLastUpdateTime(currentTime);
        if (row.getRefcount() <= 0L) {
            this.removedKeys.add(groupByKey);
            this.methodResolutionService.removeAggregators(exprEvaluatorContext.getAgentInstanceIds(), groupByKey);
        }
    }

    @Override
    public void setCurrentAccess(MultiKeyUntyped groupByKey, int[] agentInstanceIds) {
        AggregationMethodRowAged row = this.aggregatorsPerGroup.get(groupByKey);
        if (row != null) {
            this.currentAggregatorMethods = row.getMethods();
            this.currentAggregatorAccesses = row.getAccesses();
        } else {
            this.currentAggregatorMethods = null;
        }
        if (this.currentAggregatorMethods == null) {
            this.currentAggregatorMethods = this.methodResolutionService.newAggregators(this.aggregators, agentInstanceIds, groupByKey);
            this.currentAggregatorAccesses = AggregationAccessUtil.getNewAccesses(agentInstanceIds, this.isJoin, this.streams, this.methodResolutionService, groupByKey);
        }
    }

    @Override
    public Object getValue(int column, int[] agentInstanceIds) {
        if (column < this.aggregators.length) {
            return this.currentAggregatorMethods[column].getValue();
        }
        AggregationAccessorSlotPair pair = this.accessors[column - this.aggregators.length];
        return pair.getAccessor().getValue(this.currentAggregatorAccesses[pair.getSlot()]);
    }

    @Override
    public Collection<EventBean> getCollection(int column, ExprEvaluatorContext context) {
        if (column < this.aggregators.length) {
            return null;
        }
        AggregationAccessorSlotPair pair = this.accessors[column - this.aggregators.length];
        return pair.getAccessor().getCollectionReadOnly(this.currentAggregatorAccesses[pair.getSlot()]);
    }

    @Override
    public EventBean getEventBean(int column, ExprEvaluatorContext context) {
        if (column < this.aggregators.length) {
            return null;
        }
        AggregationAccessorSlotPair pair = this.accessors[column - this.aggregators.length];
        return pair.getAccessor().getEventBean(this.currentAggregatorAccesses[pair.getSlot()]);
    }
}

