/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.epl.agg.AggregationAccess;
import com.espertech.esper.epl.agg.AggregationAccessUtil;
import com.espertech.esper.epl.agg.AggregationAccessorSlotPair;
import com.espertech.esper.epl.agg.AggregationMethod;
import com.espertech.esper.epl.agg.AggregationMethodFactory;
import com.espertech.esper.epl.agg.AggregationMethodPairRow;
import com.espertech.esper.epl.agg.AggregationServiceBaseGrouped;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AggSvcGroupByRefcountedWAccessImpl
extends AggregationServiceBaseGrouped {
    private final AggregationAccessorSlotPair[] accessors;
    private final int[] streams;
    private final boolean isJoin;
    private Map<MultiKeyUntyped, AggregationMethodPairRow> aggregatorsPerGroup;
    private AggregationMethod[] currentAggregatorMethods;
    private AggregationAccess[] currentAggregatorAccesses;
    private MethodResolutionService methodResolutionService;
    private List<MultiKeyUntyped> removedKeys;

    public AggSvcGroupByRefcountedWAccessImpl(ExprEvaluator[] evaluators, AggregationMethodFactory[] prototypes, MethodResolutionService methodResolutionService, AggregationAccessorSlotPair[] accessors, int[] streams, boolean isJoin) {
        super(evaluators, prototypes);
        this.methodResolutionService = methodResolutionService;
        this.aggregatorsPerGroup = new HashMap<MultiKeyUntyped, AggregationMethodPairRow>();
        this.accessors = accessors;
        this.streams = streams;
        this.isJoin = isJoin;
        this.removedKeys = new ArrayList<MultiKeyUntyped>();
    }

    @Override
    public void clearResults(ExprEvaluatorContext exprEvaluatorContext) {
        this.aggregatorsPerGroup.clear();
    }

    @Override
    public void applyEnter(EventBean[] eventsPerStream, MultiKeyUntyped groupByKey, ExprEvaluatorContext exprEvaluatorContext) {
        AggregationAccess[] groupAccesses;
        AggregationMethod[] groupAggregators;
        AggregationMethodPairRow row;
        if (!this.removedKeys.isEmpty()) {
            for (MultiKeyUntyped removedKey : this.removedKeys) {
                this.aggregatorsPerGroup.remove(removedKey);
            }
            this.removedKeys.clear();
        }
        if ((row = this.aggregatorsPerGroup.get(groupByKey)) == null) {
            groupAggregators = this.methodResolutionService.newAggregators(this.aggregators, exprEvaluatorContext.getAgentInstanceIds(), groupByKey);
            groupAccesses = AggregationAccessUtil.getNewAccesses(exprEvaluatorContext.getAgentInstanceIds(), this.isJoin, this.streams, this.methodResolutionService, groupByKey);
            row = new AggregationMethodPairRow(this.methodResolutionService.getCurrentRowCount(groupAggregators, groupAccesses) + 1L, groupAggregators, groupAccesses);
            this.aggregatorsPerGroup.put(groupByKey, row);
        } else {
            groupAggregators = row.getMethods();
            groupAccesses = row.getAccesses();
            row.increaseRefcount();
        }
        this.currentAggregatorMethods = groupAggregators;
        this.currentAggregatorAccesses = groupAccesses;
        for (int j = 0; j < this.evaluators.length; ++j) {
            Object columnResult = this.evaluators[j].evaluate(eventsPerStream, true, exprEvaluatorContext);
            groupAggregators[j].enter(columnResult);
        }
        for (AggregationAccess access : this.currentAggregatorAccesses) {
            access.applyEnter(eventsPerStream);
        }
    }

    @Override
    public void applyLeave(EventBean[] eventsPerStream, MultiKeyUntyped groupByKey, ExprEvaluatorContext exprEvaluatorContext) {
        AggregationAccess[] groupAccesses;
        AggregationMethod[] groupAggregators;
        AggregationMethodPairRow row = this.aggregatorsPerGroup.get(groupByKey);
        if (row != null) {
            groupAggregators = row.getMethods();
            groupAccesses = row.getAccesses();
        } else {
            groupAggregators = this.methodResolutionService.newAggregators(this.aggregators, exprEvaluatorContext.getAgentInstanceIds(), groupByKey);
            groupAccesses = AggregationAccessUtil.getNewAccesses(exprEvaluatorContext.getAgentInstanceIds(), this.isJoin, this.streams, this.methodResolutionService, groupByKey);
            row = new AggregationMethodPairRow(this.methodResolutionService.getCurrentRowCount(groupAggregators, groupAccesses) + 1L, groupAggregators, groupAccesses);
            this.aggregatorsPerGroup.put(groupByKey, row);
        }
        this.currentAggregatorMethods = groupAggregators;
        this.currentAggregatorAccesses = groupAccesses;
        for (int j = 0; j < this.evaluators.length; ++j) {
            Object columnResult = this.evaluators[j].evaluate(eventsPerStream, false, exprEvaluatorContext);
            groupAggregators[j].leave(columnResult);
        }
        for (AggregationAccess access : this.currentAggregatorAccesses) {
            access.applyLeave(eventsPerStream);
        }
        row.decreaseRefcount();
        if (row.getRefcount() <= 0L) {
            this.removedKeys.add(groupByKey);
            this.methodResolutionService.removeAggregators(exprEvaluatorContext.getAgentInstanceIds(), groupByKey);
        }
    }

    @Override
    public void setCurrentAccess(MultiKeyUntyped groupByKey, int[] agentInstanceIds) {
        AggregationMethodPairRow row = this.aggregatorsPerGroup.get(groupByKey);
        if (row != null) {
            this.currentAggregatorMethods = row.getMethods();
            this.currentAggregatorAccesses = row.getAccesses();
        } else {
            this.currentAggregatorMethods = null;
        }
        if (this.currentAggregatorMethods == null) {
            this.currentAggregatorMethods = this.methodResolutionService.newAggregators(this.aggregators, agentInstanceIds, groupByKey);
            this.currentAggregatorAccesses = AggregationAccessUtil.getNewAccesses(agentInstanceIds, this.isJoin, this.streams, this.methodResolutionService, groupByKey);
        }
    }

    @Override
    public Object getValue(int column, int[] agentInstanceIds) {
        if (column < this.aggregators.length) {
            return this.currentAggregatorMethods[column].getValue();
        }
        AggregationAccessorSlotPair pair = this.accessors[column - this.aggregators.length];
        return pair.getAccessor().getValue(this.currentAggregatorAccesses[pair.getSlot()]);
    }

    @Override
    public Collection<EventBean> getCollection(int column, ExprEvaluatorContext context) {
        if (column < this.aggregators.length) {
            return null;
        }
        AggregationAccessorSlotPair pair = this.accessors[column - this.aggregators.length];
        return pair.getAccessor().getCollectionReadOnly(this.currentAggregatorAccesses[pair.getSlot()]);
    }

    @Override
    public EventBean getEventBean(int column, ExprEvaluatorContext context) {
        if (column < this.aggregators.length) {
            return null;
        }
        AggregationAccessorSlotPair pair = this.accessors[column - this.aggregators.length];
        return pair.getAccessor().getEventBean(this.currentAggregatorAccesses[pair.getSlot()]);
    }
}

