/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.agg.AggregationAccess;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class AggregationAccessImpl
implements AggregationAccess {
    private int streamId;
    private ArrayList<EventBean> events = new ArrayList();

    public AggregationAccessImpl(int streamId) {
        this.streamId = streamId;
    }

    @Override
    public void clear() {
        this.events.clear();
    }

    @Override
    public void applyLeave(EventBean[] eventsPerStream) {
        EventBean event = eventsPerStream[this.streamId];
        if (event == null) {
            return;
        }
        this.events.remove(event);
    }

    @Override
    public void applyEnter(EventBean[] eventsPerStream) {
        EventBean event = eventsPerStream[this.streamId];
        if (event == null) {
            return;
        }
        this.events.add(event);
    }

    @Override
    public EventBean getFirstNthValue(int index) {
        if (index < 0) {
            return null;
        }
        if (index >= this.events.size()) {
            return null;
        }
        return this.events.get(index);
    }

    @Override
    public EventBean getLastNthValue(int index) {
        if (index < 0) {
            return null;
        }
        if (index >= this.events.size()) {
            return null;
        }
        return this.events.get(this.events.size() - index - 1);
    }

    @Override
    public EventBean getFirstValue() {
        if (this.events.isEmpty()) {
            return null;
        }
        return this.events.get(0);
    }

    @Override
    public EventBean getLastValue() {
        if (this.events.isEmpty()) {
            return null;
        }
        return this.events.get(this.events.size() - 1);
    }

    @Override
    public Iterator<EventBean> iterator() {
        return this.events.iterator();
    }

    @Override
    public Collection<EventBean> collectionReadOnly() {
        return this.events;
    }

    @Override
    public int size() {
        return this.events.size();
    }
}

