/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.ArrayEventIterator;
import com.espertech.esper.epl.agg.AggregationAccess;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;

public class AggregationAccessJoinImpl
implements AggregationAccess {
    private int streamId;
    private LinkedHashMap<EventBean, Integer> refSet = new LinkedHashMap();
    private EventBean[] array;

    public AggregationAccessJoinImpl(int streamId) {
        this.streamId = streamId;
    }

    @Override
    public void clear() {
        this.refSet.clear();
        this.array = null;
    }

    @Override
    public void applyEnter(EventBean[] eventsPerStream) {
        EventBean event = eventsPerStream[this.streamId];
        if (event == null) {
            return;
        }
        this.array = null;
        Integer value = this.refSet.get(event);
        if (value == null) {
            this.refSet.put(event, 1);
            return;
        }
        Integer n = value;
        Integer n2 = value = Integer.valueOf(value + 1);
        this.refSet.put(event, value);
    }

    @Override
    public void applyLeave(EventBean[] eventsPerStream) {
        EventBean event = eventsPerStream[this.streamId];
        if (event == null) {
            return;
        }
        this.array = null;
        Integer value = this.refSet.get(event);
        if (value == null) {
            return;
        }
        if (value == 1) {
            this.refSet.remove(event);
            return;
        }
        Integer n = value;
        Integer n2 = value = Integer.valueOf(value - 1);
        this.refSet.put(event, value);
    }

    @Override
    public EventBean getFirstNthValue(int index) {
        if (index < 0) {
            return null;
        }
        if (this.refSet.isEmpty()) {
            return null;
        }
        if (index >= this.refSet.size()) {
            return null;
        }
        if (this.array == null) {
            this.initArray();
        }
        return this.array[index];
    }

    @Override
    public EventBean getLastNthValue(int index) {
        if (index < 0) {
            return null;
        }
        if (this.refSet.isEmpty()) {
            return null;
        }
        if (index >= this.refSet.size()) {
            return null;
        }
        if (this.array == null) {
            this.initArray();
        }
        return this.array[this.array.length - index - 1];
    }

    @Override
    public EventBean getFirstValue() {
        if (this.refSet.isEmpty()) {
            return null;
        }
        return this.refSet.entrySet().iterator().next().getKey();
    }

    @Override
    public EventBean getLastValue() {
        if (this.refSet.isEmpty()) {
            return null;
        }
        if (this.array == null) {
            this.initArray();
        }
        return this.array[this.array.length - 1];
    }

    @Override
    public Iterator<EventBean> iterator() {
        if (this.array == null) {
            this.initArray();
        }
        return new ArrayEventIterator(this.array);
    }

    @Override
    public Collection<EventBean> collectionReadOnly() {
        if (this.array == null) {
            this.initArray();
        }
        return Arrays.asList(this.array);
    }

    @Override
    public int size() {
        return this.refSet.size();
    }

    private void initArray() {
        Set<EventBean> events = this.refSet.keySet();
        this.array = events.toArray(new EventBean[events.size()]);
    }
}

