/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.agg.AggregationAccess;
import com.espertech.esper.epl.agg.AggregationAccessor;
import com.espertech.esper.epl.expression.ExprEvaluator;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

public class AggregationAccessorAll
implements AggregationAccessor {
    private final int streamNum;
    private final ExprEvaluator childNode;
    private final EventBean[] eventsPerStream;
    private final Class componentType;

    public AggregationAccessorAll(int streamNum, ExprEvaluator childNode, Class componentType) {
        this.streamNum = streamNum;
        this.childNode = childNode;
        this.eventsPerStream = new EventBean[streamNum + 1];
        this.componentType = componentType;
    }

    @Override
    public Object getValue(AggregationAccess access) {
        if (access.size() == 0) {
            return null;
        }
        Object array = Array.newInstance(this.componentType, access.size());
        Iterator<EventBean> it = access.iterator();
        int count = 0;
        while (it.hasNext()) {
            EventBean bean;
            this.eventsPerStream[this.streamNum] = bean = it.next();
            Object value = this.childNode.evaluate(this.eventsPerStream, true, null);
            Array.set(array, count++, value);
        }
        return array;
    }

    @Override
    public Collection<EventBean> getCollectionReadOnly(AggregationAccess access) {
        if (access.size() == 0) {
            return null;
        }
        return access.collectionReadOnly();
    }

    @Override
    public EventBean getEventBean(AggregationAccess currentAcces) {
        return null;
    }
}

