/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.agg.AggregationAccess;
import com.espertech.esper.epl.agg.AggregationAccessor;
import com.espertech.esper.epl.expression.ExprEvaluator;
import java.util.Collection;
import java.util.Collections;

public class AggregationAccessorFirst
implements AggregationAccessor {
    private final int streamNum;
    private final ExprEvaluator childNode;
    private final EventBean[] eventsPerStream;

    public AggregationAccessorFirst(int streamNum, ExprEvaluator childNode) {
        this.streamNum = streamNum;
        this.childNode = childNode;
        this.eventsPerStream = new EventBean[streamNum + 1];
    }

    @Override
    public Object getValue(AggregationAccess access) {
        EventBean bean = access.getFirstValue();
        if (bean == null) {
            return null;
        }
        this.eventsPerStream[this.streamNum] = bean;
        return this.childNode.evaluate(this.eventsPerStream, true, null);
    }

    @Override
    public Collection<EventBean> getCollectionReadOnly(AggregationAccess access) {
        EventBean bean = access.getFirstValue();
        if (bean == null) {
            return null;
        }
        return Collections.singletonList(bean);
    }

    @Override
    public EventBean getEventBean(AggregationAccess currentAcces) {
        return currentAcces.getFirstValue();
    }
}

