/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.annotation.Hint;
import com.espertech.esper.client.annotation.HintEnum;
import com.espertech.esper.epl.agg.AggSvcGroupAllAccessOnlyFactory;
import com.espertech.esper.epl.agg.AggSvcGroupAllMixedAccessFactory;
import com.espertech.esper.epl.agg.AggSvcGroupAllNoAccessFactory;
import com.espertech.esper.epl.agg.AggSvcGroupByAccessOnlyFactory;
import com.espertech.esper.epl.agg.AggSvcGroupByMixedAccessFactory;
import com.espertech.esper.epl.agg.AggSvcGroupByNoAccessFactory;
import com.espertech.esper.epl.agg.AggSvcGroupByReclaimAgedFactory;
import com.espertech.esper.epl.agg.AggSvcGroupByRefcountedNoAccessFactory;
import com.espertech.esper.epl.agg.AggSvcGroupByRefcountedWAccessFactory;
import com.espertech.esper.epl.agg.AggregationAccessor;
import com.espertech.esper.epl.agg.AggregationAccessorSlotPair;
import com.espertech.esper.epl.agg.AggregationMethodFactory;
import com.espertech.esper.epl.agg.AggregationServiceAggExpressionDesc;
import com.espertech.esper.epl.agg.AggregationServiceFactory;
import com.espertech.esper.epl.agg.AggregationServiceFactoryDesc;
import com.espertech.esper.epl.agg.AggregationServiceMatchRecognizeFactoryDesc;
import com.espertech.esper.epl.agg.AggregationServiceMatchRecognizeFactoryImpl;
import com.espertech.esper.epl.agg.AggregationServiceNullFactory;
import com.espertech.esper.epl.agg.AggregationSpec;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.expression.ExprAggregateNode;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodePreviousVisitorWParent;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.util.CollectionUtil;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class AggregationServiceFactoryFactory {
    public static AggregationServiceMatchRecognizeFactoryDesc getServiceMatchRecognize(int numStreams, Map<Integer, List<ExprAggregateNode>> measureExprNodesPerStream, MethodResolutionService methodResolutionService, ExprEvaluatorContext exprEvaluatorContext) {
        HashMap<Integer, ArrayList<AggregationServiceAggExpressionDesc>> equivalencyListPerStream = new HashMap<Integer, ArrayList<AggregationServiceAggExpressionDesc>>();
        for (Map.Entry<Integer, List<ExprAggregateNode>> entry : measureExprNodesPerStream.entrySet()) {
            ArrayList<AggregationServiceAggExpressionDesc> equivalencyList = new ArrayList<AggregationServiceAggExpressionDesc>();
            equivalencyListPerStream.put(entry.getKey(), equivalencyList);
            for (ExprAggregateNode selectAggNode : entry.getValue()) {
                AggregationServiceFactoryFactory.addEquivalent(selectAggNode, equivalencyList);
            }
        }
        LinkedHashMap<Integer, AggregationMethodFactory[]> aggregatorsPerStream = new LinkedHashMap<Integer, AggregationMethodFactory[]>();
        HashMap<Integer, ExprEvaluator[]> evaluatorsPerStream = new HashMap<Integer, ExprEvaluator[]>();
        for (Map.Entry equivalencyPerStream : equivalencyListPerStream.entrySet()) {
            int index = 0;
            int stream = (Integer)equivalencyPerStream.getKey();
            AggregationMethodFactory[] aggregators = new AggregationMethodFactory[((List)equivalencyPerStream.getValue()).size()];
            aggregatorsPerStream.put(stream, aggregators);
            ExprEvaluator[] evaluators = new ExprEvaluator[((List)equivalencyPerStream.getValue()).size()];
            evaluatorsPerStream.put(stream, evaluators);
            for (AggregationServiceAggExpressionDesc aggregation : (List)equivalencyPerStream.getValue()) {
                ExprAggregateNode aggregateNode = aggregation.getAggregationNode();
                evaluators[index] = aggregateNode.getChildNodes().size() > 1 ? AggregationServiceFactoryFactory.getMultiNodeEvaluator(aggregateNode.getChildNodes(), exprEvaluatorContext) : (!aggregateNode.getChildNodes().isEmpty() ? aggregateNode.getChildNodes().get(0).getExprEvaluator() : new ExprEvaluator(){

                    @Override
                    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                        return null;
                    }

                    @Override
                    public Class getType() {
                        return null;
                    }

                    @Override
                    public Map<String, Object> getEventType() {
                        return null;
                    }
                });
                aggregators[index] = aggregateNode.getFactory();
                ++index;
            }
        }
        int columnNumber = 0;
        ArrayList<AggregationServiceAggExpressionDesc> allExpressions = new ArrayList<AggregationServiceAggExpressionDesc>();
        for (Map.Entry equivalencyPerStream : equivalencyListPerStream.entrySet()) {
            for (AggregationServiceAggExpressionDesc entry : (List)equivalencyPerStream.getValue()) {
                entry.setColumnNum(columnNumber++);
            }
            allExpressions.addAll((Collection)equivalencyPerStream.getValue());
        }
        AggregationServiceMatchRecognizeFactoryImpl factory = new AggregationServiceMatchRecognizeFactoryImpl(numStreams, aggregatorsPerStream, evaluatorsPerStream);
        return new AggregationServiceMatchRecognizeFactoryDesc(factory, allExpressions);
    }

    public static AggregationServiceFactoryDesc getService(List<ExprAggregateNode> selectAggregateExprNodes, List<ExprAggregateNode> havingAggregateExprNodes, List<ExprAggregateNode> orderByAggregateExprNodes, boolean hasGroupByClause, MethodResolutionService methodResolutionService, ExprEvaluatorContext exprEvaluatorContext, Annotation[] annotations, VariableService variableService, boolean isJoin, ExprNode whereClause, ExprNode havingClause) throws ExprValidationException {
        AggregationServiceFactory serviceFactory;
        if (selectAggregateExprNodes.isEmpty() && havingAggregateExprNodes.isEmpty()) {
            return new AggregationServiceFactoryDesc(AggregationServiceNullFactory.AGGREGATION_SERVICE_NULL_FACTORY, Collections.<AggregationServiceAggExpressionDesc>emptyList());
        }
        if (whereClause != null || havingClause != null) {
            ExprNodePreviousVisitorWParent visitor = new ExprNodePreviousVisitorWParent();
            if (whereClause != null) {
                whereClause.accept(visitor);
            }
            if (havingClause != null) {
                havingClause.accept(visitor);
            }
            if (visitor.getPrevious() != null && !visitor.getPrevious().isEmpty()) {
                String funcname = visitor.getPrevious().get(0).getSecond().getPreviousType().toString().toLowerCase();
                throw new ExprValidationException("The '" + funcname + "' function may not occur in the where-clause or having-clause of a statement with aggregations as 'previous' does not provide remove stream data; Use the 'first','last','window' or 'count' aggregation functions instead");
            }
        }
        ArrayList<AggregationServiceAggExpressionDesc> aggregations = new ArrayList<AggregationServiceAggExpressionDesc>();
        for (ExprAggregateNode selectAggNode : selectAggregateExprNodes) {
            AggregationServiceFactoryFactory.addEquivalent(selectAggNode, aggregations);
        }
        for (ExprAggregateNode havingAggNode : havingAggregateExprNodes) {
            AggregationServiceFactoryFactory.addEquivalent(havingAggNode, aggregations);
        }
        for (ExprAggregateNode orderByAggNode : orderByAggregateExprNodes) {
            AggregationServiceFactoryFactory.addEquivalent(orderByAggNode, aggregations);
        }
        int columnNumber = 0;
        for (AggregationServiceAggExpressionDesc entry : aggregations) {
            if (entry.getFactory().getSpec(false) != null) continue;
            entry.setColumnNum(columnNumber++);
        }
        for (AggregationServiceAggExpressionDesc entry : aggregations) {
            if (entry.getFactory().getSpec(false) == null) continue;
            entry.setColumnNum(columnNumber++);
        }
        ArrayList<AggregationMethodFactory> aggregators = new ArrayList<AggregationMethodFactory>();
        ArrayList<ExprEvaluator> evaluators = new ArrayList<ExprEvaluator>();
        TreeMap<Integer, Integer> streamSlots = new TreeMap<Integer, Integer>();
        ArrayList<AggregationAccessorSlotPair> accessorPairs = new ArrayList<AggregationAccessorSlotPair>();
        int currentSlot = 0;
        for (AggregationServiceAggExpressionDesc aggregation : aggregations) {
            ExprAggregateNode aggregateNode = aggregation.getAggregationNode();
            if (aggregateNode.getFactory().getSpec(false) == null) {
                ExprEvaluator evaluator = aggregateNode.getChildNodes().size() > 1 ? AggregationServiceFactoryFactory.getMultiNodeEvaluator(aggregateNode.getChildNodes(), exprEvaluatorContext) : (!aggregateNode.getChildNodes().isEmpty() ? aggregateNode.getChildNodes().get(0).getExprEvaluator() : new ExprEvaluator(){

                    @Override
                    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                        return null;
                    }

                    @Override
                    public Class getType() {
                        return null;
                    }

                    @Override
                    public Map<String, Object> getEventType() {
                        return null;
                    }
                });
                AggregationMethodFactory aggregator = aggregateNode.getFactory();
                evaluators.add(evaluator);
                aggregators.add(aggregator);
                continue;
            }
            AggregationSpec spec = aggregateNode.getFactory().getSpec(false);
            AggregationAccessor accessor = aggregateNode.getFactory().getAccessor();
            Integer slot = (Integer)streamSlots.get(spec.getStreamNum());
            if (slot == null) {
                streamSlots.put(spec.getStreamNum(), currentSlot);
                slot = currentSlot++;
            }
            accessorPairs.add(new AggregationAccessorSlotPair(slot, accessor));
        }
        ExprEvaluator[] evaluatorsArr = evaluators.toArray(new ExprEvaluator[evaluators.size()]);
        AggregationMethodFactory[] aggregatorsArr = aggregators.toArray(new AggregationMethodFactory[aggregators.size()]);
        AggregationAccessorSlotPair[] pairs = accessorPairs.toArray(new AggregationAccessorSlotPair[accessorPairs.size()]);
        int[] accessedStreams = CollectionUtil.intArray(streamSlots.keySet());
        if (!hasGroupByClause) {
            serviceFactory = evaluatorsArr.length > 0 && accessorPairs.isEmpty() ? new AggSvcGroupAllNoAccessFactory(evaluatorsArr, aggregatorsArr) : (evaluatorsArr.length == 0 && !accessorPairs.isEmpty() ? new AggSvcGroupAllAccessOnlyFactory(methodResolutionService, pairs, accessedStreams, isJoin) : new AggSvcGroupAllMixedAccessFactory(evaluatorsArr, aggregatorsArr, pairs, accessedStreams, isJoin));
        } else {
            boolean hasNoReclaim = HintEnum.DISABLE_RECLAIM_GROUP.getHint(annotations) != null;
            Hint reclaimGroupAged = HintEnum.RECLAIM_GROUP_AGED.getHint(annotations);
            Hint reclaimGroupFrequency = HintEnum.RECLAIM_GROUP_AGED.getHint(annotations);
            serviceFactory = hasNoReclaim ? (evaluatorsArr.length > 0 && accessorPairs.isEmpty() ? new AggSvcGroupByNoAccessFactory(evaluatorsArr, aggregatorsArr) : (evaluatorsArr.length == 0 && !accessorPairs.isEmpty() ? new AggSvcGroupByAccessOnlyFactory(pairs, accessedStreams, isJoin) : new AggSvcGroupByMixedAccessFactory(evaluatorsArr, aggregatorsArr, pairs, accessedStreams, isJoin))) : (reclaimGroupAged != null ? new AggSvcGroupByReclaimAgedFactory(evaluatorsArr, aggregatorsArr, methodResolutionService, reclaimGroupAged, reclaimGroupFrequency, variableService, pairs, accessedStreams, isJoin) : (evaluatorsArr.length > 0 && accessorPairs.isEmpty() ? new AggSvcGroupByRefcountedNoAccessFactory(evaluatorsArr, aggregatorsArr) : new AggSvcGroupByRefcountedWAccessFactory(evaluatorsArr, aggregatorsArr, pairs, accessedStreams, isJoin)));
        }
        return new AggregationServiceFactoryDesc(serviceFactory, aggregations);
    }

    private static ExprEvaluator getMultiNodeEvaluator(List<ExprNode> childNodes, ExprEvaluatorContext exprEvaluatorContext) {
        int size = childNodes.size();
        final List<ExprNode> exprNodes = childNodes;
        final Object[] prototype = new Object[size];
        int count = 0;
        for (ExprNode node : exprNodes) {
            if (node.isConstantResult()) {
                prototype[count] = node.getExprEvaluator().evaluate(null, true, exprEvaluatorContext);
            }
            ++count;
        }
        return new ExprEvaluator(){

            @Override
            public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                int count = 0;
                for (ExprNode node : exprNodes) {
                    prototype[count] = node.getExprEvaluator().evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                    ++count;
                }
                return prototype;
            }

            @Override
            public Class getType() {
                return Object[].class;
            }

            @Override
            public Map<String, Object> getEventType() {
                return null;
            }
        };
    }

    private static void addEquivalent(ExprAggregateNode aggNodeToAdd, List<AggregationServiceAggExpressionDesc> equivalencyList) {
        boolean foundEquivalent = false;
        for (AggregationServiceAggExpressionDesc existing : equivalencyList) {
            ExprAggregateNode aggNode = existing.getAggregationNode();
            if (!ExprNodeUtility.deepEquals(aggNode, aggNodeToAdd)) continue;
            existing.addEquivalent(aggNodeToAdd);
            foundEquivalent = true;
            break;
        }
        if (!foundEquivalent) {
            equivalencyList.add(new AggregationServiceAggExpressionDesc(aggNodeToAdd, aggNodeToAdd.getFactory()));
        }
    }
}

