/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg;

import com.espertech.esper.epl.agg.AggregationMethod;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BigDecimalAvgAggregator
implements AggregationMethod {
    private static final Log log = LogFactory.getLog(BigDecimalAvgAggregator.class);
    private BigDecimal sum = new BigDecimal(0.0);
    private long numDataPoints;

    @Override
    public void clear() {
        this.sum = new BigDecimal(0.0);
        this.numDataPoints = 0L;
    }

    @Override
    public void enter(Object object) {
        if (object == null) {
            return;
        }
        ++this.numDataPoints;
        if (object instanceof BigInteger) {
            this.sum = this.sum.add(new BigDecimal((BigInteger)object));
            return;
        }
        this.sum = this.sum.add((BigDecimal)object);
    }

    @Override
    public void leave(Object object) {
        if (object == null) {
            return;
        }
        --this.numDataPoints;
        if (object instanceof BigInteger) {
            this.sum = this.sum.subtract(new BigDecimal((BigInteger)object));
            return;
        }
        this.sum = this.sum.subtract((BigDecimal)object);
    }

    @Override
    public Object getValue() {
        if (this.numDataPoints == 0L) {
            return null;
        }
        try {
            return this.sum.divide(new BigDecimal(this.numDataPoints));
        }
        catch (ArithmeticException ex) {
            log.error((Object)("Error computing avg aggregation result: " + ex.getMessage()), (Throwable)ex);
            return new BigDecimal(0);
        }
    }

    @Override
    public Class getValueType() {
        return Double.class;
    }
}

