/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg;

import com.espertech.esper.epl.agg.AggregationMethod;
import java.math.BigDecimal;

public class BigDecimalSumAggregator
implements AggregationMethod {
    private BigDecimal sum = new BigDecimal(0.0);
    private long numDataPoints;

    @Override
    public void clear() {
        this.sum = new BigDecimal(0.0);
        this.numDataPoints = 0L;
    }

    @Override
    public void enter(Object object) {
        if (object == null) {
            return;
        }
        ++this.numDataPoints;
        this.sum = this.sum.add((BigDecimal)object);
    }

    @Override
    public void leave(Object object) {
        if (object == null) {
            return;
        }
        --this.numDataPoints;
        this.sum = this.sum.subtract((BigDecimal)object);
    }

    @Override
    public Object getValue() {
        if (this.numDataPoints == 0L) {
            return null;
        }
        return this.sum;
    }

    @Override
    public Class getValueType() {
        return BigDecimal.class;
    }
}

