/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg;

import com.espertech.esper.collection.RefCountedSet;
import com.espertech.esper.epl.agg.AggregationMethod;

public class DistinctValueAggregator
implements AggregationMethod {
    private final AggregationMethod inner;
    private final Class childType;
    private final RefCountedSet<Object> valueSet;

    public DistinctValueAggregator(AggregationMethod inner, Class childType) {
        this.inner = inner;
        this.childType = childType;
        this.valueSet = new RefCountedSet();
    }

    @Override
    public void clear() {
        this.valueSet.clear();
    }

    @Override
    public void enter(Object value) {
        if (this.valueSet.add(value)) {
            this.inner.enter(value);
        }
    }

    @Override
    public void leave(Object value) {
        if (this.valueSet.remove(value)) {
            this.inner.leave(value);
        }
    }

    @Override
    public Object getValue() {
        return this.inner.getValue();
    }

    @Override
    public Class getValueType() {
        return this.inner.getValueType();
    }
}

