/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg;

import com.espertech.esper.collection.RefCountedSet;
import com.espertech.esper.epl.agg.AggregationMethod;

public class DistinctValueFilterAggregator
implements AggregationMethod {
    private final AggregationMethod inner;
    private final Class childType;
    private final RefCountedSet<Object> valueSet;

    public DistinctValueFilterAggregator(AggregationMethod inner, Class childType) {
        this.inner = inner;
        this.childType = childType;
        this.valueSet = new RefCountedSet();
    }

    @Override
    public void clear() {
        this.valueSet.clear();
    }

    @Override
    public void enter(Object value) {
        Object[] values = (Object[])value;
        if (!this.checkPass(values)) {
            return;
        }
        if (this.valueSet.add(values[0])) {
            this.inner.enter(value);
        }
    }

    @Override
    public void leave(Object value) {
        Object[] values = (Object[])value;
        if (!this.checkPass(values)) {
            return;
        }
        if (this.valueSet.remove(values[0])) {
            this.inner.leave(value);
        }
    }

    @Override
    public Object getValue() {
        return this.inner.getValue();
    }

    @Override
    public Class getValueType() {
        return this.inner.getValueType();
    }

    private boolean checkPass(Object[] object) {
        Boolean first = (Boolean)object[1];
        if (first != null) {
            return first;
        }
        return false;
    }
}

