/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg;

import com.espertech.esper.epl.agg.AggregationMethod;

public class FloatSumAggregator
implements AggregationMethod {
    private float sum;
    private long numDataPoints;

    @Override
    public void clear() {
        this.sum = 0.0f;
        this.numDataPoints = 0L;
    }

    @Override
    public void enter(Object object) {
        if (object == null) {
            return;
        }
        ++this.numDataPoints;
        this.sum += ((Float)object).floatValue();
    }

    @Override
    public void leave(Object object) {
        if (object == null) {
            return;
        }
        --this.numDataPoints;
        this.sum -= ((Float)object).floatValue();
    }

    @Override
    public Object getValue() {
        if (this.numDataPoints == 0L) {
            return null;
        }
        return Float.valueOf(this.sum);
    }

    @Override
    public Class getValueType() {
        return Float.class;
    }
}

