/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg;

import com.espertech.esper.epl.agg.AggregationMethod;

public class NthAggregator
implements AggregationMethod {
    private final Class returnType;
    private final int sizeBuf;
    private Object[] circularBuffer;
    private int currentBufferElementPointer;
    private long numDataPoints;

    public NthAggregator(Class returnType, int sizeBuf) {
        this.returnType = returnType;
        this.sizeBuf = sizeBuf;
    }

    @Override
    public void enter(Object value) {
        Object[] arr = (Object[])value;
        ++this.numDataPoints;
        if (this.circularBuffer == null) {
            this.clear();
        }
        this.circularBuffer[this.currentBufferElementPointer] = arr[0];
        this.currentBufferElementPointer = (this.currentBufferElementPointer + 1) % this.sizeBuf;
    }

    @Override
    public void leave(Object value) {
        if ((long)this.sizeBuf > this.numDataPoints) {
            int diff = this.sizeBuf - (int)this.numDataPoints;
            this.circularBuffer[(this.currentBufferElementPointer + diff - 1) % this.sizeBuf] = null;
        }
        --this.numDataPoints;
    }

    @Override
    public Class getValueType() {
        return this.returnType;
    }

    @Override
    public Object getValue() {
        return this.circularBuffer[(this.currentBufferElementPointer + this.sizeBuf) % this.sizeBuf];
    }

    @Override
    public void clear() {
        this.circularBuffer = new Object[this.sizeBuf];
        this.numDataPoints = 0L;
        this.currentBufferElementPointer = 0;
    }
}

