/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg;

import com.espertech.esper.epl.agg.AggregationMethod;

public class RateAggregator
implements AggregationMethod {
    private double accumulator;
    private long latest;
    private long oldest;
    private boolean isSet = false;

    @Override
    public void enter(Object value) {
        if (value.getClass().isArray()) {
            Object[] params = (Object[])value;
            Number val = (Number)params[1];
            this.accumulator += val.doubleValue();
            this.latest = (Long)params[0];
        } else {
            this.accumulator += 1.0;
            this.latest = (Long)value;
        }
    }

    @Override
    public void leave(Object value) {
        if (value.getClass().isArray()) {
            Object[] params = (Object[])value;
            Number val = (Number)params[1];
            this.accumulator -= val.doubleValue();
            this.oldest = (Long)params[0];
        } else {
            this.accumulator -= 1.0;
            this.oldest = (Long)value;
        }
        if (!this.isSet) {
            this.isSet = true;
        }
    }

    @Override
    public Object getValue() {
        if (!this.isSet) {
            return null;
        }
        return this.accumulator * 1000.0 / (double)(this.latest - this.oldest);
    }

    @Override
    public void clear() {
        this.accumulator = 0.0;
        this.latest = 0L;
        this.oldest = 0L;
    }

    @Override
    public Class getValueType() {
        return Double.class;
    }
}

