/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.SelectClauseElementCompiled;
import com.espertech.esper.epl.spec.SelectClauseElementWildcard;
import com.espertech.esper.epl.spec.SelectClauseExprCompiledSpec;
import com.espertech.esper.epl.spec.SelectClauseStreamCompiledSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BindProcessor {
    private ExprEvaluator[] expressionNodes;
    private Class[] expressionTypes;
    private String[] columnNamesAssigned;

    public BindProcessor(List<SelectClauseElementCompiled> selectionList, EventType[] typesPerStream, String[] streamNames) throws ExprValidationException {
        ArrayList<ExprEvaluator> expressions = new ArrayList<ExprEvaluator>();
        ArrayList<Class> types = new ArrayList<Class>();
        ArrayList<String> columnNames = new ArrayList<String>();
        for (SelectClauseElementCompiled element : selectionList) {
            if (element instanceof SelectClauseElementWildcard) {
                int i = 0;
                while (i < typesPerStream.length) {
                    final int streamNum = i++;
                    final Class returnType = typesPerStream[streamNum].getUnderlyingType();
                    expressions.add(new ExprEvaluator(){

                        @Override
                        public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                            EventBean event = eventsPerStream[streamNum];
                            if (event != null) {
                                return event.getUnderlying();
                            }
                            return null;
                        }

                        @Override
                        public Class getType() {
                            return returnType;
                        }

                        @Override
                        public Map<String, Object> getEventType() {
                            return null;
                        }
                    });
                    types.add(returnType);
                    columnNames.add(streamNames[streamNum]);
                }
                continue;
            }
            if (element instanceof SelectClauseStreamCompiledSpec) {
                final SelectClauseStreamCompiledSpec streamSpec = (SelectClauseStreamCompiledSpec)element;
                final Class returnType = typesPerStream[streamSpec.getStreamNumber()].getUnderlyingType();
                expressions.add(new ExprEvaluator(){

                    @Override
                    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                        EventBean event = eventsPerStream[streamSpec.getStreamNumber()];
                        if (event != null) {
                            return event.getUnderlying();
                        }
                        return null;
                    }

                    @Override
                    public Class getType() {
                        return returnType;
                    }

                    @Override
                    public Map<String, Object> getEventType() {
                        return null;
                    }
                });
                types.add(returnType);
                columnNames.add(streamNames[streamSpec.getStreamNumber()]);
                continue;
            }
            if (element instanceof SelectClauseExprCompiledSpec) {
                SelectClauseExprCompiledSpec expr = (SelectClauseExprCompiledSpec)element;
                ExprEvaluator evaluator = expr.getSelectExpression().getExprEvaluator();
                expressions.add(evaluator);
                types.add(evaluator.getType());
                if (expr.getAssignedName() != null) {
                    columnNames.add(expr.getAssignedName());
                    continue;
                }
                columnNames.add(expr.getSelectExpression().toExpressionString());
                continue;
            }
            throw new IllegalStateException("Unrecognized select expression element of type " + element.getClass());
        }
        this.expressionNodes = expressions.toArray(new ExprEvaluator[expressions.size()]);
        this.expressionTypes = types.toArray(new Class[types.size()]);
        this.columnNamesAssigned = columnNames.toArray(new String[columnNames.size()]);
    }

    public Object[] process(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object[] parameters = new Object[this.expressionNodes.length];
        for (int i = 0; i < parameters.length; ++i) {
            Object result;
            parameters[i] = result = this.expressionNodes[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        }
        return parameters;
    }

    public Class[] getExpressionTypes() {
        return this.expressionTypes;
    }

    public String[] getColumnNamesAssigned() {
        return this.columnNamesAssigned;
    }
}

