/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.ConfigurationMethodRef;
import com.espertech.esper.client.ConfigurationPlugInSingleRowFunction;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.agg.AggregationSupport;
import com.espertech.esper.epl.core.EngineImportException;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.epl.core.EngineImportSingleRowDesc;
import com.espertech.esper.epl.core.EngineImportUndefinedException;
import com.espertech.esper.epl.core.EngineNoSuchCtorException;
import com.espertech.esper.epl.core.EngineNoSuchMethodException;
import com.espertech.esper.epl.expression.ExprFirstEverNode;
import com.espertech.esper.epl.expression.ExprLastEverNode;
import com.espertech.esper.epl.expression.ExprLeavingAggNode;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNthAggNode;
import com.espertech.esper.epl.expression.ExprRateAggNode;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.MethodResolver;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EngineImportServiceImpl
implements EngineImportService {
    private static final Log log = LogFactory.getLog(EngineImportServiceImpl.class);
    private final List<String> imports = new ArrayList<String>();
    private final Map<String, String> aggregationFunctions = new HashMap<String, String>();
    private final Map<String, EngineImportSingleRowDesc> singleRowFunctions = new HashMap<String, EngineImportSingleRowDesc>();
    private final Map<String, ConfigurationMethodRef> methodInvocationRef = new HashMap<String, ConfigurationMethodRef>();
    private final boolean allowExtendedAggregationFunc;
    private final boolean isUdfCache;
    private final boolean isDuckType;

    public EngineImportServiceImpl(boolean allowExtendedAggregationFunc, boolean isUdfCache, boolean isDuckType) {
        this.allowExtendedAggregationFunc = allowExtendedAggregationFunc;
        this.isUdfCache = isUdfCache;
        this.isDuckType = isDuckType;
    }

    @Override
    public boolean isUdfCache() {
        return this.isUdfCache;
    }

    @Override
    public boolean isDuckType() {
        return this.isDuckType;
    }

    @Override
    public ConfigurationMethodRef getConfigurationMethodRef(String className) {
        return this.methodInvocationRef.get(className);
    }

    public void addMethodRefs(Map<String, ConfigurationMethodRef> configs) {
        this.methodInvocationRef.putAll(configs);
    }

    @Override
    public void addImport(String importName) throws EngineImportException {
        if (!EngineImportServiceImpl.isClassName(importName) && !EngineImportServiceImpl.isPackageName(importName)) {
            throw new EngineImportException("Invalid import name '" + importName + "'");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding import " + importName));
        }
        this.imports.add(importName);
    }

    @Override
    public void addAggregation(String functionName, String aggregationClass) throws EngineImportException {
        String existing = this.aggregationFunctions.get(functionName);
        if (existing != null) {
            throw new EngineImportException("Aggregation function by name '" + functionName + "' is already defined");
        }
        if (this.singleRowFunctions.containsKey(functionName)) {
            throw new EngineImportException("Single-row function by name '" + functionName + "' is already defined");
        }
        if (!EngineImportServiceImpl.isFunctionName(functionName)) {
            throw new EngineImportException("Invalid aggregation function name '" + functionName + "'");
        }
        if (!EngineImportServiceImpl.isClassName(aggregationClass)) {
            throw new EngineImportException("Invalid class name for aggregation '" + aggregationClass + "'");
        }
        this.aggregationFunctions.put(functionName.toLowerCase(), aggregationClass);
    }

    @Override
    public void addSingleRow(String functionName, String singleRowFuncClass, String methodName, ConfigurationPlugInSingleRowFunction.ValueCache valueCache) throws EngineImportException {
        EngineImportSingleRowDesc existing = this.singleRowFunctions.get(functionName);
        if (existing != null) {
            throw new EngineImportException("Single-Row function by name '" + functionName + "' is already defined");
        }
        if (this.aggregationFunctions.containsKey(functionName)) {
            throw new EngineImportException("Aggregation function by name '" + functionName + "' is already defined");
        }
        if (!EngineImportServiceImpl.isFunctionName(functionName)) {
            throw new EngineImportException("Invalid single-row function name '" + functionName + "'");
        }
        if (!EngineImportServiceImpl.isClassName(singleRowFuncClass)) {
            throw new EngineImportException("Invalid class name for aggregation '" + singleRowFuncClass + "'");
        }
        this.singleRowFunctions.put(functionName.toLowerCase(), new EngineImportSingleRowDesc(singleRowFuncClass, methodName, valueCache));
    }

    @Override
    public AggregationSupport resolveAggregation(String name) throws EngineImportException, EngineImportUndefinedException {
        Object object;
        Class<?> clazz;
        String className = this.aggregationFunctions.get(name);
        if (className == null) {
            className = this.aggregationFunctions.get(name.toLowerCase());
        }
        if (className == null) {
            throw new EngineImportUndefinedException("A function named '" + name + "' is not defined");
        }
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            clazz = Class.forName(className, true, cl);
        }
        catch (ClassNotFoundException ex) {
            throw new EngineImportException("Could not load aggregation class by name '" + className + "'", ex);
        }
        try {
            object = clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new EngineImportException("Error instantiating aggregation class by name '" + className + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new EngineImportException("Illegal access instatiating aggregation function class by name '" + className + "'", e);
        }
        if (!(object instanceof AggregationSupport)) {
            throw new EngineImportException("Aggregation class by name '" + className + "' does not subclass AggregationSupport");
        }
        return (AggregationSupport)object;
    }

    @Override
    public Pair<Class, EngineImportSingleRowDesc> resolveSingleRow(String name) throws EngineImportException, EngineImportUndefinedException {
        Class<?> clazz;
        EngineImportSingleRowDesc pair = this.singleRowFunctions.get(name);
        if (pair == null) {
            pair = this.singleRowFunctions.get(name.toLowerCase());
        }
        if (pair == null) {
            throw new EngineImportUndefinedException("A function named '" + name + "' is not defined");
        }
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            clazz = Class.forName(pair.getClassName(), true, cl);
        }
        catch (ClassNotFoundException ex) {
            throw new EngineImportException("Could not load single-row function class by name '" + pair.getClassName() + "'", ex);
        }
        return new Pair<Class, EngineImportSingleRowDesc>(clazz, pair);
    }

    @Override
    public Method resolveMethod(String className, String methodName, Class[] paramTypes) throws EngineImportException {
        Class clazz;
        try {
            clazz = this.resolveClassInternal(className);
        }
        catch (ClassNotFoundException e) {
            throw new EngineImportException("Could not load class by name '" + className + "', please check imports", e);
        }
        try {
            return MethodResolver.resolveMethod(clazz, methodName, paramTypes, false);
        }
        catch (EngineNoSuchMethodException e) {
            throw this.convert(clazz, methodName, paramTypes, e, false);
        }
    }

    @Override
    public Constructor resolveCtor(Class clazz, Class[] paramTypes) throws EngineImportException {
        try {
            return MethodResolver.resolveCtor(clazz, paramTypes);
        }
        catch (EngineNoSuchCtorException e) {
            throw this.convert(clazz, paramTypes, e);
        }
    }

    @Override
    public Method resolveMethod(String className, String methodName) throws EngineImportException {
        Class clazz;
        try {
            clazz = this.resolveClassInternal(className);
        }
        catch (ClassNotFoundException e) {
            throw new EngineImportException("Could not load class by name '" + className + "', please check imports", e);
        }
        Method[] methods = clazz.getMethods();
        Method methodByName = null;
        for (Method method : methods) {
            if (!method.getName().equals(methodName)) continue;
            if (methodByName != null) {
                throw new EngineImportException("Ambiguous method name: method by name '" + methodName + "' is overloaded in class '" + className + "'");
            }
            int modifiers = method.getModifiers();
            if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers)) continue;
            methodByName = method;
        }
        if (methodByName == null) {
            throw new EngineImportException("Could not find static method named '" + methodName + "' in class '" + className + "'");
        }
        return methodByName;
    }

    @Override
    public Class resolveClass(String className) throws EngineImportException {
        Class clazz;
        try {
            clazz = this.resolveClassInternal(className);
        }
        catch (ClassNotFoundException e) {
            throw new EngineImportException("Could not load class by name '" + className + "', please check imports", e);
        }
        return clazz;
    }

    protected Class resolveClassInternal(String className) throws ClassNotFoundException {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            return Class.forName(className, true, cl);
        }
        catch (ClassNotFoundException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Class not found for resolving from name as-is '" + className + "'"));
            }
            for (String importName : this.imports) {
                boolean isClassName = EngineImportServiceImpl.isClassName(importName);
                if (isClassName) {
                    if (!importName.endsWith(className)) continue;
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    return Class.forName(importName, true, cl);
                }
                String prefixedClassName = EngineImportServiceImpl.getPackageName(importName) + '.' + className;
                try {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    return Class.forName(prefixedClassName, true, cl);
                }
                catch (ClassNotFoundException e2) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Class not found for resolving from name '" + prefixedClassName + "'"));
                }
            }
            for (String name : this.methodInvocationRef.keySet()) {
                if (!JavaClassHelper.isSimpleNameFullyQualfied(className, name)) continue;
                try {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    return Class.forName(name, true, cl);
                }
                catch (ClassNotFoundException e1) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Class not found for resolving from method invocation ref:" + name));
                }
            }
            throw new ClassNotFoundException("Unknown class " + className);
        }
    }

    @Override
    public Method resolveMethod(Class clazz, String methodName, Class[] paramTypes) throws EngineImportException {
        try {
            return MethodResolver.resolveMethod(clazz, methodName, paramTypes, true);
        }
        catch (EngineNoSuchMethodException e) {
            throw this.convert(clazz, methodName, paramTypes, e, true);
        }
    }

    private EngineImportException convert(Class clazz, String methodName, Class[] paramTypes, EngineNoSuchMethodException e, boolean isInstance) {
        String expected = JavaClassHelper.getParameterAsString(paramTypes);
        String message = "Could not find ";
        message = !isInstance ? message + "static " : message + "enumeration method, date-time method or instance ";
        message = paramTypes.length > 0 ? message + "method named '" + methodName + "' in class '" + JavaClassHelper.getClassNameFullyQualPretty(clazz) + "' with matching parameter number and expected parameter type(s) '" + expected + "'" : message + "method named '" + methodName + "' in class '" + JavaClassHelper.getClassNameFullyQualPretty(clazz) + "' taking no parameters";
        if (e.getNearestMissMethod() != null) {
            message = message + " (nearest match found was '" + e.getNearestMissMethod().getName();
            message = e.getNearestMissMethod().getParameterTypes().length == 0 ? message + "' taking no parameters" : message + "' taking type(s) '" + JavaClassHelper.getParameterAsString(e.getNearestMissMethod().getParameterTypes()) + "'";
            message = message + ")";
        }
        return new EngineImportException(message, e);
    }

    private EngineImportException convert(Class clazz, Class[] paramTypes, EngineNoSuchCtorException e) {
        String expected = JavaClassHelper.getParameterAsString(paramTypes);
        String message = "Could not find constructor ";
        message = paramTypes.length > 0 ? message + "in class '" + JavaClassHelper.getClassNameFullyQualPretty(clazz) + "' with matching parameter number and expected parameter type(s) '" + expected + "'" : message + "in class '" + JavaClassHelper.getClassNameFullyQualPretty(clazz) + "' taking no parameters";
        if (e.getNearestMissCtor() != null) {
            message = message + " (nearest matching constructor ";
            message = e.getNearestMissCtor().getParameterTypes().length == 0 ? message + "taking no parameters" : message + "taking type(s) '" + JavaClassHelper.getParameterAsString(e.getNearestMissCtor().getParameterTypes()) + "'";
            message = message + ")";
        }
        return new EngineImportException(message, e);
    }

    @Override
    public ExprNode resolveAggExtendedBuiltin(String name, boolean isDistinct) {
        if (!this.allowExtendedAggregationFunc) {
            return null;
        }
        if (name.toLowerCase().equals("firstever")) {
            return new ExprFirstEverNode(isDistinct);
        }
        if (name.toLowerCase().equals("lastever")) {
            return new ExprLastEverNode(isDistinct);
        }
        if (name.toLowerCase().equals("rate")) {
            return new ExprRateAggNode(isDistinct);
        }
        if (name.toLowerCase().equals("nth")) {
            return new ExprNthAggNode(isDistinct);
        }
        if (name.toLowerCase().equals("leaving")) {
            return new ExprLeavingAggNode(isDistinct);
        }
        return null;
    }

    protected String[] getImports() {
        return this.imports.toArray(new String[this.imports.size()]);
    }

    private static boolean isFunctionName(String functionName) {
        String classNameRegEx = "\\w+";
        return functionName.matches(classNameRegEx);
    }

    private static boolean isClassName(String importName) {
        String classNameRegEx = "(\\w+\\.)*\\w+(\\$\\w+)?";
        return importName.matches(classNameRegEx);
    }

    private static boolean isPackageName(String importName) {
        String classNameRegEx = "(\\w+\\.)+\\*";
        return importName.matches(classNameRegEx);
    }

    private static String getPackageName(String importName) {
        return importName.substring(0, importName.length() - 2);
    }
}

