/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.ConfigurationDataCache;
import com.espertech.esper.client.ConfigurationMethodRef;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.epl.core.MethodPollingExecStrategy;
import com.espertech.esper.epl.core.MethodPollingViewable;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.db.DataCache;
import com.espertech.esper.epl.db.DataCacheFactory;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.MethodStreamSpec;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.schedule.ScheduleBucket;
import com.espertech.esper.schedule.SchedulingService;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.view.HistoricalEventViewable;
import java.lang.reflect.Method;
import java.util.Map;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MethodPollingViewableFactory {
    private static final Log log = LogFactory.getLog(MethodPollingViewableFactory.class);

    public static HistoricalEventViewable createPollMethodView(int streamNumber, MethodStreamSpec methodStreamSpec, EventAdapterService eventAdapterService, EPStatementAgentInstanceHandle epStatementAgentInstanceHandle, MethodResolutionService methodResolutionService, EngineImportService engineImportService, SchedulingService schedulingService, ScheduleBucket scheduleBucket, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        FastMethod staticMethod;
        Class<?> declaringClass;
        try {
            Method method = methodResolutionService.resolveMethod(methodStreamSpec.getClassName(), methodStreamSpec.getMethodName());
            declaringClass = method.getDeclaringClass();
            FastClass declaringFastClass = FastClass.create((ClassLoader)Thread.currentThread().getContextClassLoader(), method.getDeclaringClass());
            staticMethod = declaringFastClass.getMethod(method);
        }
        catch (Exception e) {
            throw new ExprValidationException(e.getMessage());
        }
        Class<?> beanClass = staticMethod.getReturnType();
        if (beanClass == Void.TYPE || beanClass == Void.class || JavaClassHelper.isJavaBuiltinDataType(beanClass)) {
            throw new ExprValidationException("Invalid return type for static method '" + staticMethod.getName() + "' of class '" + methodStreamSpec.getClassName() + "', expecting a Java class");
        }
        if (staticMethod.getReturnType().isArray()) {
            beanClass = staticMethod.getReturnType().getComponentType();
        }
        Map mapType = null;
        String mapTypeName = null;
        if (JavaClassHelper.isImplementsInterface(staticMethod.getReturnType(), Map.class) || staticMethod.getReturnType().isArray() && JavaClassHelper.isImplementsInterface(staticMethod.getReturnType().getComponentType(), Map.class)) {
            Method typeGetterMethod = null;
            String getterMethodName = methodStreamSpec.getMethodName() + "Metadata";
            try {
                typeGetterMethod = methodResolutionService.resolveMethod(methodStreamSpec.getClassName(), getterMethodName, new Class[0]);
            }
            catch (Exception e) {
                log.warn((Object)("Could not find getter method for Map-typed method invocation, expected a method by name '" + getterMethodName + "' accepting no parameters"));
            }
            if (typeGetterMethod != null && JavaClassHelper.isImplementsInterface(typeGetterMethod.getReturnType(), Map.class)) {
                Object resultType = null;
                try {
                    resultType = typeGetterMethod.invoke(null, new Object[0]);
                }
                catch (Exception e) {
                    log.warn((Object)("Error invoking getter method for Map-typed method invocation, for method by name '" + getterMethodName + "' accepting no parameters"));
                }
                if (resultType != null && resultType instanceof Map) {
                    mapTypeName = methodStreamSpec.getClassName() + "." + typeGetterMethod.getName();
                    mapType = (Map)resultType;
                }
            }
        }
        EventType eventType = mapType != null ? eventAdapterService.addNestableMapType(mapTypeName, mapType, null, false, true, true, false, false) : eventAdapterService.addBeanType(beanClass.getName(), beanClass, false, true, true);
        ConfigurationMethodRef configCache = engineImportService.getConfigurationMethodRef(declaringClass.getName());
        if (configCache == null) {
            configCache = engineImportService.getConfigurationMethodRef(declaringClass.getSimpleName());
        }
        ConfigurationDataCache dataCacheDesc = configCache != null ? configCache.getDataCacheDesc() : null;
        DataCache dataCache = DataCacheFactory.getDataCache(dataCacheDesc, epStatementAgentInstanceHandle, schedulingService, scheduleBucket);
        MethodPollingExecStrategy methodPollStrategy = new MethodPollingExecStrategy(eventAdapterService, staticMethod, mapTypeName != null, eventType);
        return new MethodPollingViewable(methodStreamSpec, streamNumber, methodStreamSpec.getExpressions(), methodPollStrategy, dataCache, eventType, exprEvaluatorContext);
    }
}

