/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EPException;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.agg.AggregationAccess;
import com.espertech.esper.epl.agg.AggregationAccessImpl;
import com.espertech.esper.epl.agg.AggregationAccessJoinImpl;
import com.espertech.esper.epl.agg.AggregationMethod;
import com.espertech.esper.epl.agg.AggregationMethodFactory;
import com.espertech.esper.epl.agg.AggregationSupport;
import com.espertech.esper.epl.agg.AvedevAggregator;
import com.espertech.esper.epl.agg.AvedevFilterAggregator;
import com.espertech.esper.epl.agg.AvgAggregator;
import com.espertech.esper.epl.agg.AvgFilterAggregator;
import com.espertech.esper.epl.agg.BigDecimalAvgAggregator;
import com.espertech.esper.epl.agg.BigDecimalAvgFilterAggregator;
import com.espertech.esper.epl.agg.BigDecimalSumAggregator;
import com.espertech.esper.epl.agg.BigDecimalSumFilterAggregator;
import com.espertech.esper.epl.agg.BigIntegerSumAggregator;
import com.espertech.esper.epl.agg.BigIntegerSumFilterAggregator;
import com.espertech.esper.epl.agg.CountAggregator;
import com.espertech.esper.epl.agg.CountFilterAggregator;
import com.espertech.esper.epl.agg.DistinctValueAggregator;
import com.espertech.esper.epl.agg.DistinctValueFilterAggregator;
import com.espertech.esper.epl.agg.DoubleSumAggregator;
import com.espertech.esper.epl.agg.DoubleSumFilterAggregator;
import com.espertech.esper.epl.agg.FirstEverValueAggregator;
import com.espertech.esper.epl.agg.FirstEverValueFilterAggregator;
import com.espertech.esper.epl.agg.FloatSumAggregator;
import com.espertech.esper.epl.agg.FloatSumFilterAggregator;
import com.espertech.esper.epl.agg.IntegerSumAggregator;
import com.espertech.esper.epl.agg.IntegerSumFilterAggregator;
import com.espertech.esper.epl.agg.LastEverValueAggregator;
import com.espertech.esper.epl.agg.LastEverValueFilterAggregator;
import com.espertech.esper.epl.agg.LeavingAggregator;
import com.espertech.esper.epl.agg.LongSumAggregator;
import com.espertech.esper.epl.agg.LongSumFilterAggregator;
import com.espertech.esper.epl.agg.MedianAggregator;
import com.espertech.esper.epl.agg.MedianFilterAggregator;
import com.espertech.esper.epl.agg.MinMaxAggregator;
import com.espertech.esper.epl.agg.MinMaxEverAggregator;
import com.espertech.esper.epl.agg.MinMaxEverFilterAggregator;
import com.espertech.esper.epl.agg.MinMaxFilterAggregator;
import com.espertech.esper.epl.agg.NonNullCountAggregator;
import com.espertech.esper.epl.agg.NonNullCountFilterAggregator;
import com.espertech.esper.epl.agg.NthAggregator;
import com.espertech.esper.epl.agg.NumIntegerSumAggregator;
import com.espertech.esper.epl.agg.NumIntegerSumFilterAggregator;
import com.espertech.esper.epl.agg.RateAggregator;
import com.espertech.esper.epl.agg.RateEverAggregator;
import com.espertech.esper.epl.agg.StddevAggregator;
import com.espertech.esper.epl.agg.StddevFilterAggregator;
import com.espertech.esper.epl.core.EngineImportException;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.epl.core.EngineImportSingleRowDesc;
import com.espertech.esper.epl.core.EngineImportUndefinedException;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.type.MinMaxTypeEnum;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MethodResolutionServiceImpl
implements MethodResolutionService {
    private static final Log log = LogFactory.getLog(MethodResolutionServiceImpl.class);
    private final EngineImportService engineImportService;
    private final TimeProvider timeProvider;

    public MethodResolutionServiceImpl(EngineImportService engineImportService, TimeProvider timeProvider) {
        this.engineImportService = engineImportService;
        this.timeProvider = timeProvider;
    }

    @Override
    public boolean isUdfCache() {
        return this.engineImportService.isUdfCache();
    }

    @Override
    public boolean isDuckType() {
        return this.engineImportService.isDuckType();
    }

    @Override
    public AggregationSupport makePlugInAggregator(String functionName) {
        try {
            return this.engineImportService.resolveAggregation(functionName);
        }
        catch (EngineImportUndefinedException e) {
            throw new EPException("Failed to make new aggregation function instance for '" + functionName + "'", e);
        }
        catch (EngineImportException e) {
            throw new EPException("Failed to make new aggregation function instance for '" + functionName + "'", e);
        }
    }

    @Override
    public Method resolveMethod(String className, String methodName, Class[] paramTypes) throws EngineImportException {
        return this.engineImportService.resolveMethod(className, methodName, paramTypes);
    }

    @Override
    public Method resolveMethod(String className, String methodName) throws EngineImportException {
        return this.engineImportService.resolveMethod(className, methodName);
    }

    @Override
    public Constructor resolveCtor(Class clazz, Class[] paramTypes) throws EngineImportException {
        return this.engineImportService.resolveCtor(clazz, paramTypes);
    }

    @Override
    public Class resolveClass(String className) throws EngineImportException {
        return this.engineImportService.resolveClass(className);
    }

    @Override
    public Method resolveMethod(Class clazz, String methodName, Class[] paramTypes) throws EngineImportException {
        return this.engineImportService.resolveMethod(clazz, methodName, paramTypes);
    }

    @Override
    public AggregationMethod makeCountAggregator(int[] agentInstanceIds, int groupId, int aggregationId, boolean isIgnoreNull, boolean hasFilter) {
        if (!hasFilter) {
            if (isIgnoreNull) {
                return new NonNullCountAggregator();
            }
            return new CountAggregator();
        }
        if (isIgnoreNull) {
            return new NonNullCountFilterAggregator();
        }
        return new CountFilterAggregator();
    }

    @Override
    public AggregationSupport resolveAggregation(String functionName) throws EngineImportUndefinedException, EngineImportException {
        return this.engineImportService.resolveAggregation(functionName);
    }

    @Override
    public Pair<Class, EngineImportSingleRowDesc> resolveSingleRow(String functionName) throws EngineImportUndefinedException, EngineImportException {
        return this.engineImportService.resolveSingleRow(functionName);
    }

    @Override
    public AggregationMethod makeSumAggregator(int[] agentInstanceIds, int groupId, int aggregationId, Class type, boolean hasFilter) {
        if (!hasFilter) {
            if (type == BigInteger.class) {
                return new BigIntegerSumAggregator();
            }
            if (type == BigDecimal.class) {
                return new BigDecimalSumAggregator();
            }
            if (type == Long.class || type == Long.TYPE) {
                return new LongSumAggregator();
            }
            if (type == Integer.class || type == Integer.TYPE) {
                return new IntegerSumAggregator();
            }
            if (type == Double.class || type == Double.TYPE) {
                return new DoubleSumAggregator();
            }
            if (type == Float.class || type == Float.TYPE) {
                return new FloatSumAggregator();
            }
            return new NumIntegerSumAggregator();
        }
        if (type == BigInteger.class) {
            return new BigIntegerSumFilterAggregator();
        }
        if (type == BigDecimal.class) {
            return new BigDecimalSumFilterAggregator();
        }
        if (type == Long.class || type == Long.TYPE) {
            return new LongSumFilterAggregator();
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return new IntegerSumFilterAggregator();
        }
        if (type == Double.class || type == Double.TYPE) {
            return new DoubleSumFilterAggregator();
        }
        if (type == Float.class || type == Float.TYPE) {
            return new FloatSumFilterAggregator();
        }
        return new NumIntegerSumFilterAggregator();
    }

    @Override
    public Class getSumAggregatorType(Class type) {
        if (type == BigInteger.class) {
            return BigInteger.class;
        }
        if (type == BigDecimal.class) {
            return BigDecimal.class;
        }
        if (type == Long.class || type == Long.TYPE) {
            return Long.class;
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Double.class || type == Double.TYPE) {
            return Double.class;
        }
        if (type == Float.class || type == Float.TYPE) {
            return Float.class;
        }
        return Integer.class;
    }

    @Override
    public AggregationMethod makeDistinctAggregator(int[] agentInstanceIds, int groupId, int aggregationId, AggregationMethod aggregationMethod, Class childType, boolean hasFilter) {
        if (hasFilter) {
            return new DistinctValueFilterAggregator(aggregationMethod, childType);
        }
        return new DistinctValueAggregator(aggregationMethod, childType);
    }

    @Override
    public AggregationMethod makeAvgAggregator(int[] agentInstanceIds, int groupId, int aggregationId, Class type, boolean hasFilter) {
        if (hasFilter) {
            if (type == BigDecimal.class || type == BigInteger.class) {
                return new BigDecimalAvgFilterAggregator();
            }
            return new AvgFilterAggregator();
        }
        if (type == BigDecimal.class || type == BigInteger.class) {
            return new BigDecimalAvgAggregator();
        }
        return new AvgAggregator();
    }

    @Override
    public Class getAvgAggregatorType(Class type) {
        if (type == BigDecimal.class || type == BigInteger.class) {
            return BigDecimal.class;
        }
        return Double.class;
    }

    @Override
    public AggregationMethod makeAvedevAggregator(int[] agentInstanceIds, int groupId, int aggregationId, boolean hasFilter) {
        if (!hasFilter) {
            return new AvedevAggregator();
        }
        return new AvedevFilterAggregator();
    }

    @Override
    public AggregationMethod makeMedianAggregator(int[] agentInstanceIds, int groupId, int aggregationId, boolean hasFilter) {
        if (!hasFilter) {
            return new MedianAggregator();
        }
        return new MedianFilterAggregator();
    }

    @Override
    public AggregationMethod makeMinMaxAggregator(int[] agentInstanceIds, int groupId, int aggregationId, MinMaxTypeEnum minMaxTypeEnum, Class targetType, boolean isHasDataWindows, boolean hasFilter) {
        if (!hasFilter) {
            if (!isHasDataWindows) {
                return new MinMaxEverAggregator(minMaxTypeEnum, targetType);
            }
            return new MinMaxAggregator(minMaxTypeEnum, targetType);
        }
        if (!isHasDataWindows) {
            return new MinMaxEverFilterAggregator(minMaxTypeEnum, targetType);
        }
        return new MinMaxFilterAggregator(minMaxTypeEnum, targetType);
    }

    @Override
    public AggregationMethod makeStddevAggregator(int[] agentInstanceIds, int groupId, int aggregationId, boolean hasFilter) {
        if (!hasFilter) {
            return new StddevAggregator();
        }
        return new StddevFilterAggregator();
    }

    @Override
    public AggregationMethod makeFirstEverValueAggregator(int[] agentInstanceIds, int groupId, int aggregationId, Class type, boolean hasFilter) {
        if (hasFilter) {
            return new FirstEverValueFilterAggregator(type);
        }
        return new FirstEverValueAggregator(type);
    }

    @Override
    public AggregationMethod makeLastEverValueAggregator(int[] agentInstanceIds, int groupId, int aggregationId, Class type, boolean hasFilter) {
        if (hasFilter) {
            return new LastEverValueFilterAggregator(type);
        }
        return new LastEverValueAggregator(type);
    }

    @Override
    public AggregationMethod makeRateAggregator(int[] agentInstanceIds, int groupId, int aggregationId) {
        return new RateAggregator();
    }

    @Override
    public AggregationMethod makeRateEverAggregator(int[] agentInstanceIds, int groupId, int aggregationId, long interval) {
        return new RateEverAggregator(interval, this.timeProvider);
    }

    @Override
    public AggregationMethod makeNthAggregator(int[] agentInstanceIds, int groupId, int aggregationId, Class returnType, int size) {
        return new NthAggregator(returnType, size);
    }

    @Override
    public AggregationMethod makeLeavingAggregator(int[] agentInstanceIds, int groupId, int aggregationId) {
        return new LeavingAggregator();
    }

    @Override
    public void setGroupKeyTypes(Class[] groupKeyTypes) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Group key typed are " + Arrays.toString(groupKeyTypes)));
        }
    }

    @Override
    public AggregationMethod[] newAggregators(AggregationMethodFactory[] prototypes, int[] agentInstanceId) {
        return this.newAggregatorsInternal(prototypes, agentInstanceId);
    }

    @Override
    public AggregationMethod[] newAggregators(AggregationMethodFactory[] prototypes, int[] agentInstanceId, MultiKeyUntyped groupKey) {
        return this.newAggregatorsInternal(prototypes, agentInstanceId);
    }

    public AggregationMethod[] newAggregatorsInternal(AggregationMethodFactory[] prototypes, int[] agentInstanceId) {
        AggregationMethod[] row = new AggregationMethod[prototypes.length];
        for (int i = 0; i < prototypes.length; ++i) {
            row[i] = prototypes[i].make(this, agentInstanceId, -1, i);
        }
        return row;
    }

    @Override
    public long getCurrentRowCount(AggregationMethod[] aggregators, AggregationAccess[] groupAccesses) {
        return 0L;
    }

    @Override
    public void removeAggregators(int[] agentInstanceIds, MultiKeyUntyped groupKey) {
    }

    @Override
    public AggregationAccess makeAccessStreamId(int[] agentInstanceIds, boolean isJoin, int streamId, MultiKeyUntyped groupKey) {
        if (isJoin) {
            return new AggregationAccessJoinImpl(streamId);
        }
        return new AggregationAccessImpl(streamId);
    }

    @Override
    public void destroyedAgentInstance(int[] agentInstanceIds) {
    }
}

