/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.epl.agg.AggregationService;
import com.espertech.esper.epl.core.OrderByElement;
import com.espertech.esper.epl.core.OrderByProcessor;
import com.espertech.esper.epl.core.OrderByProcessorFactory;
import com.espertech.esper.epl.core.OrderByProcessorImpl;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.OrderByItem;
import com.espertech.esper.util.MetaDefItem;
import com.espertech.esper.util.MultiKeyCollatingComparator;
import com.espertech.esper.util.MultiKeyComparator;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OrderByProcessorFactoryImpl
implements OrderByProcessorFactory {
    private static final Log log = LogFactory.getLog(OrderByProcessorFactoryImpl.class);
    private final OrderByElement[] orderBy;
    private final ExprEvaluator[] groupByNodes;
    private final boolean needsGroupByKeys;
    private final Comparator<MultiKeyUntyped> comparator;

    public OrderByProcessorFactoryImpl(List<OrderByItem> orderByList, List<ExprNode> groupByNodes, boolean needsGroupByKeys, boolean isSortUsingCollator) throws ExprValidationException {
        this.orderBy = this.toElementArray(orderByList);
        this.groupByNodes = ExprNodeUtility.getEvaluators(groupByNodes);
        this.needsGroupByKeys = needsGroupByKeys;
        this.comparator = OrderByProcessorFactoryImpl.getComparator(this.orderBy, isSortUsingCollator);
    }

    @Override
    public OrderByProcessor instantiate(AggregationService aggregationService) {
        return new OrderByProcessorImpl(this, aggregationService);
    }

    public OrderByElement[] getOrderBy() {
        return this.orderBy;
    }

    public ExprEvaluator[] getGroupByNodes() {
        return this.groupByNodes;
    }

    public boolean isNeedsGroupByKeys() {
        return this.needsGroupByKeys;
    }

    public Comparator<MultiKeyUntyped> getComparator() {
        return this.comparator;
    }

    protected static Comparator<MultiKeyUntyped> getComparator(OrderByElement[] orderBy, boolean isSortUsingCollator) throws ExprValidationException {
        MetaDefItem comparator;
        if (isSortUsingCollator) {
            boolean hasStringTypes = false;
            boolean[] stringTypes = new boolean[orderBy.length];
            int count = 0;
            for (OrderByElement item : orderBy) {
                if (item.getExpr().getType() == String.class) {
                    hasStringTypes = true;
                    stringTypes[count] = true;
                }
                ++count;
            }
            comparator = !hasStringTypes ? new MultiKeyComparator(OrderByProcessorFactoryImpl.getIsDescendingValues(orderBy)) : new MultiKeyCollatingComparator(OrderByProcessorFactoryImpl.getIsDescendingValues(orderBy), stringTypes);
        } else {
            comparator = new MultiKeyComparator(OrderByProcessorFactoryImpl.getIsDescendingValues(orderBy));
        }
        return comparator;
    }

    private static boolean[] getIsDescendingValues(OrderByElement[] orderBy) {
        boolean[] isDescendingValues = new boolean[orderBy.length];
        int count = 0;
        for (OrderByElement pair : orderBy) {
            isDescendingValues[count++] = pair.isDescending();
        }
        return isDescendingValues;
    }

    private OrderByElement[] toElementArray(List<OrderByItem> orderByList) {
        OrderByElement[] elements = new OrderByElement[orderByList.size()];
        int count = 0;
        for (OrderByItem item : orderByList) {
            elements[count++] = new OrderByElement(item.getExprNode().getExprEvaluator(), item.isDescending());
        }
        return elements;
    }
}

