/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.core.ResultSetProcessorAggregateAll;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ResultSetAggregateAllIterator
implements Iterator<EventBean> {
    private final Iterator<EventBean> sourceIterator;
    private final ResultSetProcessorAggregateAll resultSetProcessor;
    private EventBean nextResult;
    private final EventBean[] eventsPerStream;
    private ExprEvaluatorContext exprEvaluatorContext;

    public ResultSetAggregateAllIterator(Iterator<EventBean> sourceIterator, ResultSetProcessorAggregateAll resultSetProcessor, ExprEvaluatorContext exprEvaluatorContext) {
        this.sourceIterator = sourceIterator;
        this.resultSetProcessor = resultSetProcessor;
        this.eventsPerStream = new EventBean[1];
        this.exprEvaluatorContext = exprEvaluatorContext;
    }

    @Override
    public boolean hasNext() {
        if (this.nextResult != null) {
            return true;
        }
        this.findNext();
        return this.nextResult != null;
    }

    @Override
    public EventBean next() {
        if (this.nextResult != null) {
            EventBean result = this.nextResult;
            this.nextResult = null;
            return result;
        }
        this.findNext();
        if (this.nextResult != null) {
            EventBean result = this.nextResult;
            this.nextResult = null;
            return result;
        }
        throw new NoSuchElementException();
    }

    private void findNext() {
        while (this.sourceIterator.hasNext()) {
            EventBean candidate;
            this.eventsPerStream[0] = candidate = this.sourceIterator.next();
            Boolean pass = true;
            if (this.resultSetProcessor.getOptionalHavingNode() != null) {
                pass = (Boolean)this.resultSetProcessor.getOptionalHavingNode().evaluate(this.eventsPerStream, true, this.exprEvaluatorContext);
            }
            if (!pass.booleanValue()) continue;
            this.nextResult = this.resultSetProcessor.getSelectExprProcessor().process(this.eventsPerStream, true, true, this.exprEvaluatorContext);
            break;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

