/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.ContextPropertyRegistry;
import com.espertech.esper.core.service.ExprEvaluatorContextStatement;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.epl.agg.AggregationServiceFactoryDesc;
import com.espertech.esper.epl.agg.AggregationServiceFactoryFactory;
import com.espertech.esper.epl.core.ColumnNamedNodeSwapper;
import com.espertech.esper.epl.core.OrderByProcessorFactory;
import com.espertech.esper.epl.core.OrderByProcessorFactoryFactory;
import com.espertech.esper.epl.core.PropertyResolutionDescriptor;
import com.espertech.esper.epl.core.ResultSetProcessorAggregateAllFactory;
import com.espertech.esper.epl.core.ResultSetProcessorAggregateGroupedFactory;
import com.espertech.esper.epl.core.ResultSetProcessorFactory;
import com.espertech.esper.epl.core.ResultSetProcessorFactoryDesc;
import com.espertech.esper.epl.core.ResultSetProcessorHandThrougFactory;
import com.espertech.esper.epl.core.ResultSetProcessorRowForAllFactory;
import com.espertech.esper.epl.core.ResultSetProcessorRowPerGroupFactory;
import com.espertech.esper.epl.core.ResultSetProcessorSimpleFactory;
import com.espertech.esper.epl.core.SelectExprEventTypeRegistry;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.core.SelectExprProcessorFactory;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.StreamTypesException;
import com.espertech.esper.epl.core.ViewResourceDelegateUnverified;
import com.espertech.esper.epl.expression.ExprAggregateNode;
import com.espertech.esper.epl.expression.ExprAggregateNodeUtil;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeIdentifierVisitor;
import com.espertech.esper.epl.expression.ExprNodeSubselectVisitor;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.InsertIntoDesc;
import com.espertech.esper.epl.spec.OrderByItem;
import com.espertech.esper.epl.spec.OutputLimitLimitType;
import com.espertech.esper.epl.spec.OutputLimitSpec;
import com.espertech.esper.epl.spec.SelectClauseElementCompiled;
import com.espertech.esper.epl.spec.SelectClauseExprCompiledSpec;
import com.espertech.esper.epl.spec.SelectClauseSpecCompiled;
import com.espertech.esper.epl.spec.SelectClauseStreamCompiledSpec;
import com.espertech.esper.epl.spec.SelectClauseStreamSelectorEnum;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import com.espertech.esper.event.NativeEventType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResultSetProcessorFactoryFactory {
    private static final Log log = LogFactory.getLog(ResultSetProcessorFactoryFactory.class);

    public static ResultSetProcessorFactoryDesc getProcessorPrototype(StatementSpecCompiled statementSpecCompiled, AgentInstanceContext agentInstanceContext, StreamTypeService typeService, ViewResourceDelegateUnverified viewResourceDelegate, boolean[] isUnidirectionalStream, boolean allowAggregation, ContextPropertyRegistry contextPropertyRegistry) throws ExprValidationException {
        ResultSetProcessorFactory factory;
        boolean isLast;
        ExprEvaluator optionHavingEval;
        boolean isOutputLimiting;
        boolean isSelectRStream;
        boolean hasAggregation;
        SelectClauseSpecCompiled selectClauseSpec = statementSpecCompiled.getSelectClauseSpec();
        InsertIntoDesc insertIntoDesc = statementSpecCompiled.getInsertIntoDesc();
        List<ExprNode> groupByNodes = statementSpecCompiled.getGroupByExpressions();
        ExprNode optionalHavingNode = statementSpecCompiled.getHavingExprRootNode();
        OutputLimitSpec outputLimitSpec = statementSpecCompiled.getOutputLimitSpec();
        List<OrderByItem> orderByList = statementSpecCompiled.getOrderByList();
        if (log.isDebugEnabled()) {
            log.debug((Object)(".getProcessor Getting processor for  selectionList=" + selectClauseSpec.getSelectExprList() + " groupByNodes=" + Arrays.toString(groupByNodes.toArray()) + " optionalHavingNode=" + optionalHavingNode));
        }
        boolean isUnidirectional = false;
        for (int i = 0; i < isUnidirectionalStream.length; ++i) {
            isUnidirectional |= isUnidirectionalStream[i];
        }
        ResultSetProcessorFactoryFactory.expandColumnNames(selectClauseSpec.getSelectExprList(), orderByList);
        LinkedList<SelectClauseExprCompiledSpec> namedSelectionList = new LinkedList<SelectClauseExprCompiledSpec>();
        StatementContext stmtContext = agentInstanceContext.getStatementContext();
        ExprEvaluatorContextStatement evaluatorContextStmt = new ExprEvaluatorContextStatement(stmtContext);
        ExprValidationContext validationContext = new ExprValidationContext(typeService, stmtContext.getMethodResolutionService(), viewResourceDelegate, stmtContext.getSchedulingService(), stmtContext.getVariableService(), evaluatorContextStmt, stmtContext.getEventAdapterService(), stmtContext.getStatementName(), stmtContext.getStatementId(), stmtContext.getAnnotations(), stmtContext.getContextDescriptor());
        for (int i = 0; i < selectClauseSpec.getSelectExprList().size(); ++i) {
            SelectClauseElementCompiled element = selectClauseSpec.getSelectExprList().get(i);
            if (!(element instanceof SelectClauseExprCompiledSpec)) continue;
            SelectClauseExprCompiledSpec expr = (SelectClauseExprCompiledSpec)element;
            ExprNode validatedExpression = ExprNodeUtility.getValidatedSubtree(expr.getSelectExpression(), validationContext);
            String asName = expr.getAssignedName();
            if (asName == null) {
                asName = validatedExpression.toExpressionString();
            }
            expr.setAssignedName(asName);
            expr.setSelectExpression(validatedExpression);
            namedSelectionList.add(expr);
        }
        boolean isUsingWildcard = selectClauseSpec.isUsingWildcard();
        boolean isUsingStreamSelect = false;
        for (SelectClauseElementCompiled compiled : selectClauseSpec.getSelectExprList()) {
            if (!(compiled instanceof SelectClauseStreamCompiledSpec)) continue;
            SelectClauseStreamCompiledSpec streamSelectSpec = (SelectClauseStreamCompiledSpec)compiled;
            int streamNum = Integer.MIN_VALUE;
            boolean isFragmentEvent = false;
            boolean isProperty = false;
            Class propertyType = null;
            isUsingStreamSelect = true;
            for (int i = 0; i < typeService.getStreamNames().length; ++i) {
                String streamName = streamSelectSpec.getStreamName();
                if (typeService.getStreamNames()[i].equals(streamName)) {
                    streamNum = i;
                    break;
                }
                EventType candidateProviderOfFragments = typeService.getEventTypes()[i];
                if (candidateProviderOfFragments instanceof NativeEventType || candidateProviderOfFragments.getFragmentType(streamName) == null) continue;
                streamNum = i;
                isFragmentEvent = true;
                break;
            }
            if (streamNum == Integer.MIN_VALUE) {
                PropertyResolutionDescriptor desc = null;
                try {
                    desc = typeService.resolveByPropertyName(streamSelectSpec.getStreamName());
                }
                catch (StreamTypesException e) {
                    // empty catch block
                }
                if (desc == null) {
                    throw new ExprValidationException("Stream selector '" + streamSelectSpec.getStreamName() + ".*' does not match any stream name in the from clause");
                }
                isProperty = true;
                propertyType = desc.getPropertyType();
                streamNum = desc.getStreamNum();
            }
            streamSelectSpec.setStreamNumber(streamNum);
            streamSelectSpec.setFragmentEvent(isFragmentEvent);
            streamSelectSpec.setProperty(isProperty, propertyType);
        }
        Class[] groupByTypes = new Class[groupByNodes.size()];
        for (int i = 0; i < groupByNodes.size(); ++i) {
            ExprNodeSubselectVisitor visitor = new ExprNodeSubselectVisitor();
            groupByNodes.get(i).accept(visitor);
            if (visitor.getSubselects().size() > 0) {
                throw new ExprValidationException("Subselects not allowed within group-by");
            }
            ExprNode validatedGroupBy = ExprNodeUtility.getValidatedSubtree(groupByNodes.get(i), validationContext);
            groupByNodes.set(i, validatedGroupBy);
            groupByTypes[i] = validatedGroupBy.getExprEvaluator().getType();
        }
        stmtContext.getMethodResolutionService().setGroupKeyTypes(groupByTypes);
        if (optionalHavingNode != null) {
            ExprNodeSubselectVisitor visitor = new ExprNodeSubselectVisitor();
            optionalHavingNode.accept(visitor);
            if (visitor.getSubselects().size() > 0) {
                throw new ExprValidationException("Subselects not allowed within having-clause");
            }
            optionalHavingNode = ExprNodeUtility.getValidatedSubtree(optionalHavingNode, validationContext);
        }
        for (int i = 0; i < orderByList.size(); ++i) {
            ExprNode orderByNode = orderByList.get(i).getExprNode();
            ExprNodeSubselectVisitor visitor = new ExprNodeSubselectVisitor();
            orderByNode.accept(visitor);
            if (visitor.getSubselects().size() > 0) {
                throw new ExprValidationException("Subselects not allowed within order-by clause");
            }
            Boolean isDescending = orderByList.get(i).isDescending();
            OrderByItem validatedOrderBy = new OrderByItem(ExprNodeUtility.getValidatedSubtree(orderByNode, validationContext), isDescending);
            orderByList.set(i, validatedOrderBy);
        }
        ArrayList<ExprNode> selectNodes = new ArrayList<ExprNode>();
        for (SelectClauseExprCompiledSpec element : namedSelectionList) {
            selectNodes.add(element.getSelectExpression());
        }
        ArrayList<ExprNode> orderByNodes = new ArrayList<ExprNode>();
        for (OrderByItem element : orderByList) {
            orderByNodes.add(element.getExprNode());
        }
        LinkedList<ExprAggregateNode> selectAggregateExprNodes = new LinkedList<ExprAggregateNode>();
        for (SelectClauseExprCompiledSpec element : namedSelectionList) {
            ExprAggregateNodeUtil.getAggregatesBottomUp(element.getSelectExpression(), selectAggregateExprNodes);
        }
        if (!allowAggregation && !selectAggregateExprNodes.isEmpty()) {
            throw new ExprValidationException("Aggregation functions are not allowed in this context");
        }
        LinkedList<ExprAggregateNode> havingAggregateExprNodes = new LinkedList<ExprAggregateNode>();
        Set<Object> propertiesAggregatedHaving = new HashSet();
        if (optionalHavingNode != null) {
            ExprAggregateNodeUtil.getAggregatesBottomUp(optionalHavingNode, havingAggregateExprNodes);
            propertiesAggregatedHaving = ExprNodeUtility.getAggregatedProperties(havingAggregateExprNodes);
        }
        if (!allowAggregation && !havingAggregateExprNodes.isEmpty()) {
            throw new ExprValidationException("Aggregation functions are not allowed in this context");
        }
        LinkedList<ExprAggregateNode> orderByAggregateExprNodes = new LinkedList<ExprAggregateNode>();
        if (orderByNodes != null) {
            for (ExprNode orderByNode : orderByNodes) {
                ExprAggregateNodeUtil.getAggregatesBottomUp(orderByNode, orderByAggregateExprNodes);
            }
            if (!allowAggregation && !orderByAggregateExprNodes.isEmpty()) {
                throw new ExprValidationException("Aggregation functions are not allowed in this context");
            }
        }
        boolean hasGroupBy = !groupByNodes.isEmpty();
        AggregationServiceFactoryDesc aggregationServiceFactory = AggregationServiceFactoryFactory.getService(selectAggregateExprNodes, havingAggregateExprNodes, orderByAggregateExprNodes, hasGroupBy, stmtContext.getMethodResolutionService(), evaluatorContextStmt, statementSpecCompiled.getAnnotations(), stmtContext.getVariableService(), typeService.getEventTypes().length > 1, statementSpecCompiled.getFilterRootNode(), statementSpecCompiled.getHavingExprRootNode());
        boolean useCollatorSort = false;
        if (stmtContext.getConfigSnapshot() != null) {
            useCollatorSort = stmtContext.getConfigSnapshot().getEngineDefaults().getLanguage().isSortUsingCollator();
        }
        OrderByProcessorFactory orderByProcessorFactory = OrderByProcessorFactoryFactory.getProcessor(namedSelectionList, groupByNodes, orderByList, statementSpecCompiled.getRowLimitSpec(), stmtContext.getVariableService(), useCollatorSort);
        SelectExprEventTypeRegistry selectExprEventTypeRegistry = new SelectExprEventTypeRegistry(stmtContext.getDynamicReferenceEventTypes());
        SelectExprProcessor selectExprProcessor = SelectExprProcessorFactory.getProcessor(Collections.<Integer>emptyList(), selectClauseSpec.getSelectExprList(), isUsingWildcard, insertIntoDesc, statementSpecCompiled.getForClauseSpec(), typeService, stmtContext.getEventAdapterService(), stmtContext.getStatementResultService(), stmtContext.getValueAddEventService(), selectExprEventTypeRegistry, stmtContext.getMethodResolutionService(), evaluatorContextStmt, stmtContext.getVariableService(), stmtContext.getTimeProvider(), stmtContext.getEngineURI(), stmtContext.getStatementId(), stmtContext.getStatementName(), stmtContext.getAnnotations(), stmtContext.getContextDescriptor());
        Set<Pair<Integer, String>> propertiesGroupBy = ResultSetProcessorFactoryFactory.getGroupByProperties(groupByNodes);
        Set<Pair<Integer, String>> nonAggregatedProps = ExprNodeUtility.getNonAggregatedProps(typeService.getEventTypes(), selectNodes, contextPropertyRegistry);
        if (optionalHavingNode != null) {
            ExprNodeUtility.addNonAggregatedProps(optionalHavingNode, nonAggregatedProps);
        }
        ResultSetProcessorFactoryFactory.validateGroupBy(groupByNodes);
        boolean bl = hasAggregation = !selectAggregateExprNodes.isEmpty() || !havingAggregateExprNodes.isEmpty() || !orderByAggregateExprNodes.isEmpty() || !propertiesAggregatedHaving.isEmpty();
        if (optionalHavingNode != null && hasAggregation) {
            ResultSetProcessorFactoryFactory.validateHaving(propertiesGroupBy, optionalHavingNode);
        }
        boolean bl2 = isSelectRStream = statementSpecCompiled.getSelectStreamSelectorEnum() == SelectClauseStreamSelectorEnum.RSTREAM_ISTREAM_BOTH || statementSpecCompiled.getSelectStreamSelectorEnum() == SelectClauseStreamSelectorEnum.RSTREAM_ONLY;
        if (statementSpecCompiled.getInsertIntoDesc() != null && !statementSpecCompiled.getInsertIntoDesc().isIStream()) {
            isSelectRStream = true;
        }
        boolean bl3 = isOutputLimiting = outputLimitSpec != null;
        if (outputLimitSpec != null && outputLimitSpec.getDisplayLimit() == OutputLimitLimitType.SNAPSHOT) {
            isOutputLimiting = false;
        }
        ExprEvaluator exprEvaluator = optionHavingEval = optionalHavingNode == null ? null : optionalHavingNode.getExprEvaluator();
        if (groupByNodes.isEmpty() && selectAggregateExprNodes.isEmpty() && havingAggregateExprNodes.isEmpty()) {
            if (orderByNodes.isEmpty() && optionalHavingNode == null && !isOutputLimiting && statementSpecCompiled.getRowLimitSpec() == null) {
                log.debug((Object)".getProcessor Using no result processor");
                ResultSetProcessorHandThrougFactory factory2 = new ResultSetProcessorHandThrougFactory(selectExprProcessor, isSelectRStream);
                return new ResultSetProcessorFactoryDesc(factory2, orderByProcessorFactory, aggregationServiceFactory);
            }
            log.debug((Object)".getProcessor Using ResultSetProcessorSimple");
            ResultSetProcessorSimpleFactory factory3 = new ResultSetProcessorSimpleFactory(selectExprProcessor, optionHavingEval, isSelectRStream);
            return new ResultSetProcessorFactoryDesc(factory3, orderByProcessorFactory, aggregationServiceFactory);
        }
        boolean bl4 = isLast = statementSpecCompiled.getOutputLimitSpec() != null && statementSpecCompiled.getOutputLimitSpec().getDisplayLimit() == OutputLimitLimitType.LAST;
        if (namedSelectionList.isEmpty() && propertiesAggregatedHaving.isEmpty() && havingAggregateExprNodes.isEmpty() && !isLast) {
            log.debug((Object)".getProcessor Using ResultSetProcessorSimple");
            ResultSetProcessorSimpleFactory factory4 = new ResultSetProcessorSimpleFactory(selectExprProcessor, optionHavingEval, isSelectRStream);
            return new ResultSetProcessorFactoryDesc(factory4, orderByProcessorFactory, aggregationServiceFactory);
        }
        if (groupByNodes.isEmpty() && hasAggregation) {
            if (nonAggregatedProps.isEmpty() && !isUsingWildcard && !isUsingStreamSelect) {
                log.debug((Object)".getProcessor Using ResultSetProcessorRowForAll");
                ResultSetProcessorRowForAllFactory factory5 = new ResultSetProcessorRowForAllFactory(selectExprProcessor, optionHavingEval, isSelectRStream, isUnidirectional);
                return new ResultSetProcessorFactoryDesc(factory5, orderByProcessorFactory, aggregationServiceFactory);
            }
            log.debug((Object)".getProcessor Using ResultSetProcessorAggregateAll");
            ResultSetProcessorAggregateAllFactory factory6 = new ResultSetProcessorAggregateAllFactory(selectExprProcessor, optionHavingEval, isSelectRStream, isUnidirectional);
            return new ResultSetProcessorFactoryDesc(factory6, orderByProcessorFactory, aggregationServiceFactory);
        }
        if (groupByNodes.isEmpty()) {
            throw new IllegalStateException("Unexpected empty group-by expression list");
        }
        Set<Pair<Integer, String>> nonAggregatedPropsSelect = ExprNodeUtility.getNonAggregatedProps(typeService.getEventTypes(), selectNodes, contextPropertyRegistry);
        boolean allInGroupBy = true;
        if (isUsingStreamSelect) {
            allInGroupBy = false;
        }
        for (Pair<Integer, String> nonAggregatedProp : nonAggregatedPropsSelect) {
            if (propertiesGroupBy.contains(nonAggregatedProp)) continue;
            allInGroupBy = false;
        }
        if (isUsingWildcard) {
            allInGroupBy = false;
        }
        Set<Pair<Integer, String>> nonAggregatedPropsOrderBy = ExprNodeUtility.getNonAggregatedProps(typeService.getEventTypes(), orderByNodes, contextPropertyRegistry);
        boolean allInSelect = true;
        for (Pair<Integer, String> nonAggregatedProp : nonAggregatedPropsOrderBy) {
            if (nonAggregatedPropsSelect.contains(nonAggregatedProp)) continue;
            allInSelect = false;
        }
        if (isUsingWildcard) {
            allInSelect = true;
        }
        ExprEvaluator[] groupByEval = ExprNodeUtility.getEvaluators(groupByNodes);
        if (allInGroupBy && allInSelect) {
            log.debug((Object)".getProcessor Using ResultSetProcessorRowPerGroup");
            factory = new ResultSetProcessorRowPerGroupFactory(selectExprProcessor, groupByEval, optionHavingEval, isSelectRStream, isUnidirectional, outputLimitSpec, orderByProcessorFactory != null);
            return new ResultSetProcessorFactoryDesc(factory, orderByProcessorFactory, aggregationServiceFactory);
        }
        log.debug((Object)".getProcessor Using ResultSetProcessorAggregateGrouped");
        factory = new ResultSetProcessorAggregateGroupedFactory(selectExprProcessor, groupByEval, optionHavingEval, isSelectRStream, isUnidirectional, outputLimitSpec, orderByProcessorFactory != null);
        return new ResultSetProcessorFactoryDesc(factory, orderByProcessorFactory, aggregationServiceFactory);
    }

    private static void validateHaving(Set<Pair<Integer, String>> propertiesGroupedBy, ExprNode havingNode) throws ExprValidationException {
        LinkedList<ExprAggregateNode> aggregateNodesHaving = new LinkedList<ExprAggregateNode>();
        if (aggregateNodesHaving != null) {
            ExprAggregateNodeUtil.getAggregatesBottomUp(havingNode, aggregateNodesHaving);
        }
        if (!propertiesGroupedBy.isEmpty()) {
            ExprNodeIdentifierVisitor visitor = new ExprNodeIdentifierVisitor(true);
            havingNode.accept(visitor);
            List<Pair<Integer, String>> allPropertiesHaving = visitor.getExprProperties();
            Set<Pair<Integer, String>> aggPropertiesHaving = ExprNodeUtility.getAggregatedProperties(aggregateNodesHaving);
            allPropertiesHaving.removeAll(aggPropertiesHaving);
            allPropertiesHaving.removeAll(propertiesGroupedBy);
            if (!allPropertiesHaving.isEmpty()) {
                String name = allPropertiesHaving.iterator().next().getSecond();
                throw new ExprValidationException("Non-aggregated property '" + name + "' in the HAVING clause must occur in the group-by clause");
            }
        }
    }

    private static void validateGroupBy(List<ExprNode> groupByNodes) throws ExprValidationException {
        LinkedList<ExprAggregateNode> aggNodes = new LinkedList<ExprAggregateNode>();
        for (ExprNode groupByNode : groupByNodes) {
            ExprAggregateNodeUtil.getAggregatesBottomUp(groupByNode, aggNodes);
            if (aggNodes.isEmpty()) continue;
            throw new ExprValidationException("Group-by expressions cannot contain aggregate functions");
        }
    }

    private static Set<Pair<Integer, String>> getGroupByProperties(List<ExprNode> groupByNodes) throws ExprValidationException {
        HashSet<Pair<Integer, String>> propertiesGroupBy = new HashSet<Pair<Integer, String>>();
        for (ExprNode groupByNode : groupByNodes) {
            ExprNodeIdentifierVisitor visitor = new ExprNodeIdentifierVisitor(true);
            groupByNode.accept(visitor);
            List<Pair<Integer, String>> propertiesNode = visitor.getExprProperties();
            propertiesGroupBy.addAll(propertiesNode);
            if (!propertiesNode.isEmpty()) continue;
            throw new ExprValidationException("Group-by expressions must refer to property names");
        }
        return propertiesGroupBy;
    }

    private static void expandColumnNames(List<SelectClauseElementCompiled> selectionList, List<OrderByItem> orderByList) {
        for (SelectClauseElementCompiled selectElement : selectionList) {
            SelectClauseExprCompiledSpec selectExpr;
            String name;
            if (!(selectElement instanceof SelectClauseExprCompiledSpec) || (name = (selectExpr = (SelectClauseExprCompiledSpec)selectElement).getAssignedName()) == null) continue;
            ExprNode fullExpr = selectExpr.getSelectExpression();
            ListIterator<OrderByItem> iterator = orderByList.listIterator();
            while (iterator.hasNext()) {
                OrderByItem orderByElement = iterator.next();
                ExprNode swapped = ColumnNamedNodeSwapper.swap(orderByElement.getExprNode(), name, fullExpr);
                OrderByItem newOrderByElement = new OrderByItem(swapped, orderByElement.isDescending());
                iterator.set(newOrderByElement);
            }
        }
    }
}

