/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ArrayEventIterator;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.agg.AggregationService;
import com.espertech.esper.epl.core.OrderByProcessor;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.core.ResultSetProcessorRowPerGroupFactory;
import com.espertech.esper.epl.core.ResultSetRowPerGroupIterator;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.OutputLimitLimitType;
import com.espertech.esper.epl.view.OutputConditionPolled;
import com.espertech.esper.epl.view.OutputConditionPolledFactory;
import com.espertech.esper.view.Viewable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResultSetProcessorRowPerGroup
implements ResultSetProcessor {
    private static final Log log = LogFactory.getLog(ResultSetProcessorRowPerGroup.class);
    private final ResultSetProcessorRowPerGroupFactory prototype;
    private final SelectExprProcessor selectExprProcessor;
    private final OrderByProcessor orderByProcessor;
    private final AggregationService aggregationService;
    private final AgentInstanceContext agentInstanceContext;
    private final Map<MultiKeyUntyped, EventBean[]> groupRepsView = new LinkedHashMap<MultiKeyUntyped, EventBean[]>();
    private final Map<MultiKeyUntyped, OutputConditionPolled> outputState = new HashMap<MultiKeyUntyped, OutputConditionPolled>();

    public ResultSetProcessorRowPerGroup(ResultSetProcessorRowPerGroupFactory prototype, SelectExprProcessor selectExprProcessor, OrderByProcessor orderByProcessor, AggregationService aggregationService, AgentInstanceContext agentInstanceContext) {
        this.prototype = prototype;
        this.selectExprProcessor = selectExprProcessor;
        this.orderByProcessor = orderByProcessor;
        this.aggregationService = aggregationService;
        this.agentInstanceContext = agentInstanceContext;
    }

    @Override
    public EventType getResultEventType() {
        return this.prototype.getResultEventType();
    }

    @Override
    public UniformPair<EventBean[]> processJoinResult(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents, boolean isSynthesize) {
        EventBean[] selectNewEvents;
        int count;
        HashMap<MultiKeyUntyped, EventBean[]> keysAndEvents = new HashMap<MultiKeyUntyped, EventBean[]>();
        MultiKeyUntyped[] newDataMultiKey = this.generateGroupKeys(newEvents, keysAndEvents, true);
        MultiKeyUntyped[] oldDataMultiKey = this.generateGroupKeys(oldEvents, keysAndEvents, false);
        if (this.prototype.isUnidirectional()) {
            this.clear();
        }
        EventBean[] selectOldEvents = null;
        if (this.prototype.isSelectRStream()) {
            selectOldEvents = this.generateOutputEventsJoin(keysAndEvents, false, isSynthesize);
        }
        if (!newEvents.isEmpty()) {
            count = 0;
            for (MultiKey<EventBean> eventsPerStream : newEvents) {
                this.aggregationService.applyEnter(eventsPerStream.getArray(), newDataMultiKey[count], this.agentInstanceContext);
                ++count;
            }
        }
        if (oldEvents != null && !oldEvents.isEmpty()) {
            count = 0;
            for (MultiKey<EventBean> eventsPerStream : oldEvents) {
                this.aggregationService.applyLeave(eventsPerStream.getArray(), oldDataMultiKey[count], this.agentInstanceContext);
                ++count;
            }
        }
        if ((selectNewEvents = this.generateOutputEventsJoin(keysAndEvents, true, isSynthesize)) != null || selectOldEvents != null) {
            return new UniformPair<EventBean[]>(selectNewEvents, selectOldEvents);
        }
        return null;
    }

    @Override
    public UniformPair<EventBean[]> processViewResult(EventBean[] newData, EventBean[] oldData, boolean isSynthesize) {
        EventBean[] selectNewEvents;
        int i;
        HashMap<MultiKeyUntyped, EventBean> keysAndEvents = new HashMap<MultiKeyUntyped, EventBean>();
        MultiKeyUntyped[] newDataMultiKey = this.generateGroupKeys(newData, keysAndEvents, true);
        MultiKeyUntyped[] oldDataMultiKey = this.generateGroupKeys(oldData, keysAndEvents, false);
        EventBean[] selectOldEvents = null;
        if (this.prototype.isSelectRStream()) {
            selectOldEvents = this.generateOutputEventsView(keysAndEvents, false, isSynthesize);
        }
        EventBean[] eventsPerStream = new EventBean[1];
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                eventsPerStream[0] = newData[i];
                this.aggregationService.applyEnter(eventsPerStream, newDataMultiKey[i], this.agentInstanceContext);
            }
        }
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                eventsPerStream[0] = oldData[i];
                this.aggregationService.applyLeave(eventsPerStream, oldDataMultiKey[i], this.agentInstanceContext);
            }
        }
        if ((selectNewEvents = this.generateOutputEventsView(keysAndEvents, true, isSynthesize)) != null || selectOldEvents != null) {
            return new UniformPair<EventBean[]>(selectNewEvents, selectOldEvents);
        }
        return null;
    }

    private EventBean[] generateOutputEventsView(Map<MultiKeyUntyped, EventBean> keysAndEvents, boolean isNewData, boolean isSynthesize) {
        EventBean[] eventsPerStream = new EventBean[1];
        EventBean[] events = new EventBean[keysAndEvents.size()];
        MultiKeyUntyped[] keys = new MultiKeyUntyped[keysAndEvents.size()];
        EventBean[][] currentGenerators = null;
        if (this.prototype.isSorting()) {
            currentGenerators = new EventBean[keysAndEvents.size()][];
        }
        int count = 0;
        for (Map.Entry<MultiKeyUntyped, EventBean> entry : keysAndEvents.entrySet()) {
            Boolean result;
            this.aggregationService.setCurrentAccess(entry.getKey(), this.agentInstanceContext.getAgentInstanceIds());
            eventsPerStream[0] = entry.getValue();
            if (this.prototype.getOptionalHavingNode() != null && ((result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(eventsPerStream, isNewData, this.agentInstanceContext)) == null || !result.booleanValue())) continue;
            events[count] = this.selectExprProcessor.process(eventsPerStream, isNewData, isSynthesize, this.agentInstanceContext);
            keys[count] = entry.getKey();
            if (this.prototype.isSorting()) {
                EventBean[] currentEventsPerStream = new EventBean[]{entry.getValue()};
                currentGenerators[count] = currentEventsPerStream;
            }
            ++count;
        }
        if (count != events.length) {
            if (count == 0) {
                return null;
            }
            EventBean[] out = new EventBean[count];
            System.arraycopy(events, 0, out, 0, count);
            events = out;
            if (this.prototype.isSorting()) {
                MultiKeyUntyped[] outKeys = new MultiKeyUntyped[count];
                System.arraycopy(keys, 0, outKeys, 0, count);
                keys = outKeys;
                EventBean[][] outGens = new EventBean[count][];
                System.arraycopy(currentGenerators, 0, outGens, 0, count);
                currentGenerators = outGens;
            }
        }
        if (this.prototype.isSorting()) {
            events = this.orderByProcessor.sort(events, currentGenerators, keys, isNewData, this.agentInstanceContext);
        }
        return events;
    }

    private void generateOutputBatched(Map<MultiKeyUntyped, EventBean> keysAndEvents, boolean isNewData, boolean isSynthesize, List<EventBean> resultEvents, List<MultiKeyUntyped> optSortKeys, AgentInstanceContext agentInstanceContext) {
        EventBean[] eventsPerStream = new EventBean[1];
        for (Map.Entry<MultiKeyUntyped, EventBean> entry : keysAndEvents.entrySet()) {
            Boolean result;
            this.aggregationService.setCurrentAccess(entry.getKey(), agentInstanceContext.getAgentInstanceIds());
            eventsPerStream[0] = entry.getValue();
            if (this.prototype.getOptionalHavingNode() != null && ((result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(eventsPerStream, isNewData, agentInstanceContext)) == null || !result.booleanValue())) continue;
            resultEvents.add(this.selectExprProcessor.process(eventsPerStream, isNewData, isSynthesize, agentInstanceContext));
            if (!this.prototype.isSorting()) continue;
            optSortKeys.add(this.orderByProcessor.getSortKey(eventsPerStream, isNewData, agentInstanceContext));
        }
    }

    private void generateOutputBatchedArr(Map<MultiKeyUntyped, EventBean[]> keysAndEvents, boolean isNewData, boolean isSynthesize, List<EventBean> resultEvents, List<MultiKeyUntyped> optSortKeys) {
        for (Map.Entry<MultiKeyUntyped, EventBean[]> entry : keysAndEvents.entrySet()) {
            this.generateOutputBatched(entry.getKey(), entry.getValue(), isNewData, isSynthesize, resultEvents, optSortKeys);
        }
    }

    private void generateOutputBatched(MultiKeyUntyped mk, EventBean[] eventsPerStream, boolean isNewData, boolean isSynthesize, List<EventBean> resultEvents, List<MultiKeyUntyped> optSortKeys) {
        Boolean result;
        this.aggregationService.setCurrentAccess(mk, this.agentInstanceContext.getAgentInstanceIds());
        if (!(this.prototype.getOptionalHavingNode() == null || (result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(eventsPerStream, isNewData, this.agentInstanceContext)) != null && result.booleanValue())) {
            return;
        }
        resultEvents.add(this.selectExprProcessor.process(eventsPerStream, isNewData, isSynthesize, this.agentInstanceContext));
        if (this.prototype.isSorting()) {
            optSortKeys.add(this.orderByProcessor.getSortKey(eventsPerStream, isNewData, this.agentInstanceContext));
        }
    }

    private EventBean[] generateOutputEventsJoin(Map<MultiKeyUntyped, EventBean[]> keysAndEvents, boolean isNewData, boolean isSynthesize) {
        EventBean[] events = new EventBean[keysAndEvents.size()];
        MultiKeyUntyped[] keys = new MultiKeyUntyped[keysAndEvents.size()];
        EventBean[][] currentGenerators = null;
        if (this.prototype.isSorting()) {
            currentGenerators = new EventBean[keysAndEvents.size()][];
        }
        int count = 0;
        for (Map.Entry<MultiKeyUntyped, EventBean[]> entry : keysAndEvents.entrySet()) {
            Boolean result;
            this.aggregationService.setCurrentAccess(entry.getKey(), this.agentInstanceContext.getAgentInstanceIds());
            EventBean[] eventsPerStream = entry.getValue();
            if (this.prototype.getOptionalHavingNode() != null && ((result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(eventsPerStream, isNewData, this.agentInstanceContext)) == null || !result.booleanValue())) continue;
            events[count] = this.selectExprProcessor.process(eventsPerStream, isNewData, isSynthesize, this.agentInstanceContext);
            keys[count] = entry.getKey();
            if (this.prototype.isSorting()) {
                currentGenerators[count] = eventsPerStream;
            }
            ++count;
        }
        if (count != events.length) {
            if (count == 0) {
                return null;
            }
            EventBean[] out = new EventBean[count];
            System.arraycopy(events, 0, out, 0, count);
            events = out;
            if (this.prototype.isSorting()) {
                MultiKeyUntyped[] outKeys = new MultiKeyUntyped[count];
                System.arraycopy(keys, 0, outKeys, 0, count);
                keys = outKeys;
                EventBean[][] outGens = new EventBean[count][];
                System.arraycopy(currentGenerators, 0, outGens, 0, count);
                currentGenerators = outGens;
            }
        }
        if (this.prototype.isSorting()) {
            events = this.orderByProcessor.sort(events, currentGenerators, keys, isNewData, this.agentInstanceContext);
        }
        return events;
    }

    private MultiKeyUntyped[] generateGroupKeys(EventBean[] events, boolean isNewData) {
        if (events == null) {
            return null;
        }
        EventBean[] eventsPerStream = new EventBean[1];
        MultiKeyUntyped[] keys = new MultiKeyUntyped[events.length];
        for (int i = 0; i < events.length; ++i) {
            eventsPerStream[0] = events[i];
            keys[i] = this.generateGroupKey(eventsPerStream, isNewData);
        }
        return keys;
    }

    private MultiKeyUntyped[] generateGroupKeys(EventBean[] events, Map<MultiKeyUntyped, EventBean> eventPerKey, boolean isNewData) {
        if (events == null) {
            return null;
        }
        EventBean[] eventsPerStream = new EventBean[1];
        MultiKeyUntyped[] keys = new MultiKeyUntyped[events.length];
        for (int i = 0; i < events.length; ++i) {
            eventsPerStream[0] = events[i];
            keys[i] = this.generateGroupKey(eventsPerStream, isNewData);
            eventPerKey.put(keys[i], events[i]);
        }
        return keys;
    }

    private MultiKeyUntyped[] generateGroupKeys(Set<MultiKey<EventBean>> resultSet, Map<MultiKeyUntyped, EventBean[]> eventPerKey, boolean isNewData) {
        if (resultSet == null || resultSet.isEmpty()) {
            return null;
        }
        MultiKeyUntyped[] keys = new MultiKeyUntyped[resultSet.size()];
        int count = 0;
        for (MultiKey<EventBean> eventsPerStream : resultSet) {
            keys[count] = this.generateGroupKey(eventsPerStream.getArray(), isNewData);
            eventPerKey.put(keys[count], eventsPerStream.getArray());
            ++count;
        }
        return keys;
    }

    protected MultiKeyUntyped generateGroupKey(EventBean[] eventsPerStream, boolean isNewData) {
        Object[] keys = new Object[this.prototype.getGroupKeyNodes().length];
        for (int i = 0; i < this.prototype.getGroupKeyNodes().length; ++i) {
            keys[i] = this.prototype.getGroupKeyNodes()[i].evaluate(eventsPerStream, isNewData, this.agentInstanceContext);
        }
        return new MultiKeyUntyped(keys);
    }

    public ExprEvaluator getOptionalHavingNode() {
        return this.prototype.getOptionalHavingNode();
    }

    public SelectExprProcessor getSelectExprProcessor() {
        return this.selectExprProcessor;
    }

    @Override
    public Iterator<EventBean> getIterator(Viewable parent) {
        if (this.orderByProcessor == null) {
            return new ResultSetRowPerGroupIterator(parent.iterator(), this, this.aggregationService, this.agentInstanceContext);
        }
        EventBean[] eventsPerStream = new EventBean[1];
        ArrayList<EventBean> outgoingEvents = new ArrayList<EventBean>();
        ArrayList<MultiKeyUntyped> orderKeys = new ArrayList<MultiKeyUntyped>();
        HashSet<MultiKeyUntyped> priorSeenGroups = new HashSet<MultiKeyUntyped>();
        Iterator<EventBean> i$ = parent.iterator();
        while (i$.hasNext()) {
            EventBean candidate;
            eventsPerStream[0] = candidate = i$.next();
            MultiKeyUntyped groupKey = this.generateGroupKey(eventsPerStream, true);
            this.aggregationService.setCurrentAccess(groupKey, this.agentInstanceContext.getAgentInstanceIds());
            Boolean pass = true;
            if (this.prototype.getOptionalHavingNode() != null) {
                pass = (Boolean)this.prototype.getOptionalHavingNode().evaluate(eventsPerStream, true, this.agentInstanceContext);
            }
            if (pass == null || !pass.booleanValue() || priorSeenGroups.contains(groupKey)) continue;
            priorSeenGroups.add(groupKey);
            outgoingEvents.add(this.selectExprProcessor.process(eventsPerStream, true, true, this.agentInstanceContext));
            MultiKeyUntyped orderKey = this.orderByProcessor.getSortKey(eventsPerStream, true, this.agentInstanceContext);
            orderKeys.add(orderKey);
        }
        EventBean[] outgoingEventsArr = outgoingEvents.toArray(new EventBean[outgoingEvents.size()]);
        MultiKeyUntyped[] orderKeysArr = orderKeys.toArray(new MultiKeyUntyped[orderKeys.size()]);
        EventBean[] orderedEvents = this.orderByProcessor.sort(outgoingEventsArr, orderKeysArr, this.agentInstanceContext);
        return new ArrayEventIterator(orderedEvents);
    }

    @Override
    public Iterator<EventBean> getIterator(Set<MultiKey<EventBean>> joinSet) {
        HashMap<MultiKeyUntyped, EventBean[]> keysAndEvents = new HashMap<MultiKeyUntyped, EventBean[]>();
        this.generateGroupKeys(joinSet, keysAndEvents, true);
        EventBean[] selectNewEvents = this.generateOutputEventsJoin(keysAndEvents, true, true);
        return new ArrayEventIterator(selectNewEvents);
    }

    @Override
    public void clear() {
        this.aggregationService.clearResults(this.agentInstanceContext);
    }

    @Override
    public UniformPair<EventBean[]> processOutputLimitedJoin(List<UniformPair<Set<MultiKey<EventBean>>>> joinEventsSet, boolean generateSynthetic, OutputLimitLimitType outputLimitLimitType) {
        if (outputLimitLimitType == OutputLimitLimitType.DEFAULT) {
            LinkedList<EventBean> newEvents = new LinkedList<EventBean>();
            LinkedList<EventBean> oldEvents = null;
            if (this.prototype.isSelectRStream()) {
                oldEvents = new LinkedList<EventBean>();
            }
            LinkedList<MultiKeyUntyped> newEventsSortKey = null;
            LinkedList<MultiKeyUntyped> oldEventsSortKey = null;
            if (this.orderByProcessor != null) {
                newEventsSortKey = new LinkedList<MultiKeyUntyped>();
                if (this.prototype.isSelectRStream()) {
                    oldEventsSortKey = new LinkedList<MultiKeyUntyped>();
                }
            }
            HashMap<MultiKeyUntyped, EventBean[]> keysAndEvents = new HashMap<MultiKeyUntyped, EventBean[]>();
            for (UniformPair<Set<MultiKey<EventBean>>> pair : joinEventsSet) {
                int count;
                Set<MultiKey<EventBean>> newData = pair.getFirst();
                Set<MultiKey<EventBean>> oldData = pair.getSecond();
                if (this.prototype.isUnidirectional()) {
                    this.clear();
                }
                MultiKeyUntyped[] newDataMultiKey = this.generateGroupKeys(newData, keysAndEvents, true);
                MultiKeyUntyped[] oldDataMultiKey = this.generateGroupKeys(oldData, keysAndEvents, false);
                if (this.prototype.isSelectRStream()) {
                    this.generateOutputBatchedArr(keysAndEvents, false, generateSynthetic, oldEvents, oldEventsSortKey);
                }
                if (newData != null) {
                    count = 0;
                    for (MultiKey<EventBean> aNewData : newData) {
                        this.aggregationService.applyEnter(aNewData.getArray(), newDataMultiKey[count], this.agentInstanceContext);
                        ++count;
                    }
                }
                if (oldData != null) {
                    count = 0;
                    for (MultiKey<EventBean> anOldData : oldData) {
                        this.aggregationService.applyLeave(anOldData.getArray(), oldDataMultiKey[count], this.agentInstanceContext);
                        ++count;
                    }
                }
                this.generateOutputBatchedArr(keysAndEvents, true, generateSynthetic, newEvents, newEventsSortKey);
                keysAndEvents.clear();
            }
            EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
            EventBean[] oldEventsArr = null;
            if (this.prototype.isSelectRStream()) {
                EventBean[] eventBeanArray = oldEventsArr = oldEvents.isEmpty() ? null : oldEvents.toArray(new EventBean[oldEvents.size()]);
            }
            if (this.orderByProcessor != null) {
                MultiKeyUntyped[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new MultiKeyUntyped[newEventsSortKey.size()]);
                newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.agentInstanceContext);
                if (this.prototype.isSelectRStream()) {
                    MultiKeyUntyped[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.toArray(new MultiKeyUntyped[oldEventsSortKey.size()]);
                    oldEventsArr = this.orderByProcessor.sort(oldEventsArr, sortKeysOld, this.agentInstanceContext);
                }
            }
            if (newEventsArr == null && oldEventsArr == null) {
                return null;
            }
            return new UniformPair<EventBean[]>(newEventsArr, oldEventsArr);
        }
        if (outputLimitLimitType == OutputLimitLimitType.ALL) {
            LinkedList<EventBean> newEvents = new LinkedList<EventBean>();
            LinkedList<EventBean> oldEvents = null;
            if (this.prototype.isSelectRStream()) {
                oldEvents = new LinkedList<EventBean>();
            }
            LinkedList<MultiKeyUntyped> newEventsSortKey = null;
            LinkedList<MultiKeyUntyped> oldEventsSortKey = null;
            if (this.orderByProcessor != null) {
                newEventsSortKey = new LinkedList<MultiKeyUntyped>();
                if (this.prototype.isSelectRStream()) {
                    oldEventsSortKey = new LinkedList<MultiKeyUntyped>();
                }
            }
            if (this.prototype.isSelectRStream()) {
                this.generateOutputBatchedArr(this.groupRepsView, false, generateSynthetic, oldEvents, oldEventsSortKey);
            }
            for (UniformPair<Set<MultiKey<EventBean>>> pair : joinEventsSet) {
                MultiKeyUntyped mk;
                Set<MultiKey<EventBean>> newData = pair.getFirst();
                Set<MultiKey<EventBean>> oldData = pair.getSecond();
                if (this.prototype.isUnidirectional()) {
                    this.clear();
                }
                if (newData != null) {
                    for (MultiKey<EventBean> aNewData : newData) {
                        mk = this.generateGroupKey(aNewData.getArray(), true);
                        if (this.groupRepsView.put(mk, aNewData.getArray()) == null && this.prototype.isSelectRStream()) {
                            this.generateOutputBatched(mk, aNewData.getArray(), false, generateSynthetic, oldEvents, oldEventsSortKey);
                        }
                        this.aggregationService.applyEnter(aNewData.getArray(), mk, this.agentInstanceContext);
                    }
                }
                if (oldData == null) continue;
                for (MultiKey<EventBean> anOldData : oldData) {
                    mk = this.generateGroupKey(anOldData.getArray(), true);
                    if (this.groupRepsView.put(mk, anOldData.getArray()) == null && this.prototype.isSelectRStream()) {
                        this.generateOutputBatched(mk, anOldData.getArray(), false, generateSynthetic, oldEvents, oldEventsSortKey);
                    }
                    this.aggregationService.applyLeave(anOldData.getArray(), mk, this.agentInstanceContext);
                }
            }
            this.generateOutputBatchedArr(this.groupRepsView, true, generateSynthetic, newEvents, newEventsSortKey);
            EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
            EventBean[] oldEventsArr = null;
            if (this.prototype.isSelectRStream()) {
                EventBean[] eventBeanArray = oldEventsArr = oldEvents.isEmpty() ? null : oldEvents.toArray(new EventBean[oldEvents.size()]);
            }
            if (this.orderByProcessor != null) {
                MultiKeyUntyped[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new MultiKeyUntyped[newEventsSortKey.size()]);
                newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.agentInstanceContext);
                if (this.prototype.isSelectRStream()) {
                    MultiKeyUntyped[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.toArray(new MultiKeyUntyped[oldEventsSortKey.size()]);
                    oldEventsArr = this.orderByProcessor.sort(oldEventsArr, sortKeysOld, this.agentInstanceContext);
                }
            }
            if (newEventsArr == null && oldEventsArr == null) {
                return null;
            }
            return new UniformPair<EventBean[]>(newEventsArr, oldEventsArr);
        }
        if (outputLimitLimitType == OutputLimitLimitType.FIRST) {
            Set<MultiKey<EventBean>> oldData;
            Set<MultiKey<EventBean>> newData;
            LinkedList<EventBean> newEvents = new LinkedList<EventBean>();
            LinkedList<EventBean> oldEvents = null;
            if (this.prototype.isSelectRStream()) {
                oldEvents = new LinkedList<EventBean>();
            }
            LinkedList<MultiKeyUntyped> newEventsSortKey = null;
            LinkedList<MultiKeyUntyped> oldEventsSortKey = null;
            if (this.orderByProcessor != null) {
                newEventsSortKey = new LinkedList<MultiKeyUntyped>();
                if (this.prototype.isSelectRStream()) {
                    oldEventsSortKey = new LinkedList<MultiKeyUntyped>();
                }
            }
            this.groupRepsView.clear();
            if (this.prototype.getOptionalHavingNode() == null) {
                for (UniformPair<Set<MultiKey<EventBean>>> pair : joinEventsSet) {
                    boolean pass;
                    OutputConditionPolled outputStateGroup;
                    MultiKeyUntyped mk;
                    newData = pair.getFirst();
                    oldData = pair.getSecond();
                    if (newData != null) {
                        for (MultiKey<EventBean> aNewData : newData) {
                            mk = this.generateGroupKey(aNewData.getArray(), true);
                            outputStateGroup = this.outputState.get(mk);
                            if (outputStateGroup == null) {
                                try {
                                    outputStateGroup = OutputConditionPolledFactory.createCondition(this.prototype.getOutputLimitSpec(), this.agentInstanceContext);
                                }
                                catch (ExprValidationException e) {
                                    log.error((Object)("Error starting output limit for group for statement '" + this.agentInstanceContext.getStatementContext().getStatementName() + "'"));
                                }
                                this.outputState.put(mk, outputStateGroup);
                            }
                            if ((pass = outputStateGroup.updateOutputCondition(1, 0)) && this.groupRepsView.put(mk, aNewData.getArray()) == null && this.prototype.isSelectRStream()) {
                                this.generateOutputBatched(mk, aNewData.getArray(), false, generateSynthetic, oldEvents, oldEventsSortKey);
                            }
                            this.aggregationService.applyEnter(aNewData.getArray(), mk, this.agentInstanceContext);
                        }
                    }
                    if (oldData == null) continue;
                    for (MultiKey<EventBean> anOldData : oldData) {
                        mk = this.generateGroupKey(anOldData.getArray(), true);
                        outputStateGroup = this.outputState.get(mk);
                        if (outputStateGroup == null) {
                            try {
                                outputStateGroup = OutputConditionPolledFactory.createCondition(this.prototype.getOutputLimitSpec(), this.agentInstanceContext);
                            }
                            catch (ExprValidationException e) {
                                log.error((Object)("Error starting output limit for group for statement '" + this.agentInstanceContext.getStatementContext().getStatementName() + "'"));
                            }
                            this.outputState.put(mk, outputStateGroup);
                        }
                        if ((pass = outputStateGroup.updateOutputCondition(0, 1)) && this.groupRepsView.put(mk, anOldData.getArray()) == null && this.prototype.isSelectRStream()) {
                            this.generateOutputBatched(mk, anOldData.getArray(), false, generateSynthetic, oldEvents, oldEventsSortKey);
                        }
                        this.aggregationService.applyLeave(anOldData.getArray(), mk, this.agentInstanceContext);
                    }
                }
            } else {
                this.groupRepsView.clear();
                for (UniformPair<Set<MultiKey<EventBean>>> pair : joinEventsSet) {
                    boolean pass;
                    OutputConditionPolled outputStateGroup;
                    Boolean result;
                    MultiKeyUntyped mk;
                    int count;
                    newData = pair.getFirst();
                    oldData = pair.getSecond();
                    MultiKeyUntyped[] newDataMultiKey = this.generateGroupKeys(newData, true);
                    MultiKeyUntyped[] oldDataMultiKey = this.generateGroupKeys(oldData, false);
                    if (newData != null) {
                        count = 0;
                        for (MultiKey<EventBean> aNewData : newData) {
                            this.aggregationService.applyEnter(aNewData.getArray(), newDataMultiKey[count], this.agentInstanceContext);
                            ++count;
                        }
                    }
                    if (oldData != null) {
                        count = 0;
                        for (MultiKey<EventBean> anOldData : oldData) {
                            this.aggregationService.applyLeave(anOldData.getArray(), oldDataMultiKey[count], this.agentInstanceContext);
                            ++count;
                        }
                    }
                    if (newData != null) {
                        count = 0;
                        for (MultiKey<EventBean> aNewData : newData) {
                            mk = newDataMultiKey[count];
                            this.aggregationService.setCurrentAccess(mk, this.agentInstanceContext.getAgentInstanceIds());
                            result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(aNewData.getArray(), true, this.agentInstanceContext);
                            if (result == null || !result.booleanValue()) {
                                ++count;
                                continue;
                            }
                            outputStateGroup = this.outputState.get(mk);
                            if (outputStateGroup == null) {
                                try {
                                    outputStateGroup = OutputConditionPolledFactory.createCondition(this.prototype.getOutputLimitSpec(), this.agentInstanceContext);
                                }
                                catch (ExprValidationException e) {
                                    log.error((Object)("Error starting output limit for group for statement '" + this.agentInstanceContext.getStatementContext().getStatementName() + "'"));
                                }
                                this.outputState.put(mk, outputStateGroup);
                            }
                            if ((pass = outputStateGroup.updateOutputCondition(1, 0)) && this.groupRepsView.put(mk, aNewData.getArray()) == null && this.prototype.isSelectRStream()) {
                                this.generateOutputBatched(mk, aNewData.getArray(), false, generateSynthetic, oldEvents, oldEventsSortKey);
                            }
                            ++count;
                        }
                    }
                    if (oldData == null) continue;
                    count = 0;
                    for (MultiKey<EventBean> anOldData : oldData) {
                        mk = oldDataMultiKey[count];
                        this.aggregationService.setCurrentAccess(mk, this.agentInstanceContext.getAgentInstanceIds());
                        result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(anOldData.getArray(), false, this.agentInstanceContext);
                        if (result == null || !result.booleanValue()) {
                            ++count;
                            continue;
                        }
                        outputStateGroup = this.outputState.get(mk);
                        if (outputStateGroup == null) {
                            try {
                                outputStateGroup = OutputConditionPolledFactory.createCondition(this.prototype.getOutputLimitSpec(), this.agentInstanceContext);
                            }
                            catch (ExprValidationException e) {
                                log.error((Object)("Error starting output limit for group for statement '" + this.agentInstanceContext.getStatementContext().getStatementName() + "'"));
                            }
                            this.outputState.put(mk, outputStateGroup);
                        }
                        if ((pass = outputStateGroup.updateOutputCondition(0, 1)) && this.groupRepsView.put(mk, anOldData.getArray()) == null && this.prototype.isSelectRStream()) {
                            this.generateOutputBatched(mk, anOldData.getArray(), false, generateSynthetic, oldEvents, oldEventsSortKey);
                        }
                        ++count;
                    }
                }
            }
            this.generateOutputBatchedArr(this.groupRepsView, true, generateSynthetic, newEvents, newEventsSortKey);
            EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
            EventBean[] oldEventsArr = null;
            if (this.prototype.isSelectRStream()) {
                EventBean[] eventBeanArray = oldEventsArr = oldEvents.isEmpty() ? null : oldEvents.toArray(new EventBean[oldEvents.size()]);
            }
            if (this.orderByProcessor != null) {
                MultiKeyUntyped[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new MultiKeyUntyped[newEventsSortKey.size()]);
                newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.agentInstanceContext);
                if (this.prototype.isSelectRStream()) {
                    MultiKeyUntyped[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.toArray(new MultiKeyUntyped[oldEventsSortKey.size()]);
                    oldEventsArr = this.orderByProcessor.sort(oldEventsArr, sortKeysOld, this.agentInstanceContext);
                }
            }
            if (newEventsArr == null && oldEventsArr == null) {
                return null;
            }
            return new UniformPair<EventBean[]>(newEventsArr, oldEventsArr);
        }
        LinkedList<EventBean> newEvents = new LinkedList<EventBean>();
        LinkedList<EventBean> oldEvents = null;
        if (this.prototype.isSelectRStream()) {
            oldEvents = new LinkedList<EventBean>();
        }
        LinkedList<MultiKeyUntyped> newEventsSortKey = null;
        LinkedList<MultiKeyUntyped> oldEventsSortKey = null;
        if (this.orderByProcessor != null) {
            newEventsSortKey = new LinkedList<MultiKeyUntyped>();
            if (this.prototype.isSelectRStream()) {
                oldEventsSortKey = new LinkedList<MultiKeyUntyped>();
            }
        }
        this.groupRepsView.clear();
        for (UniformPair<Set<MultiKey<EventBean>>> pair : joinEventsSet) {
            MultiKeyUntyped mk;
            Set<MultiKey<EventBean>> newData = pair.getFirst();
            Set<MultiKey<EventBean>> oldData = pair.getSecond();
            if (this.prototype.isUnidirectional()) {
                this.clear();
            }
            if (newData != null) {
                for (MultiKey<EventBean> aNewData : newData) {
                    mk = this.generateGroupKey(aNewData.getArray(), true);
                    if (this.groupRepsView.put(mk, aNewData.getArray()) == null && this.prototype.isSelectRStream()) {
                        this.generateOutputBatched(mk, aNewData.getArray(), false, generateSynthetic, oldEvents, oldEventsSortKey);
                    }
                    this.aggregationService.applyEnter(aNewData.getArray(), mk, this.agentInstanceContext);
                }
            }
            if (oldData == null) continue;
            for (MultiKey<EventBean> anOldData : oldData) {
                mk = this.generateGroupKey(anOldData.getArray(), true);
                if (this.groupRepsView.put(mk, anOldData.getArray()) == null && this.prototype.isSelectRStream()) {
                    this.generateOutputBatched(mk, anOldData.getArray(), false, generateSynthetic, oldEvents, oldEventsSortKey);
                }
                this.aggregationService.applyLeave(anOldData.getArray(), mk, this.agentInstanceContext);
            }
        }
        this.generateOutputBatchedArr(this.groupRepsView, true, generateSynthetic, newEvents, newEventsSortKey);
        EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
        EventBean[] oldEventsArr = null;
        if (this.prototype.isSelectRStream()) {
            EventBean[] eventBeanArray = oldEventsArr = oldEvents.isEmpty() ? null : oldEvents.toArray(new EventBean[oldEvents.size()]);
        }
        if (this.orderByProcessor != null) {
            MultiKeyUntyped[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new MultiKeyUntyped[newEventsSortKey.size()]);
            newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.agentInstanceContext);
            if (this.prototype.isSelectRStream()) {
                MultiKeyUntyped[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.toArray(new MultiKeyUntyped[oldEventsSortKey.size()]);
                oldEventsArr = this.orderByProcessor.sort(oldEventsArr, sortKeysOld, this.agentInstanceContext);
            }
        }
        if (newEventsArr == null && oldEventsArr == null) {
            return null;
        }
        return new UniformPair<EventBean[]>(newEventsArr, oldEventsArr);
    }

    @Override
    public UniformPair<EventBean[]> processOutputLimitedView(List<UniformPair<EventBean[]>> viewEventsList, boolean generateSynthetic, OutputLimitLimitType outputLimitLimitType) {
        if (outputLimitLimitType == OutputLimitLimitType.DEFAULT) {
            LinkedList<EventBean> newEvents = new LinkedList<EventBean>();
            LinkedList<EventBean> oldEvents = null;
            if (this.prototype.isSelectRStream()) {
                oldEvents = new LinkedList<EventBean>();
            }
            LinkedList<MultiKeyUntyped> newEventsSortKey = null;
            LinkedList<MultiKeyUntyped> oldEventsSortKey = null;
            if (this.orderByProcessor != null) {
                newEventsSortKey = new LinkedList<MultiKeyUntyped>();
                if (this.prototype.isSelectRStream()) {
                    oldEventsSortKey = new LinkedList<MultiKeyUntyped>();
                }
            }
            HashMap<MultiKeyUntyped, EventBean> keysAndEvents = new HashMap<MultiKeyUntyped, EventBean>();
            for (UniformPair<EventBean[]> pair : viewEventsList) {
                int i$;
                int len$;
                EventBean[] arr$;
                int count;
                EventBean[] newData = pair.getFirst();
                EventBean[] oldData = pair.getSecond();
                MultiKeyUntyped[] newDataMultiKey = this.generateGroupKeys(newData, keysAndEvents, true);
                MultiKeyUntyped[] oldDataMultiKey = this.generateGroupKeys(oldData, keysAndEvents, false);
                if (this.prototype.isSelectRStream()) {
                    this.generateOutputBatched(keysAndEvents, false, generateSynthetic, oldEvents, oldEventsSortKey, this.agentInstanceContext);
                }
                EventBean[] eventsPerStream = new EventBean[1];
                if (newData != null) {
                    count = 0;
                    arr$ = newData;
                    len$ = arr$.length;
                    for (i$ = 0; i$ < len$; ++i$) {
                        EventBean aNewData;
                        eventsPerStream[0] = aNewData = arr$[i$];
                        this.aggregationService.applyEnter(eventsPerStream, newDataMultiKey[count], this.agentInstanceContext);
                        ++count;
                    }
                }
                if (oldData != null) {
                    count = 0;
                    arr$ = oldData;
                    len$ = arr$.length;
                    for (i$ = 0; i$ < len$; ++i$) {
                        EventBean anOldData;
                        eventsPerStream[0] = anOldData = arr$[i$];
                        this.aggregationService.applyLeave(eventsPerStream, oldDataMultiKey[count], this.agentInstanceContext);
                        ++count;
                    }
                }
                this.generateOutputBatched(keysAndEvents, true, generateSynthetic, newEvents, newEventsSortKey, this.agentInstanceContext);
                keysAndEvents.clear();
            }
            EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
            EventBean[] oldEventsArr = null;
            if (this.prototype.isSelectRStream()) {
                EventBean[] eventBeanArray = oldEventsArr = oldEvents.isEmpty() ? null : oldEvents.toArray(new EventBean[oldEvents.size()]);
            }
            if (this.orderByProcessor != null) {
                MultiKeyUntyped[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new MultiKeyUntyped[newEventsSortKey.size()]);
                newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.agentInstanceContext);
                if (this.prototype.isSelectRStream()) {
                    MultiKeyUntyped[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.toArray(new MultiKeyUntyped[oldEventsSortKey.size()]);
                    oldEventsArr = this.orderByProcessor.sort(oldEventsArr, sortKeysOld, this.agentInstanceContext);
                }
            }
            if (newEventsArr == null && oldEventsArr == null) {
                return null;
            }
            return new UniformPair<EventBean[]>(newEventsArr, oldEventsArr);
        }
        if (outputLimitLimitType == OutputLimitLimitType.ALL) {
            EventBean[] eventsPerStream = new EventBean[1];
            LinkedList<EventBean> newEvents = new LinkedList<EventBean>();
            LinkedList<EventBean> oldEvents = null;
            if (this.prototype.isSelectRStream()) {
                oldEvents = new LinkedList<EventBean>();
            }
            LinkedList<MultiKeyUntyped> newEventsSortKey = null;
            LinkedList<MultiKeyUntyped> oldEventsSortKey = null;
            if (this.orderByProcessor != null) {
                newEventsSortKey = new LinkedList<MultiKeyUntyped>();
                if (this.prototype.isSelectRStream()) {
                    oldEventsSortKey = new LinkedList<MultiKeyUntyped>();
                }
            }
            if (this.prototype.isSelectRStream()) {
                this.generateOutputBatchedArr(this.groupRepsView, false, generateSynthetic, oldEvents, oldEventsSortKey);
            }
            for (UniformPair<EventBean[]> pair : viewEventsList) {
                MultiKeyUntyped mk;
                int i$;
                int len$;
                EventBean[] arr$;
                EventBean[] newData = pair.getFirst();
                EventBean[] oldData = pair.getSecond();
                if (newData != null) {
                    arr$ = newData;
                    len$ = arr$.length;
                    for (i$ = 0; i$ < len$; ++i$) {
                        EventBean aNewData;
                        eventsPerStream[0] = aNewData = arr$[i$];
                        mk = this.generateGroupKey(eventsPerStream, true);
                        if (this.groupRepsView.put(mk, new EventBean[]{aNewData}) == null && this.prototype.isSelectRStream()) {
                            this.generateOutputBatched(mk, eventsPerStream, false, generateSynthetic, oldEvents, oldEventsSortKey);
                        }
                        this.aggregationService.applyEnter(eventsPerStream, mk, this.agentInstanceContext);
                    }
                }
                if (oldData == null) continue;
                arr$ = oldData;
                len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    EventBean anOldData;
                    eventsPerStream[0] = anOldData = arr$[i$];
                    mk = this.generateGroupKey(eventsPerStream, true);
                    if (this.groupRepsView.put(mk, new EventBean[]{anOldData}) == null && this.prototype.isSelectRStream()) {
                        this.generateOutputBatched(mk, eventsPerStream, false, generateSynthetic, oldEvents, oldEventsSortKey);
                    }
                    this.aggregationService.applyLeave(eventsPerStream, mk, this.agentInstanceContext);
                }
            }
            this.generateOutputBatchedArr(this.groupRepsView, true, generateSynthetic, newEvents, newEventsSortKey);
            EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
            EventBean[] oldEventsArr = null;
            if (this.prototype.isSelectRStream()) {
                EventBean[] eventBeanArray = oldEventsArr = oldEvents.isEmpty() ? null : oldEvents.toArray(new EventBean[oldEvents.size()]);
            }
            if (this.orderByProcessor != null) {
                MultiKeyUntyped[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new MultiKeyUntyped[newEventsSortKey.size()]);
                newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.agentInstanceContext);
                if (this.prototype.isSelectRStream()) {
                    MultiKeyUntyped[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.toArray(new MultiKeyUntyped[oldEventsSortKey.size()]);
                    oldEventsArr = this.orderByProcessor.sort(oldEventsArr, sortKeysOld, this.agentInstanceContext);
                }
            }
            if (newEventsArr == null && oldEventsArr == null) {
                return null;
            }
            return new UniformPair<EventBean[]>(newEventsArr, oldEventsArr);
        }
        if (outputLimitLimitType == OutputLimitLimitType.FIRST) {
            LinkedList<EventBean> newEvents = new LinkedList<EventBean>();
            LinkedList<EventBean> oldEvents = null;
            if (this.prototype.isSelectRStream()) {
                oldEvents = new LinkedList<EventBean>();
            }
            LinkedList<MultiKeyUntyped> newEventsSortKey = null;
            LinkedList<MultiKeyUntyped> oldEventsSortKey = null;
            if (this.orderByProcessor != null) {
                newEventsSortKey = new LinkedList<MultiKeyUntyped>();
                if (this.prototype.isSelectRStream()) {
                    oldEventsSortKey = new LinkedList<MultiKeyUntyped>();
                }
            }
            if (this.prototype.getOptionalHavingNode() == null) {
                this.groupRepsView.clear();
                for (UniformPair<EventBean[]> pair : viewEventsList) {
                    boolean pass;
                    OutputConditionPolled outputStateGroup;
                    MultiKeyUntyped mk;
                    EventBean[] eventsPerStream;
                    EventBean[] newData = pair.getFirst();
                    EventBean[] oldData = pair.getSecond();
                    if (newData != null) {
                        for (EventBean aNewData : newData) {
                            eventsPerStream = new EventBean[]{aNewData};
                            mk = this.generateGroupKey(eventsPerStream, true);
                            outputStateGroup = this.outputState.get(mk);
                            if (outputStateGroup == null) {
                                try {
                                    outputStateGroup = OutputConditionPolledFactory.createCondition(this.prototype.getOutputLimitSpec(), this.agentInstanceContext);
                                }
                                catch (ExprValidationException e) {
                                    log.error((Object)("Error starting output limit for group for statement '" + this.agentInstanceContext.getStatementContext().getStatementName() + "'"));
                                }
                                this.outputState.put(mk, outputStateGroup);
                            }
                            if ((pass = outputStateGroup.updateOutputCondition(1, 0)) && this.groupRepsView.put(mk, eventsPerStream) == null && this.prototype.isSelectRStream()) {
                                this.generateOutputBatched(mk, eventsPerStream, false, generateSynthetic, oldEvents, oldEventsSortKey);
                            }
                            this.aggregationService.applyEnter(eventsPerStream, mk, this.agentInstanceContext);
                        }
                    }
                    if (oldData == null) continue;
                    for (EventBean anOldData : oldData) {
                        eventsPerStream = new EventBean[]{anOldData};
                        mk = this.generateGroupKey(eventsPerStream, true);
                        outputStateGroup = this.outputState.get(mk);
                        if (outputStateGroup == null) {
                            try {
                                outputStateGroup = OutputConditionPolledFactory.createCondition(this.prototype.getOutputLimitSpec(), this.agentInstanceContext);
                            }
                            catch (ExprValidationException e) {
                                log.error((Object)("Error starting output limit for group for statement '" + this.agentInstanceContext.getStatementContext().getStatementName() + "'"));
                            }
                            this.outputState.put(mk, outputStateGroup);
                        }
                        if ((pass = outputStateGroup.updateOutputCondition(0, 1)) && this.groupRepsView.put(mk, eventsPerStream) == null && this.prototype.isSelectRStream()) {
                            this.generateOutputBatched(mk, eventsPerStream, false, generateSynthetic, oldEvents, oldEventsSortKey);
                        }
                        this.aggregationService.applyLeave(eventsPerStream, mk, this.agentInstanceContext);
                    }
                }
            } else {
                EventBean[] eventsPerStreamOneStream = new EventBean[1];
                this.groupRepsView.clear();
                for (UniformPair<EventBean[]> pair : viewEventsList) {
                    EventBean[] eventsPerStream;
                    boolean pass;
                    OutputConditionPolled outputStateGroup;
                    Boolean result;
                    MultiKeyUntyped mk;
                    int i;
                    EventBean[] newData = pair.getFirst();
                    EventBean[] oldData = pair.getSecond();
                    MultiKeyUntyped[] newDataMultiKey = this.generateGroupKeys(newData, true);
                    MultiKeyUntyped[] oldDataMultiKey = this.generateGroupKeys(oldData, false);
                    if (newData != null) {
                        for (i = 0; i < newData.length; ++i) {
                            eventsPerStreamOneStream[0] = newData[i];
                            this.aggregationService.applyEnter(eventsPerStreamOneStream, newDataMultiKey[i], this.agentInstanceContext);
                        }
                    }
                    if (oldData != null) {
                        for (i = 0; i < oldData.length; ++i) {
                            eventsPerStreamOneStream[0] = oldData[i];
                            this.aggregationService.applyLeave(eventsPerStreamOneStream, oldDataMultiKey[i], this.agentInstanceContext);
                        }
                    }
                    if (newData != null) {
                        for (i = 0; i < newData.length; ++i) {
                            mk = newDataMultiKey[i];
                            eventsPerStreamOneStream[0] = newData[i];
                            this.aggregationService.setCurrentAccess(mk, this.agentInstanceContext.getAgentInstanceIds());
                            result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(eventsPerStreamOneStream, true, this.agentInstanceContext);
                            if (result == null || !result.booleanValue()) continue;
                            outputStateGroup = this.outputState.get(mk);
                            if (outputStateGroup == null) {
                                try {
                                    outputStateGroup = OutputConditionPolledFactory.createCondition(this.prototype.getOutputLimitSpec(), this.agentInstanceContext);
                                }
                                catch (ExprValidationException e) {
                                    log.error((Object)("Error starting output limit for group for statement '" + this.agentInstanceContext.getStatementContext().getStatementName() + "'"));
                                }
                                this.outputState.put(mk, outputStateGroup);
                            }
                            if (!(pass = outputStateGroup.updateOutputCondition(0, 1)) || this.groupRepsView.put(mk, eventsPerStream = new EventBean[]{newData[i]}) != null || !this.prototype.isSelectRStream()) continue;
                            this.generateOutputBatched(mk, eventsPerStream, true, generateSynthetic, oldEvents, oldEventsSortKey);
                        }
                    }
                    if (oldData == null) continue;
                    for (i = 0; i < oldData.length; ++i) {
                        mk = oldDataMultiKey[i];
                        eventsPerStreamOneStream[0] = oldData[i];
                        this.aggregationService.setCurrentAccess(mk, this.agentInstanceContext.getAgentInstanceIds());
                        result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(eventsPerStreamOneStream, false, this.agentInstanceContext);
                        if (result == null || !result.booleanValue()) continue;
                        outputStateGroup = this.outputState.get(mk);
                        if (outputStateGroup == null) {
                            try {
                                outputStateGroup = OutputConditionPolledFactory.createCondition(this.prototype.getOutputLimitSpec(), this.agentInstanceContext);
                            }
                            catch (ExprValidationException e) {
                                log.error((Object)("Error starting output limit for group for statement '" + this.agentInstanceContext.getStatementContext().getStatementName() + "'"));
                            }
                            this.outputState.put(mk, outputStateGroup);
                        }
                        if (!(pass = outputStateGroup.updateOutputCondition(0, 1)) || this.groupRepsView.put(mk, eventsPerStream = new EventBean[]{oldData[i]}) != null || !this.prototype.isSelectRStream()) continue;
                        this.generateOutputBatched(mk, eventsPerStream, false, generateSynthetic, oldEvents, oldEventsSortKey);
                    }
                }
            }
            this.generateOutputBatchedArr(this.groupRepsView, true, generateSynthetic, newEvents, newEventsSortKey);
            EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
            EventBean[] oldEventsArr = null;
            if (this.prototype.isSelectRStream()) {
                EventBean[] eventBeanArray = oldEventsArr = oldEvents.isEmpty() ? null : oldEvents.toArray(new EventBean[oldEvents.size()]);
            }
            if (this.orderByProcessor != null) {
                MultiKeyUntyped[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new MultiKeyUntyped[newEventsSortKey.size()]);
                newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.agentInstanceContext);
                if (this.prototype.isSelectRStream()) {
                    MultiKeyUntyped[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.toArray(new MultiKeyUntyped[oldEventsSortKey.size()]);
                    oldEventsArr = this.orderByProcessor.sort(oldEventsArr, sortKeysOld, this.agentInstanceContext);
                }
            }
            if (newEventsArr == null && oldEventsArr == null) {
                return null;
            }
            return new UniformPair<EventBean[]>(newEventsArr, oldEventsArr);
        }
        LinkedList<EventBean> newEvents = new LinkedList<EventBean>();
        LinkedList<EventBean> oldEvents = null;
        if (this.prototype.isSelectRStream()) {
            oldEvents = new LinkedList<EventBean>();
        }
        LinkedList<MultiKeyUntyped> newEventsSortKey = null;
        LinkedList<MultiKeyUntyped> oldEventsSortKey = null;
        if (this.orderByProcessor != null) {
            newEventsSortKey = new LinkedList<MultiKeyUntyped>();
            if (this.prototype.isSelectRStream()) {
                oldEventsSortKey = new LinkedList<MultiKeyUntyped>();
            }
        }
        this.groupRepsView.clear();
        for (UniformPair<EventBean[]> pair : viewEventsList) {
            MultiKeyUntyped mk;
            EventBean[] eventsPerStream;
            EventBean[] newData = pair.getFirst();
            EventBean[] oldData = pair.getSecond();
            if (newData != null) {
                for (EventBean aNewData : newData) {
                    eventsPerStream = new EventBean[]{aNewData};
                    mk = this.generateGroupKey(eventsPerStream, true);
                    if (this.groupRepsView.put(mk, eventsPerStream) == null && this.prototype.isSelectRStream()) {
                        this.generateOutputBatched(mk, eventsPerStream, false, generateSynthetic, oldEvents, oldEventsSortKey);
                    }
                    this.aggregationService.applyEnter(eventsPerStream, mk, this.agentInstanceContext);
                }
            }
            if (oldData == null) continue;
            for (EventBean anOldData : oldData) {
                eventsPerStream = new EventBean[]{anOldData};
                mk = this.generateGroupKey(eventsPerStream, true);
                if (this.groupRepsView.put(mk, eventsPerStream) == null && this.prototype.isSelectRStream()) {
                    this.generateOutputBatched(mk, eventsPerStream, false, generateSynthetic, oldEvents, oldEventsSortKey);
                }
                this.aggregationService.applyLeave(eventsPerStream, mk, this.agentInstanceContext);
            }
        }
        this.generateOutputBatchedArr(this.groupRepsView, true, generateSynthetic, newEvents, newEventsSortKey);
        EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
        EventBean[] oldEventsArr = null;
        if (this.prototype.isSelectRStream()) {
            EventBean[] eventBeanArray = oldEventsArr = oldEvents.isEmpty() ? null : oldEvents.toArray(new EventBean[oldEvents.size()]);
        }
        if (this.orderByProcessor != null) {
            MultiKeyUntyped[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new MultiKeyUntyped[newEventsSortKey.size()]);
            newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.agentInstanceContext);
            if (this.prototype.isSelectRStream()) {
                MultiKeyUntyped[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.toArray(new MultiKeyUntyped[oldEventsSortKey.size()]);
                oldEventsArr = this.orderByProcessor.sort(oldEventsArr, sortKeysOld, this.agentInstanceContext);
            }
        }
        if (newEventsArr == null && oldEventsArr == null) {
            return null;
        }
        return new UniformPair<EventBean[]>(newEventsArr, oldEventsArr);
    }

    private MultiKeyUntyped[] generateGroupKeys(Set<MultiKey<EventBean>> resultSet, boolean isNewData) {
        if (resultSet.isEmpty()) {
            return null;
        }
        MultiKeyUntyped[] keys = new MultiKeyUntyped[resultSet.size()];
        int count = 0;
        for (MultiKey<EventBean> eventsPerStream : resultSet) {
            keys[count] = this.generateGroupKey(eventsPerStream.getArray(), isNewData);
            ++count;
        }
        return keys;
    }

    @Override
    public boolean hasAggregation() {
        return true;
    }
}

