/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ArrayEventIterator;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.collection.TransformEventIterator;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.epl.core.OrderByProcessor;
import com.espertech.esper.epl.core.ResultSetProcessorBaseSimple;
import com.espertech.esper.epl.core.ResultSetProcessorSimpleFactory;
import com.espertech.esper.epl.core.ResultSetProcessorSimpleTransform;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.util.CollectionUtil;
import com.espertech.esper.view.Viewable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResultSetProcessorSimple
extends ResultSetProcessorBaseSimple {
    private static final Log log = LogFactory.getLog(ResultSetProcessorSimple.class);
    private final ResultSetProcessorSimpleFactory prototype;
    private final SelectExprProcessor selectExprProcessor;
    private final OrderByProcessor orderByProcessor;
    private final ExprEvaluatorContext exprEvaluatorContext;

    public ResultSetProcessorSimple(ResultSetProcessorSimpleFactory prototype, SelectExprProcessor selectExprProcessor, OrderByProcessor orderByProcessor, ExprEvaluatorContext exprEvaluatorContext) {
        this.prototype = prototype;
        this.selectExprProcessor = selectExprProcessor;
        this.orderByProcessor = orderByProcessor;
        this.exprEvaluatorContext = exprEvaluatorContext;
    }

    @Override
    public EventType getResultEventType() {
        return this.prototype.getResultEventType();
    }

    @Override
    public UniformPair<EventBean[]> processJoinResult(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents, boolean isSynthesize) {
        EventBean[] selectNewEvents;
        EventBean[] selectOldEvents = null;
        if (this.prototype.getOptionalHavingExpr() == null) {
            if (this.prototype.isSelectRStream()) {
                selectOldEvents = ResultSetProcessorSimple.getSelectEventsNoHaving(this.selectExprProcessor, this.orderByProcessor, oldEvents, false, isSynthesize, this.exprEvaluatorContext);
            }
            selectNewEvents = ResultSetProcessorSimple.getSelectEventsNoHaving(this.selectExprProcessor, this.orderByProcessor, newEvents, true, isSynthesize, this.exprEvaluatorContext);
        } else {
            if (this.prototype.isSelectRStream()) {
                selectOldEvents = ResultSetProcessorSimple.getSelectEventsHaving(this.selectExprProcessor, this.orderByProcessor, oldEvents, this.prototype.getOptionalHavingExpr(), false, isSynthesize, this.exprEvaluatorContext);
            }
            selectNewEvents = ResultSetProcessorSimple.getSelectEventsHaving(this.selectExprProcessor, this.orderByProcessor, newEvents, this.prototype.getOptionalHavingExpr(), true, isSynthesize, this.exprEvaluatorContext);
        }
        return new UniformPair<EventBean[]>(selectNewEvents, selectOldEvents);
    }

    @Override
    public UniformPair<EventBean[]> processViewResult(EventBean[] newData, EventBean[] oldData, boolean isSynthesize) {
        EventBean[] selectNewEvents;
        EventBean[] selectOldEvents = null;
        if (this.prototype.getOptionalHavingExpr() == null) {
            if (this.prototype.isSelectRStream()) {
                selectOldEvents = ResultSetProcessorSimple.getSelectEventsNoHaving(this.selectExprProcessor, this.orderByProcessor, oldData, false, isSynthesize, this.exprEvaluatorContext);
            }
            selectNewEvents = ResultSetProcessorSimple.getSelectEventsNoHaving(this.selectExprProcessor, this.orderByProcessor, newData, true, isSynthesize, this.exprEvaluatorContext);
        } else {
            if (this.prototype.isSelectRStream()) {
                selectOldEvents = ResultSetProcessorSimple.getSelectEventsHaving(this.selectExprProcessor, this.orderByProcessor, oldData, this.prototype.getOptionalHavingExpr(), false, isSynthesize, this.exprEvaluatorContext);
            }
            selectNewEvents = ResultSetProcessorSimple.getSelectEventsHaving(this.selectExprProcessor, this.orderByProcessor, newData, this.prototype.getOptionalHavingExpr(), true, isSynthesize, this.exprEvaluatorContext);
        }
        return new UniformPair<EventBean[]>(selectNewEvents, selectOldEvents);
    }

    public UniformPair<EventBean[]> processViewResultIterator(EventBean[] newData) {
        Object selectOldEvents = null;
        EventBean[] selectNewEvents = this.prototype.getOptionalHavingExpr() == null ? ResultSetProcessorSimple.getSelectEventsNoHaving(this.selectExprProcessor, null, newData, true, true, this.exprEvaluatorContext) : ResultSetProcessorSimple.getSelectEventsHaving(this.selectExprProcessor, null, newData, this.prototype.getOptionalHavingExpr(), true, true, this.exprEvaluatorContext);
        return new UniformPair<Object>(selectNewEvents, selectOldEvents);
    }

    protected static EventBean[] getSelectEventsNoHaving(SelectExprProcessor exprProcessor, OrderByProcessor orderByProcessor, EventBean[] events, boolean isNewData, boolean isSynthesize, ExprEvaluatorContext exprEvaluatorContext) {
        if (events == null) {
            return null;
        }
        EventBean[] result = new EventBean[events.length];
        EventBean[][] eventGenerators = null;
        if (orderByProcessor != null) {
            eventGenerators = new EventBean[events.length][];
        }
        EventBean[] eventsPerStream = new EventBean[1];
        for (int i = 0; i < events.length; ++i) {
            eventsPerStream[0] = events[i];
            result[i] = exprProcessor == null ? events[i] : exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext);
            if (orderByProcessor == null) continue;
            eventGenerators[i] = new EventBean[]{events[i]};
        }
        if (orderByProcessor != null) {
            return orderByProcessor.sort(result, eventGenerators, isNewData, exprEvaluatorContext);
        }
        return result;
    }

    protected static EventBean[] getSelectEventsNoHaving(SelectExprProcessor exprProcessor, OrderByProcessor orderByProcessor, Set<MultiKey<EventBean>> events, boolean isNewData, boolean isSynthesize, ExprEvaluatorContext exprEvaluatorContext) {
        if (events == null || events.isEmpty()) {
            return null;
        }
        int length = events.size();
        EventBean[] result = new EventBean[length];
        EventBean[][] eventGenerators = null;
        if (orderByProcessor != null) {
            eventGenerators = new EventBean[length][];
        }
        int count = 0;
        for (MultiKey<EventBean> key : events) {
            EventBean[] eventsPerStream = key.getArray();
            result[count] = exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext);
            if (orderByProcessor != null) {
                eventGenerators[count] = eventsPerStream;
            }
            ++count;
        }
        if (orderByProcessor != null) {
            return orderByProcessor.sort(result, eventGenerators, isNewData, exprEvaluatorContext);
        }
        return result;
    }

    protected static EventBean[] getSelectEventsHaving(SelectExprProcessor exprProcessor, OrderByProcessor orderByProcessor, EventBean[] events, ExprEvaluator optionalHavingNode, boolean isNewData, boolean isSynthesize, ExprEvaluatorContext exprEvaluatorContext) {
        if (events == null) {
            return null;
        }
        LinkedList<EventBean> result = new LinkedList<EventBean>();
        ArrayList<EventBean[]> eventGenerators = null;
        if (orderByProcessor != null) {
            eventGenerators = new ArrayList<EventBean[]>();
        }
        EventBean[] eventsPerStream = new EventBean[1];
        EventBean[] arr$ = events;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            EventBean event;
            eventsPerStream[0] = event = arr$[i$];
            Boolean passesHaving = (Boolean)optionalHavingNode.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (passesHaving == null || !passesHaving.booleanValue()) continue;
            result.add(exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext));
            if (orderByProcessor == null) continue;
            eventGenerators.add(new EventBean[]{event});
        }
        if (!result.isEmpty()) {
            if (orderByProcessor != null) {
                return orderByProcessor.sort(result.toArray(new EventBean[result.size()]), (EventBean[][])eventGenerators.toArray((T[])new EventBean[eventGenerators.size()][]), isNewData, exprEvaluatorContext);
            }
            return result.toArray(new EventBean[result.size()]);
        }
        return null;
    }

    protected static EventBean[] getSelectEventsHaving(SelectExprProcessor exprProcessor, OrderByProcessor orderByProcessor, Set<MultiKey<EventBean>> events, ExprEvaluator optionalHavingNode, boolean isNewData, boolean isSynthesize, ExprEvaluatorContext exprEvaluatorContext) {
        if (events == null || events.isEmpty()) {
            return null;
        }
        LinkedList<EventBean> result = new LinkedList<EventBean>();
        ArrayList<EventBean[]> eventGenerators = null;
        if (orderByProcessor != null) {
            eventGenerators = new ArrayList<EventBean[]>();
        }
        for (MultiKey<EventBean> key : events) {
            EventBean[] eventsPerStream = key.getArray();
            Boolean passesHaving = (Boolean)optionalHavingNode.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (passesHaving == null || !passesHaving.booleanValue()) continue;
            EventBean resultEvent = exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext);
            result.add(resultEvent);
            if (orderByProcessor == null) continue;
            eventGenerators.add(eventsPerStream);
        }
        if (!result.isEmpty()) {
            if (orderByProcessor != null) {
                return orderByProcessor.sort(result.toArray(new EventBean[result.size()]), (EventBean[][])eventGenerators.toArray((T[])new EventBean[eventGenerators.size()][]), isNewData, exprEvaluatorContext);
            }
            return result.toArray(new EventBean[result.size()]);
        }
        return null;
    }

    @Override
    public Iterator<EventBean> getIterator(Viewable parent) {
        if (this.orderByProcessor != null) {
            EventBean[] eventsPerStream = new EventBean[1];
            ArrayList<EventBean> events = new ArrayList<EventBean>();
            ArrayList<MultiKeyUntyped> orderKeys = new ArrayList<MultiKeyUntyped>();
            Iterator<EventBean> i$ = parent.iterator();
            while (i$.hasNext()) {
                EventBean aParent;
                eventsPerStream[0] = aParent = i$.next();
                MultiKeyUntyped orderKey = this.orderByProcessor.getSortKey(eventsPerStream, true, this.exprEvaluatorContext);
                UniformPair<EventBean[]> pair = this.processViewResultIterator(eventsPerStream);
                EventBean[] result = pair.getFirst();
                if (result.length != 0) {
                    events.add(result[0]);
                }
                orderKeys.add(orderKey);
            }
            EventBean[] outgoingEvents = events.toArray(new EventBean[events.size()]);
            MultiKeyUntyped[] orderKeysArr = orderKeys.toArray(new MultiKeyUntyped[orderKeys.size()]);
            EventBean[] orderedEvents = this.orderByProcessor.sort(outgoingEvents, orderKeysArr, this.exprEvaluatorContext);
            return new ArrayEventIterator(orderedEvents);
        }
        return new TransformEventIterator(parent.iterator(), new ResultSetProcessorSimpleTransform(this));
    }

    @Override
    public Iterator<EventBean> getIterator(Set<MultiKey<EventBean>> joinSet) {
        UniformPair<EventBean[]> result = this.processJoinResult(joinSet, CollectionUtil.EMPTY_ROW_SET, true);
        return new ArrayEventIterator(result.getFirst());
    }

    @Override
    public void clear() {
    }

    protected static EventBean[] getSelectEventsNoHaving(SelectExprProcessor exprProcessor, EventBean[] events, boolean isNewData, boolean isSynthesize, ExprEvaluatorContext exprEvaluatorContext) {
        if (events == null) {
            return null;
        }
        EventBean[] result = new EventBean[events.length];
        EventBean[] eventsPerStream = new EventBean[1];
        for (int i = 0; i < events.length; ++i) {
            eventsPerStream[0] = events[i];
            result[i] = exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext);
        }
        return result;
    }

    protected static EventBean[] getSelectEventsNoHaving(SelectExprProcessor exprProcessor, Set<MultiKey<EventBean>> events, boolean isNewData, boolean isSynthesize, ExprEvaluatorContext exprEvaluatorContext) {
        if (events == null || events.isEmpty()) {
            return null;
        }
        int length = events.size();
        EventBean[] result = new EventBean[length];
        int count = 0;
        for (MultiKey<EventBean> key : events) {
            EventBean[] eventsPerStream = key.getArray();
            result[count] = exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext);
            ++count;
        }
        return result;
    }

    protected static EventBean[] getSelectEventsHaving(SelectExprProcessor exprProcessor, EventBean[] events, ExprEvaluator optionalHavingNode, boolean isNewData, boolean isSynthesize, ExprEvaluatorContext exprEvaluatorContext) {
        if (events == null) {
            return null;
        }
        LinkedList<EventBean> result = new LinkedList<EventBean>();
        EventBean[] eventsPerStream = new EventBean[1];
        EventBean[] arr$ = events;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            EventBean event;
            eventsPerStream[0] = event = arr$[i$];
            Boolean passesHaving = (Boolean)optionalHavingNode.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (passesHaving == null || !passesHaving.booleanValue()) continue;
            result.add(exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext));
        }
        if (!result.isEmpty()) {
            return result.toArray(new EventBean[result.size()]);
        }
        return null;
    }

    protected static EventBean[] getSelectEventsHaving(SelectExprProcessor exprProcessor, Set<MultiKey<EventBean>> events, ExprEvaluator optionalHavingNode, boolean isNewData, boolean isSynthesize, ExprEvaluatorContext exprEvaluatorContext) {
        LinkedList<EventBean> result = new LinkedList<EventBean>();
        for (MultiKey<EventBean> key : events) {
            EventBean[] eventsPerStream = key.getArray();
            Boolean passesHaving = (Boolean)optionalHavingNode.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (passesHaving == null || !passesHaving.booleanValue()) continue;
            EventBean resultEvent = exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext);
            result.add(resultEvent);
        }
        if (!result.isEmpty()) {
            return result.toArray(new EventBean[result.size()]);
        }
        return null;
    }

    protected static void getSelectEventsNoHaving(SelectExprProcessor exprProcessor, OrderByProcessor orderByProcessor, EventBean[] events, boolean isNewData, boolean isSynthesize, List<EventBean> result, List<MultiKeyUntyped> optSortKeys, ExprEvaluatorContext exprEvaluatorContext) {
        if (events == null) {
            return;
        }
        EventBean[] eventsPerStream = new EventBean[1];
        EventBean[] arr$ = events;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            EventBean event;
            eventsPerStream[0] = event = arr$[i$];
            result.add(exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext));
            if (orderByProcessor == null) continue;
            optSortKeys.add(orderByProcessor.getSortKey(eventsPerStream, isNewData, exprEvaluatorContext));
        }
    }

    protected static void getSelectEventsNoHaving(SelectExprProcessor exprProcessor, OrderByProcessor orderByProcessor, Set<MultiKey<EventBean>> events, boolean isNewData, boolean isSynthesize, List<EventBean> result, List<MultiKeyUntyped> optSortKeys, ExprEvaluatorContext exprEvaluatorContext) {
        int length;
        int n = length = events != null ? events.size() : 0;
        if (length == 0) {
            return;
        }
        for (MultiKey<EventBean> key : events) {
            EventBean[] eventsPerStream = key.getArray();
            result.add(exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext));
            if (orderByProcessor == null) continue;
            optSortKeys.add(orderByProcessor.getSortKey(eventsPerStream, isNewData, exprEvaluatorContext));
        }
    }

    protected static void getSelectEventsHaving(SelectExprProcessor exprProcessor, OrderByProcessor orderByProcessor, EventBean[] events, ExprEvaluator optionalHavingNode, boolean isNewData, boolean isSynthesize, List<EventBean> result, List<MultiKeyUntyped> optSortKeys, ExprEvaluatorContext exprEvaluatorContext) {
        if (events == null) {
            return;
        }
        EventBean[] eventsPerStream = new EventBean[1];
        EventBean[] arr$ = events;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            EventBean event;
            eventsPerStream[0] = event = arr$[i$];
            Boolean passesHaving = (Boolean)optionalHavingNode.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (passesHaving == null || !passesHaving.booleanValue()) continue;
            result.add(exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext));
            if (orderByProcessor == null) continue;
            optSortKeys.add(orderByProcessor.getSortKey(eventsPerStream, isNewData, exprEvaluatorContext));
        }
    }

    protected static void getSelectEventsHaving(SelectExprProcessor exprProcessor, OrderByProcessor orderByProcessor, Set<MultiKey<EventBean>> events, ExprEvaluator optionalHavingNode, boolean isNewData, boolean isSynthesize, List<EventBean> result, List<MultiKeyUntyped> optSortKeys, ExprEvaluatorContext exprEvaluatorContext) {
        if (events == null) {
            return;
        }
        for (MultiKey<EventBean> key : events) {
            EventBean[] eventsPerStream = key.getArray();
            Boolean passesHaving = (Boolean)optionalHavingNode.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (passesHaving == null || !passesHaving.booleanValue()) continue;
            EventBean resultEvent = exprProcessor.process(eventsPerStream, isNewData, isSynthesize, exprEvaluatorContext);
            result.add(resultEvent);
            if (orderByProcessor == null) continue;
            optSortKeys.add(orderByProcessor.getSortKey(eventsPerStream, isNewData, exprEvaluatorContext));
        }
    }

    @Override
    public boolean hasAggregation() {
        return false;
    }
}

