/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyDescriptor;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.core.EngineImportException;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventBeanManufactureException;
import com.espertech.esper.event.EventBeanManufacturer;
import com.espertech.esper.event.WriteablePropertyDescriptor;
import com.espertech.esper.event.bean.BeanEventType;
import com.espertech.esper.event.map.MapEventType;
import com.espertech.esper.util.TypeWidener;
import com.espertech.esper.util.TypeWidenerFactory;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastConstructor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SelectExprInsertEventBean {
    private static Log log = LogFactory.getLog(SelectExprInsertEventBean.class);
    private EventType eventType;
    private Set<WriteablePropertyDescriptor> writables;
    private EventBeanManufacturer eventManufacturer;
    private WriteablePropertyDescriptor[] writableProperties;
    private ExprEvaluator[] exprEvaluators;
    private TypeWidener[] wideners;

    public static SelectExprInsertEventBean getInsertUnderlying(EventAdapterService eventAdapterService, EventType eventType) {
        Set<WriteablePropertyDescriptor> writableProps = eventAdapterService.getWriteableProperties(eventType);
        if (writableProps == null) {
            return null;
        }
        if (eventType instanceof MapEventType) {
            for (EventPropertyDescriptor prop : eventType.getPropertyDescriptors()) {
                if (!prop.isFragment()) continue;
                return null;
            }
        }
        return new SelectExprInsertEventBean(eventType, writableProps);
    }

    private SelectExprInsertEventBean(EventType eventType, Set<WriteablePropertyDescriptor> writables) {
        this.eventType = eventType;
        this.writables = writables;
    }

    public void initialize(boolean isUsingWildcard, StreamTypeService typeService, ExprEvaluator[] expressionNodes, String[] columnNames, Object[] expressionReturnTypes, MethodResolutionService methodResolutionService, EventAdapterService eventAdapterService) throws ExprValidationException {
        try {
            this.initializeSetterManufactor(isUsingWildcard, typeService, expressionNodes, columnNames, expressionReturnTypes, methodResolutionService, eventAdapterService);
        }
        catch (ExprValidationException ex) {
            if (!(this.eventType instanceof BeanEventType)) {
                throw ex;
            }
            try {
                this.initializeCtorInjection(expressionNodes, typeService, expressionReturnTypes, methodResolutionService, eventAdapterService);
            }
            catch (ExprValidationException ctorEx) {
                if (this.writables.isEmpty()) {
                    throw ctorEx;
                }
                throw ex;
            }
        }
    }

    public void initializeJoinWildcard(String[] streamNames, EventType[] streamTypes, MethodResolutionService methodResolutionService, EventAdapterService eventAdapterService) throws ExprValidationException {
        try {
            this.initializeJoinWildcardInternal(streamNames, streamTypes, methodResolutionService, eventAdapterService);
        }
        catch (ExprValidationException ex) {
            if (!(this.eventType instanceof BeanEventType)) {
                throw ex;
            }
            try {
                ExprEvaluator[] evaluators = new ExprEvaluator[streamTypes.length];
                Object[] resultTypes = new Object[streamTypes.length];
                for (int i = 0; i < streamTypes.length; ++i) {
                    evaluators[i] = new ExprEvaluatorJoinWildcard(i, streamTypes[i].getUnderlyingType());
                    resultTypes[i] = evaluators[i].getType();
                }
                this.initializeCtorInjection(evaluators, null, resultTypes, methodResolutionService, eventAdapterService);
            }
            catch (ExprValidationException ctorEx) {
                if (this.writables.isEmpty()) {
                    throw ctorEx;
                }
                throw ex;
            }
        }
    }

    private void initializeJoinWildcardInternal(String[] streamNames, EventType[] streamTypes, MethodResolutionService methodResolutionService, EventAdapterService eventAdapterService) throws ExprValidationException {
        ArrayList<WriteablePropertyDescriptor> writablePropertiesList = new ArrayList<WriteablePropertyDescriptor>();
        ArrayList<1> evaluatorsList = new ArrayList<1>();
        ArrayList<TypeWidener> widenersList = new ArrayList<TypeWidener>();
        int i = 0;
        while (i < streamNames.length) {
            WriteablePropertyDescriptor selectedWritable = null;
            TypeWidener widener = null;
            for (WriteablePropertyDescriptor desc : this.writables) {
                if (!desc.getPropertyName().equals(streamNames[i])) continue;
                widener = TypeWidenerFactory.getCheckPropertyAssignType(streamNames[i], streamTypes[i].getUnderlyingType(), desc.getType(), desc.getPropertyName());
                selectedWritable = desc;
                break;
            }
            if (selectedWritable == null) {
                String message = "Stream underlying object for stream '" + streamNames[i] + "' could not be assigned to any of the properties of the underlying type (missing column names, event property or setter method?)";
                throw new ExprValidationException(message);
            }
            final int streamNum = i++;
            final Class returnType = streamTypes[streamNum].getUnderlyingType();
            ExprEvaluator evaluator = new ExprEvaluator(){

                @Override
                public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                    EventBean event = eventsPerStream[streamNum];
                    if (event != null) {
                        return event.getUnderlying();
                    }
                    return null;
                }

                @Override
                public Class getType() {
                    return returnType;
                }

                @Override
                public Map<String, Object> getEventType() {
                    return null;
                }
            };
            writablePropertiesList.add(selectedWritable);
            evaluatorsList.add(evaluator);
            widenersList.add(widener);
        }
        this.writableProperties = writablePropertiesList.toArray(new WriteablePropertyDescriptor[writablePropertiesList.size()]);
        this.exprEvaluators = evaluatorsList.toArray(new ExprEvaluator[evaluatorsList.size()]);
        this.wideners = widenersList.toArray(new TypeWidener[widenersList.size()]);
        try {
            this.eventManufacturer = eventAdapterService.getManufacturer(this.eventType, this.writableProperties, methodResolutionService);
        }
        catch (EventBeanManufactureException e) {
            throw new ExprValidationException(e.getMessage(), e);
        }
    }

    private void initializeCtorInjection(ExprEvaluator[] exprEvaluators, StreamTypeService typeService, Object[] expressionReturnTypes, MethodResolutionService methodResolutionService, EventAdapterService eventAdapterService) throws ExprValidationException {
        FastConstructor fctor;
        BeanEventType beanEventType = (BeanEventType)this.eventType;
        Class[] ctorTypes = new Class[expressionReturnTypes.length];
        ExprEvaluator[] evaluators = new ExprEvaluator[exprEvaluators.length];
        for (int i = 0; i < expressionReturnTypes.length; ++i) {
            EventType columnEventType;
            Object columnType = expressionReturnTypes[i];
            if (columnType instanceof Class || columnType == null) {
                ctorTypes[i] = (Class)expressionReturnTypes[i];
                evaluators[i] = exprEvaluators[i];
                continue;
            }
            if (columnType instanceof EventType) {
                columnEventType = (EventType)columnType;
                final Class returnType = columnEventType.getUnderlyingType();
                int streamNum = 0;
                for (int j = 0; j < typeService.getEventTypes().length; ++j) {
                    if (typeService.getEventTypes()[j] != columnEventType) continue;
                    streamNum = j;
                    break;
                }
                final int streamNumEval = streamNum;
                evaluators[i] = new ExprEvaluator(){

                    @Override
                    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                        EventBean event = eventsPerStream[streamNumEval];
                        if (event != null) {
                            return event.getUnderlying();
                        }
                        return null;
                    }

                    @Override
                    public Class getType() {
                        return returnType;
                    }

                    @Override
                    public Map<String, Object> getEventType() {
                        return null;
                    }
                };
                continue;
            }
            if (columnType instanceof EventType[]) {
                columnEventType = ((EventType[])columnType)[0];
                final Class componentReturnType = columnEventType.getUnderlyingType();
                final ExprEvaluator inner = exprEvaluators[i];
                evaluators[i] = new ExprEvaluator(){

                    @Override
                    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                        Object result = inner.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                        if (!(result instanceof EventBean[])) {
                            return null;
                        }
                        EventBean[] events = (EventBean[])result;
                        Object values = Array.newInstance(componentReturnType, events.length);
                        for (int i = 0; i < events.length; ++i) {
                            Array.set(values, i, events[i].getUnderlying());
                        }
                        return values;
                    }

                    @Override
                    public Class getType() {
                        return componentReturnType;
                    }

                    @Override
                    public Map<String, Object> getEventType() {
                        return null;
                    }
                };
                continue;
            }
            String message = "Invalid assignment of expression " + i + " returning type '" + columnType + "', column and parameter types mismatch";
            throw new ExprValidationException(message);
        }
        try {
            Constructor ctor = methodResolutionService.resolveCtor(beanEventType.getUnderlyingType(), ctorTypes);
            FastClass fastClass = FastClass.create((Class)beanEventType.getUnderlyingType());
            fctor = fastClass.getConstructor(ctor);
        }
        catch (EngineImportException ex) {
            throw new ExprValidationException("Failed to find a suitable constructor for bean-event type '" + this.eventType.getName() + "': " + ex.getMessage(), ex);
        }
        this.exprEvaluators = evaluators;
        this.wideners = new TypeWidener[evaluators.length];
        this.eventManufacturer = new EventBeanManufacturerCtor(fctor, beanEventType, eventAdapterService);
    }

    private void initializeSetterManufactor(boolean isUsingWildcard, StreamTypeService typeService, ExprEvaluator[] expressionNodes, String[] columnNames, Object[] expressionReturnTypes, MethodResolutionService methodResolutionService, EventAdapterService eventAdapterService) throws ExprValidationException {
        ArrayList<WriteablePropertyDescriptor> writablePropertiesList = new ArrayList<WriteablePropertyDescriptor>();
        ArrayList<ExprEvaluator> evaluatorsList = new ArrayList<ExprEvaluator>();
        ArrayList<TypeWidener> widenersList = new ArrayList<TypeWidener>();
        for (int i = 0; i < columnNames.length; ++i) {
            WriteablePropertyDescriptor selectedWritable = null;
            TypeWidener widener = null;
            ExprEvaluator evaluator = expressionNodes[i];
            for (WriteablePropertyDescriptor desc : this.writables) {
                EventType columnEventType;
                if (!desc.getPropertyName().equals(columnNames[i])) continue;
                Object columnType = expressionReturnTypes[i];
                if (columnType == null) {
                    TypeWidenerFactory.getCheckPropertyAssignType(columnNames[i], null, desc.getType(), desc.getPropertyName());
                } else if (columnType instanceof EventType) {
                    columnEventType = (EventType)columnType;
                    final Class returnType = columnEventType.getUnderlyingType();
                    widener = TypeWidenerFactory.getCheckPropertyAssignType(columnNames[i], columnEventType.getUnderlyingType(), desc.getType(), desc.getPropertyName());
                    int streamNum = 0;
                    for (int j = 0; j < typeService.getEventTypes().length; ++j) {
                        if (typeService.getEventTypes()[j] != columnEventType) continue;
                        streamNum = j;
                        break;
                    }
                    final int streamNumEval = streamNum;
                    evaluator = new ExprEvaluator(){

                        @Override
                        public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                            EventBean event = eventsPerStream[streamNumEval];
                            if (event != null) {
                                return event.getUnderlying();
                            }
                            return null;
                        }

                        @Override
                        public Class getType() {
                            return returnType;
                        }

                        @Override
                        public Map<String, Object> getEventType() {
                            return null;
                        }
                    };
                } else if (columnType instanceof EventType[]) {
                    columnEventType = ((EventType[])columnType)[0];
                    final Class componentReturnType = columnEventType.getUnderlyingType();
                    Class<?> arrayReturnType = Array.newInstance(componentReturnType, 0).getClass();
                    widener = TypeWidenerFactory.getCheckPropertyAssignType(columnNames[i], arrayReturnType, desc.getType(), desc.getPropertyName());
                    final ExprEvaluator inner = evaluator;
                    evaluator = new ExprEvaluator(){

                        @Override
                        public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                            Object result = inner.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                            if (!(result instanceof EventBean[])) {
                                return null;
                            }
                            EventBean[] events = (EventBean[])result;
                            Object values = Array.newInstance(componentReturnType, events.length);
                            for (int i = 0; i < events.length; ++i) {
                                Array.set(values, i, events[i].getUnderlying());
                            }
                            return values;
                        }

                        @Override
                        public Class getType() {
                            return componentReturnType;
                        }

                        @Override
                        public Map<String, Object> getEventType() {
                            return null;
                        }
                    };
                } else {
                    if (!(columnType instanceof Class)) {
                        String message = "Invalid assignment of column '" + columnNames[i] + "' of type '" + columnType + "' to event property '" + desc.getPropertyName() + "' typed as '" + desc.getType().getName() + "', column and parameter types mismatch";
                        throw new ExprValidationException(message);
                    }
                    widener = TypeWidenerFactory.getCheckPropertyAssignType(columnNames[i], (Class)columnType, desc.getType(), desc.getPropertyName());
                }
                selectedWritable = desc;
                break;
            }
            if (selectedWritable == null) {
                String message = "Column '" + columnNames[i] + "' could not be assigned to any of the properties of the underlying type (missing column names, event property, setter method or constructor?)";
                throw new ExprValidationException(message);
            }
            writablePropertiesList.add(selectedWritable);
            evaluatorsList.add(evaluator);
            widenersList.add(widener);
        }
        if (isUsingWildcard) {
            EventType sourceType = typeService.getEventTypes()[0];
            for (EventPropertyDescriptor eventPropDescriptor : sourceType.getPropertyDescriptors()) {
                if (eventPropDescriptor.isRequiresIndex() || eventPropDescriptor.isRequiresMapkey()) continue;
                WriteablePropertyDescriptor selectedWritable = null;
                TypeWidener widener = null;
                ExprEvaluator evaluator = null;
                for (WriteablePropertyDescriptor writableDesc : this.writables) {
                    if (!writableDesc.getPropertyName().equals(eventPropDescriptor.getPropertyName())) continue;
                    widener = TypeWidenerFactory.getCheckPropertyAssignType(eventPropDescriptor.getPropertyName(), eventPropDescriptor.getPropertyType(), writableDesc.getType(), writableDesc.getPropertyName());
                    selectedWritable = writableDesc;
                    final String propertyName = eventPropDescriptor.getPropertyName();
                    final Class propertyType = eventPropDescriptor.getPropertyType();
                    evaluator = new ExprEvaluator(){

                        @Override
                        public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                            EventBean event = eventsPerStream[0];
                            if (event != null) {
                                return event.get(propertyName);
                            }
                            return null;
                        }

                        @Override
                        public Class getType() {
                            return propertyType;
                        }

                        @Override
                        public Map<String, Object> getEventType() {
                            return null;
                        }
                    };
                    break;
                }
                if (selectedWritable == null) {
                    String message = "Event property '" + eventPropDescriptor.getPropertyName() + "' could not be assigned to any of the properties of the underlying type (missing column names, event property, setter method or constructor?)";
                    throw new ExprValidationException(message);
                }
                writablePropertiesList.add(selectedWritable);
                evaluatorsList.add(evaluator);
                widenersList.add(widener);
            }
        }
        this.writableProperties = writablePropertiesList.toArray(new WriteablePropertyDescriptor[writablePropertiesList.size()]);
        this.exprEvaluators = evaluatorsList.toArray(new ExprEvaluator[evaluatorsList.size()]);
        this.wideners = widenersList.toArray(new TypeWidener[widenersList.size()]);
        try {
            this.eventManufacturer = eventAdapterService.getManufacturer(this.eventType, this.writableProperties, methodResolutionService);
        }
        catch (EventBeanManufactureException e) {
            throw new ExprValidationException(e.getMessage(), e);
        }
    }

    public EventBean manufacture(EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        Object[] values = new Object[this.exprEvaluators.length];
        for (int i = 0; i < this.exprEvaluators.length; ++i) {
            Object evalResult = this.exprEvaluators[i].evaluate(eventsPerStream, newData, exprEvaluatorContext);
            if (evalResult != null && this.wideners[i] != null) {
                evalResult = this.wideners[i].widen(evalResult);
            }
            values[i] = evalResult;
        }
        return this.eventManufacturer.make(values);
    }

    public static class ExprEvaluatorJoinWildcard
    implements ExprEvaluator {
        private final int streamNum;
        private final Class returnType;

        public ExprEvaluatorJoinWildcard(int streamNum, Class returnType) {
            this.streamNum = streamNum;
            this.returnType = returnType;
        }

        @Override
        public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
            EventBean bean = eventsPerStream[this.streamNum];
            if (bean == null) {
                return null;
            }
            return bean.getUnderlying();
        }

        @Override
        public Class getType() {
            return this.returnType;
        }

        @Override
        public Map<String, Object> getEventType() throws ExprValidationException {
            return null;
        }
    }

    public static class EventBeanManufacturerCtor
    implements EventBeanManufacturer {
        private final FastConstructor fastConstructor;
        private final BeanEventType beanEventType;
        private final EventAdapterService eventAdapterService;

        public EventBeanManufacturerCtor(FastConstructor fastConstructor, BeanEventType beanEventType, EventAdapterService eventAdapterService) {
            this.fastConstructor = fastConstructor;
            this.beanEventType = beanEventType;
            this.eventAdapterService = eventAdapterService;
        }

        @Override
        public EventBean make(Object[] properties) {
            try {
                Object instance = this.fastConstructor.newInstance(properties);
                return this.eventAdapterService.adapterForTypedBean(instance, this.beanEventType);
            }
            catch (InvocationTargetException e) {
                throw new EPException("InvocationTargetException received invoking constructor for type '" + this.beanEventType.getName() + "': " + e.getTargetException().getMessage(), e.getTargetException());
            }
        }
    }
}

