/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.SelectExprEventTypeRegistry;
import com.espertech.esper.epl.core.SelectExprInsertEventBean;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.InsertIntoDesc;
import com.espertech.esper.event.EventAdapterException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.util.CollectionUtil;
import java.util.Collection;
import java.util.HashMap;

public class SelectExprJoinWildcardProcessor
implements SelectExprProcessor {
    private final String[] streamNames;
    private final EventType resultEventType;
    private final EventAdapterService eventAdapterService;
    private boolean isPopulateUnderlying;
    private SelectExprInsertEventBean selectExprInsertEventBean;
    private ExprEvaluatorContext exprEvaluatorContext;

    public SelectExprJoinWildcardProcessor(Collection<Integer> assignedTypeNumberStack, String statementId, String[] streamNames, EventType[] streamTypes, EventAdapterService eventAdapterService, InsertIntoDesc insertIntoDesc, SelectExprEventTypeRegistry selectExprEventTypeRegistry, MethodResolutionService methodResolutionService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        if (streamNames.length < 2 || streamTypes.length < 2 || streamNames.length != streamTypes.length) {
            throw new IllegalArgumentException("Stream names and types parameter length is invalid, expected use of this class is for join statements");
        }
        this.streamNames = streamNames;
        this.eventAdapterService = eventAdapterService;
        this.exprEvaluatorContext = exprEvaluatorContext;
        HashMap<String, Object> eventTypeMap = new HashMap<String, Object>();
        for (int i = 0; i < streamTypes.length; ++i) {
            eventTypeMap.put(streamNames[i], streamTypes[i]);
        }
        if (insertIntoDesc != null) {
            EventType existingType = eventAdapterService.getExistsTypeByName(insertIntoDesc.getEventTypeName());
            if (existingType != null) {
                this.selectExprInsertEventBean = SelectExprInsertEventBean.getInsertUnderlying(eventAdapterService, existingType);
            }
            if (existingType != null && this.selectExprInsertEventBean != null) {
                this.selectExprInsertEventBean.initializeJoinWildcard(streamNames, streamTypes, methodResolutionService, eventAdapterService);
                this.resultEventType = existingType;
                this.isPopulateUnderlying = true;
            } else {
                try {
                    this.resultEventType = eventAdapterService.addNestableMapType(insertIntoDesc.getEventTypeName(), eventTypeMap, null, false, false, false, false, true);
                    selectExprEventTypeRegistry.add(this.resultEventType);
                }
                catch (EventAdapterException ex) {
                    throw new ExprValidationException(ex.getMessage());
                }
            }
        } else {
            this.resultEventType = eventAdapterService.createAnonymousMapType(statementId + "_join_" + CollectionUtil.toString(assignedTypeNumberStack, "_"), eventTypeMap);
        }
    }

    @Override
    public EventBean process(EventBean[] eventsPerStream, boolean isNewData, boolean isSynthesize, ExprEvaluatorContext exprEvaluatorContext) {
        if (this.isPopulateUnderlying) {
            return this.selectExprInsertEventBean.manufacture(eventsPerStream, isNewData, this.exprEvaluatorContext);
        }
        HashMap<String, Object> tuple = new HashMap<String, Object>();
        for (int i = 0; i < this.streamNames.length; ++i) {
            if (this.streamNames[i] == null) {
                throw new IllegalStateException("Event name for stream " + i + " is null");
            }
            if (eventsPerStream[i] != null) {
                tuple.put(this.streamNames[i], eventsPerStream[i]);
                continue;
            }
            tuple.put(this.streamNames[i], null);
        }
        return this.eventAdapterService.adapterForTypedMap(tuple, this.resultEventType);
    }

    @Override
    public EventType getResultEventType() {
        return this.resultEventType;
    }
}

