/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.FragmentEventType;
import com.espertech.esper.epl.core.EngineImportException;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.SelectExprEventTypeRegistry;
import com.espertech.esper.epl.core.SelectExprInsertEventBean;
import com.espertech.esper.epl.core.SelectExprJoinWildcardProcessor;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.eval.EvalInsertBeanRecast;
import com.espertech.esper.epl.core.eval.EvalInsertBeanWrapRecast;
import com.espertech.esper.epl.core.eval.EvalInsertMapTypeCoercion;
import com.espertech.esper.epl.core.eval.EvalInsertNative;
import com.espertech.esper.epl.core.eval.EvalInsertNoWildcard;
import com.espertech.esper.epl.core.eval.EvalInsertNoWildcardRevision;
import com.espertech.esper.epl.core.eval.EvalInsertNoWildcardSingleColCoercionBean;
import com.espertech.esper.epl.core.eval.EvalInsertNoWildcardSingleColCoercionBeanWrap;
import com.espertech.esper.epl.core.eval.EvalInsertNoWildcardSingleColCoercionMap;
import com.espertech.esper.epl.core.eval.EvalInsertNoWildcardSingleColCoercionRevisionBean;
import com.espertech.esper.epl.core.eval.EvalInsertNoWildcardSingleColCoercionRevisionBeanWrap;
import com.espertech.esper.epl.core.eval.EvalInsertNoWildcardSingleColCoercionRevisionMap;
import com.espertech.esper.epl.core.eval.EvalInsertWildcardBean;
import com.espertech.esper.epl.core.eval.EvalInsertWildcardJoin;
import com.espertech.esper.epl.core.eval.EvalInsertWildcardJoinRevision;
import com.espertech.esper.epl.core.eval.EvalInsertWildcardRevision;
import com.espertech.esper.epl.core.eval.EvalInsertWildcardSSWrapper;
import com.espertech.esper.epl.core.eval.EvalInsertWildcardSSWrapperRevision;
import com.espertech.esper.epl.core.eval.EvalInsertWildcardWrapper;
import com.espertech.esper.epl.core.eval.EvalSelectNoWildcard;
import com.espertech.esper.epl.core.eval.EvalSelectNoWildcardEmptyProps;
import com.espertech.esper.epl.core.eval.EvalSelectStreamNoUnderlying;
import com.espertech.esper.epl.core.eval.EvalSelectStreamWUnderlying;
import com.espertech.esper.epl.core.eval.EvalSelectStreamWUnderlyingRecastBean;
import com.espertech.esper.epl.core.eval.EvalSelectStreamWUnderlyingRecastMap;
import com.espertech.esper.epl.core.eval.EvalSelectWildcard;
import com.espertech.esper.epl.core.eval.EvalSelectWildcardJoin;
import com.espertech.esper.epl.core.eval.EvalSelectWildcardSSWrapper;
import com.espertech.esper.epl.core.eval.SelectExprContext;
import com.espertech.esper.epl.core.eval.SelectExprStreamDesc;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprIdentNode;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprStreamUnderlyingNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.InsertIntoDesc;
import com.espertech.esper.epl.spec.SelectClauseExprCompiledSpec;
import com.espertech.esper.epl.spec.SelectClauseStreamCompiledSpec;
import com.espertech.esper.event.EventAdapterException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.NativeEventType;
import com.espertech.esper.event.WrapperEventType;
import com.espertech.esper.event.bean.BeanEventType;
import com.espertech.esper.event.map.MapEventType;
import com.espertech.esper.event.vaevent.ValueAddEventProcessor;
import com.espertech.esper.event.vaevent.ValueAddEventService;
import com.espertech.esper.util.CollectionUtil;
import com.espertech.esper.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SelectExprProcessorHelper {
    private static final Log log = LogFactory.getLog(SelectExprProcessorHelper.class);
    private final Collection<Integer> assignedTypeNumberStack;
    private final List<SelectClauseExprCompiledSpec> selectionList;
    private final List<SelectExprStreamDesc> selectedStreams;
    private final InsertIntoDesc insertIntoDesc;
    private final boolean isUsingWildcard;
    private final StreamTypeService typeService;
    private final EventAdapterService eventAdapterService;
    private final ValueAddEventService valueAddEventService;
    private final SelectExprEventTypeRegistry selectExprEventTypeRegistry;
    private final MethodResolutionService methodResolutionService;
    private final ExprEvaluatorContext exprEvaluatorContext;
    private final String statementId;

    public SelectExprProcessorHelper(Collection<Integer> assignedTypeNumberStack, List<SelectClauseExprCompiledSpec> selectionList, List<SelectExprStreamDesc> selectedStreams, InsertIntoDesc insertIntoDesc, boolean isUsingWildcard, StreamTypeService typeService, EventAdapterService eventAdapterService, ValueAddEventService valueAddEventService, SelectExprEventTypeRegistry selectExprEventTypeRegistry, MethodResolutionService methodResolutionService, ExprEvaluatorContext exprEvaluatorContext, String statementId) throws ExprValidationException {
        this.assignedTypeNumberStack = assignedTypeNumberStack;
        this.selectionList = selectionList;
        this.selectedStreams = selectedStreams;
        this.insertIntoDesc = insertIntoDesc;
        this.eventAdapterService = eventAdapterService;
        this.isUsingWildcard = isUsingWildcard;
        this.typeService = typeService;
        this.exprEvaluatorContext = exprEvaluatorContext;
        this.valueAddEventService = valueAddEventService;
        this.selectExprEventTypeRegistry = selectExprEventTypeRegistry;
        this.methodResolutionService = methodResolutionService;
        this.statementId = statementId;
    }

    /*
     * WARNING - void declaration
     */
    public SelectExprProcessor getEvaluator() throws ExprValidationException {
        void var13_41;
        EventType eventTypeStream;
        int i;
        String[] columnNames;
        ArrayList<SelectClauseStreamCompiledSpec> namedStreams = new ArrayList<SelectClauseStreamCompiledSpec>();
        ArrayList<SelectExprStreamDesc> unnamedStreams = new ArrayList<SelectExprStreamDesc>();
        for (SelectExprStreamDesc spec : this.selectedStreams) {
            if (spec.getStreamSelected() != null && spec.getStreamSelected().getOptionalName() == null) {
                unnamedStreams.add(spec);
                continue;
            }
            if (spec.getExpressionSelectedAsStream() != null) {
                unnamedStreams.add(spec);
                continue;
            }
            namedStreams.add(spec.getStreamSelected());
            if (!spec.getStreamSelected().isProperty()) continue;
            throw new ExprValidationException("The property wildcard syntax must be used without column name");
        }
        if (unnamedStreams.size() > 1) {
            throw new ExprValidationException("A column name must be supplied for all but one stream if multiple streams are selected via the stream.* notation");
        }
        if (this.selectedStreams.isEmpty() && this.selectionList.isEmpty() && !this.isUsingWildcard) {
            throw new IllegalArgumentException("Empty selection list not supported");
        }
        for (SelectClauseExprCompiledSpec entry : this.selectionList) {
            if (entry.getAssignedName() != null) continue;
            throw new IllegalArgumentException("Expected name for each expression has not been supplied");
        }
        if (this.insertIntoDesc != null) {
            SelectExprProcessorHelper.verifyInsertInto(this.insertIntoDesc, this.selectionList);
        }
        SelectExprJoinWildcardProcessor joinWildcardProcessor = null;
        if (this.typeService.getStreamNames().length > 1 && this.isUsingWildcard) {
            joinWildcardProcessor = new SelectExprJoinWildcardProcessor(this.assignedTypeNumberStack, this.statementId, this.typeService.getStreamNames(), this.typeService.getEventTypes(), this.eventAdapterService, null, this.selectExprEventTypeRegistry, this.methodResolutionService, this.exprEvaluatorContext);
        }
        EventType eventType = null;
        boolean singleStreamWrapper = false;
        if (this.isUsingWildcard) {
            if (joinWildcardProcessor != null) {
                eventType = joinWildcardProcessor.getResultEventType();
            } else {
                eventType = this.typeService.getEventTypes()[0];
                if (eventType instanceof WrapperEventType) {
                    singleStreamWrapper = true;
                }
            }
        }
        ExprEvaluator[] exprEvaluators = new ExprEvaluator[this.selectionList.size()];
        ExprNode[] exprNodes = new ExprNode[this.selectionList.size()];
        Object[] expressionReturnTypes = new Object[this.selectionList.size()];
        for (int i2 = 0; i2 < this.selectionList.size(); ++i2) {
            ExprNode expr;
            exprNodes[i2] = expr = this.selectionList.get(i2).getSelectExpression();
            exprEvaluators[i2] = expr.getExprEvaluator();
            Map<String, Object> eventTypeExpr = exprEvaluators[i2].getEventType();
            if (eventTypeExpr == null) {
                expressionReturnTypes[i2] = exprEvaluators[i2].getType();
                continue;
            }
            final ExprEvaluator innerExprEvaluator = expr.getExprEvaluator();
            final EventType eventType2 = this.eventAdapterService.createAnonymousMapType(this.statementId + "_innereval_" + CollectionUtil.toString(this.assignedTypeNumberStack, "_") + "_" + i2, eventTypeExpr);
            ExprEvaluator evaluatorFragment = new ExprEvaluator(){

                @Override
                public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                    Map<String, Object> values = (Map<String, Object>)innerExprEvaluator.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                    if (values == null) {
                        values = Collections.emptyMap();
                    }
                    return SelectExprProcessorHelper.this.eventAdapterService.adapterForTypedMap(values, eventType2);
                }

                @Override
                public Class getType() {
                    return Map.class;
                }

                @Override
                public Map<String, Object> getEventType() {
                    return null;
                }
            };
            expressionReturnTypes[i2] = eventType2;
            exprEvaluators[i2] = evaluatorFragment;
        }
        if (this.insertIntoDesc != null && !this.insertIntoDesc.getColumnNames().isEmpty()) {
            columnNames = this.insertIntoDesc.getColumnNames().toArray(new String[this.insertIntoDesc.getColumnNames().size()]);
        } else if (!this.selectedStreams.isEmpty()) {
            int numStreamColumnsJoin = 0;
            if (this.isUsingWildcard && this.typeService.getEventTypes().length > 1) {
                numStreamColumnsJoin = this.typeService.getEventTypes().length;
            }
            columnNames = new String[this.selectionList.size() + namedStreams.size() + numStreamColumnsJoin];
            int count = 0;
            for (SelectClauseExprCompiledSpec selectClauseExprCompiledSpec : this.selectionList) {
                columnNames[count] = selectClauseExprCompiledSpec.getAssignedName();
                ++count;
            }
            for (SelectClauseStreamCompiledSpec selectClauseStreamCompiledSpec : namedStreams) {
                columnNames[count] = selectClauseStreamCompiledSpec.getOptionalName();
                ++count;
            }
            if (this.isUsingWildcard && this.typeService.getEventTypes().length > 1) {
                String[] arr$ = this.typeService.getStreamNames();
                int n = arr$.length;
                for (int i$ = 0; i$ < n; ++i$) {
                    String streamName;
                    columnNames[count] = streamName = arr$[i$];
                    ++count;
                }
            }
        } else {
            columnNames = new String[this.selectionList.size()];
            for (int i3 = 0; i3 < this.selectionList.size(); ++i3) {
                columnNames[i3] = this.selectionList.get(i3).getAssignedName();
            }
        }
        EventType targetType = null;
        if (this.insertIntoDesc != null) {
            targetType = this.eventAdapterService.getExistsTypeByName(this.insertIntoDesc.getEventTypeName());
        }
        for (i = 0; i < this.selectionList.size(); ++i) {
            ExprEvaluator evaluatorFragment;
            Class returnType;
            EventPropertyGetter getter;
            FragmentEventType fragmentType;
            if (!(exprNodes[i] instanceof ExprIdentNode)) continue;
            ExprIdentNode identNode = (ExprIdentNode)exprNodes[i];
            String string = identNode.getResolvedPropertyName();
            final int streamNum = identNode.getStreamId();
            eventTypeStream = this.typeService.getEventTypes()[streamNum];
            if (eventTypeStream instanceof NativeEventType || (fragmentType = eventTypeStream.getFragmentType(string)) == null || fragmentType.isNative()) continue;
            FragmentEventType targetFragment = null;
            if (targetType != null) {
                targetFragment = targetType.getFragmentType(columnNames[i]);
            }
            if (targetType != null && fragmentType.getFragmentType().getUnderlyingType() == expressionReturnTypes[i] && (targetFragment == null || targetFragment != null && targetFragment.isNative())) {
                getter = eventTypeStream.getGetter(string);
                returnType = eventTypeStream.getPropertyType(string);
                exprEvaluators[i] = evaluatorFragment = new ExprEvaluator(){

                    @Override
                    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                        EventBean streamEvent = eventsPerStream[streamNum];
                        if (streamEvent == null) {
                            return null;
                        }
                        return getter.get(streamEvent);
                    }

                    @Override
                    public Class getType() {
                        return returnType;
                    }

                    @Override
                    public Map<String, Object> getEventType() {
                        return null;
                    }
                };
                continue;
            }
            getter = eventTypeStream.getGetter(string);
            returnType = eventTypeStream.getFragmentType(string).getFragmentType().getUnderlyingType();
            exprEvaluators[i] = evaluatorFragment = new ExprEvaluator(){

                @Override
                public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                    EventBean streamEvent = eventsPerStream[streamNum];
                    if (streamEvent == null) {
                        return null;
                    }
                    return getter.getFragment(streamEvent);
                }

                @Override
                public Class getType() {
                    return returnType;
                }

                @Override
                public Map<String, Object> getEventType() {
                    return null;
                }
            };
            expressionReturnTypes[i] = !fragmentType.isIndexed() ? fragmentType.getFragmentType() : new EventType[]{fragmentType.getFragmentType()};
        }
        for (i = 0; i < this.selectionList.size(); ++i) {
            ExprEvaluator evaluator;
            if (!(exprEvaluators[i] instanceof ExprStreamUnderlyingNode)) continue;
            ExprStreamUnderlyingNode undNode = (ExprStreamUnderlyingNode)((Object)exprEvaluators[i]);
            final int n = undNode.getStreamId();
            final Class returnType = undNode.getExprEvaluator().getType();
            eventTypeStream = this.typeService.getEventTypes()[n];
            exprEvaluators[i] = evaluator = new ExprEvaluator(){

                @Override
                public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                    return eventsPerStream[n];
                }

                @Override
                public Class getType() {
                    return returnType;
                }

                @Override
                public Map<String, Object> getEventType() {
                    return null;
                }
            };
            expressionReturnTypes[i] = eventTypeStream;
        }
        LinkedHashMap<String, Object> selPropertyTypes = new LinkedHashMap<String, Object>();
        int count = 0;
        for (ExprEvaluator expressionNode : exprEvaluators) {
            Object expressionReturnType = expressionReturnTypes[count];
            selPropertyTypes.put(columnNames[count], expressionReturnType);
            ++count;
        }
        if (!this.selectedStreams.isEmpty()) {
            for (SelectClauseStreamCompiledSpec element : namedStreams) {
                EventType eventTypeStream2 = this.typeService.getEventTypes()[element.getStreamNumber()];
                selPropertyTypes.put(columnNames[count], eventTypeStream2);
                ++count;
            }
            if (this.isUsingWildcard && this.typeService.getEventTypes().length > 1) {
                void var13_32;
                boolean bl = false;
                while (var13_32 < this.typeService.getEventTypes().length) {
                    EventType eventTypeStream3 = this.typeService.getEventTypes()[var13_32];
                    selPropertyTypes.put(columnNames[count], eventTypeStream3);
                    ++count;
                    ++var13_32;
                }
            }
        }
        Object var13_33 = null;
        int underlyingStreamNumber = 0;
        boolean underlyingIsFragmentEvent = false;
        EventPropertyGetter underlyingPropertyEventGetter = null;
        ExprEvaluator underlyingExprEvaluator = null;
        if (!(this.selectedStreams.isEmpty() || !this.isUsingWildcard && unnamedStreams.isEmpty())) {
            if (!unnamedStreams.isEmpty()) {
                if (((SelectExprStreamDesc)unnamedStreams.get(0)).getStreamSelected() != null) {
                    SelectClauseStreamCompiledSpec streamSpec = ((SelectExprStreamDesc)unnamedStreams.get(0)).getStreamSelected();
                    underlyingStreamNumber = streamSpec.getStreamNumber();
                    if (streamSpec.isFragmentEvent()) {
                        EventType compositeMap = this.typeService.getEventTypes()[underlyingStreamNumber];
                        FragmentEventType fragment = compositeMap.getFragmentType(streamSpec.getStreamName());
                        EventType eventType3 = fragment.getFragmentType();
                        underlyingIsFragmentEvent = true;
                    } else if (streamSpec.isProperty()) {
                        String propertyName = streamSpec.getStreamName();
                        Class propertyType = streamSpec.getPropertyType();
                        int streamNumber = streamSpec.getStreamNumber();
                        if (JavaClassHelper.isJavaBuiltinDataType(streamSpec.getPropertyType())) {
                            throw new ExprValidationException("The property wildcard syntax cannot be used on built-in types as returned by property '" + propertyName + "'");
                        }
                        EventType eventType4 = this.eventAdapterService.addBeanType(propertyType.getName(), propertyType, false, false, false);
                        this.selectExprEventTypeRegistry.add(eventType4);
                        underlyingPropertyEventGetter = this.typeService.getEventTypes()[streamNumber].getGetter(propertyName);
                        if (underlyingPropertyEventGetter == null) {
                            throw new ExprValidationException("Unexpected error resolving property getter for property " + propertyName);
                        }
                    } else {
                        EventType eventType5 = this.typeService.getEventTypes()[underlyingStreamNumber];
                    }
                } else {
                    ExprNode expression = ((SelectExprStreamDesc)unnamedStreams.get(0)).getExpressionSelectedAsStream().getSelectExpression();
                    Class returnType = expression.getExprEvaluator().getType();
                    EventType eventType6 = this.eventAdapterService.addBeanType(returnType.getName(), returnType, false, false, false);
                    this.selectExprEventTypeRegistry.add(eventType6);
                    underlyingExprEvaluator = expression.getExprEvaluator();
                }
            } else if (this.typeService.getEventTypes().length == 1) {
                EventType eventType7 = this.typeService.getEventTypes()[0];
                if (eventType7 instanceof WrapperEventType) {
                    singleStreamWrapper = true;
                }
            } else {
                Object var13_40 = null;
            }
        }
        SelectExprContext selectExprContext = new SelectExprContext(exprEvaluators, columnNames, this.eventAdapterService);
        if (this.insertIntoDesc == null) {
            EventType resultEventType;
            if (!this.selectedStreams.isEmpty()) {
                if (var13_41 != null) {
                    resultEventType = this.eventAdapterService.createAnonymousWrapperType(this.statementId + "_wrapout_" + CollectionUtil.toString(this.assignedTypeNumberStack, "_"), (EventType)var13_41, selPropertyTypes);
                    return new EvalSelectStreamWUnderlying(selectExprContext, resultEventType, namedStreams, this.isUsingWildcard, unnamedStreams, singleStreamWrapper, underlyingIsFragmentEvent, underlyingStreamNumber, underlyingPropertyEventGetter, underlyingExprEvaluator);
                }
                resultEventType = this.eventAdapterService.createAnonymousMapType(this.statementId + "_mapout_" + CollectionUtil.toString(this.assignedTypeNumberStack, "_"), selPropertyTypes);
                return new EvalSelectStreamNoUnderlying(selectExprContext, resultEventType, namedStreams, this.isUsingWildcard);
            }
            if (this.isUsingWildcard) {
                resultEventType = this.eventAdapterService.createAnonymousWrapperType(this.statementId + "_wrapoutwild_" + CollectionUtil.toString(this.assignedTypeNumberStack, "_"), eventType, selPropertyTypes);
                if (singleStreamWrapper) {
                    return new EvalSelectWildcardSSWrapper(selectExprContext, resultEventType);
                }
                if (joinWildcardProcessor == null) {
                    return new EvalSelectWildcard(selectExprContext, resultEventType);
                }
                return new EvalSelectWildcardJoin(selectExprContext, resultEventType, joinWildcardProcessor);
            }
            resultEventType = this.eventAdapterService.createAnonymousMapType(this.statementId + "_result_" + CollectionUtil.toString(this.assignedTypeNumberStack, "_"), selPropertyTypes);
            if (selectExprContext.getExpressionNodes().length == 0) {
                return new EvalSelectNoWildcardEmptyProps(selectExprContext, resultEventType);
            }
            return new EvalSelectNoWildcard(selectExprContext, resultEventType);
        }
        EventType vaeInnerEventType = null;
        boolean singleColumnCoercion = false;
        boolean isRevisionEvent = false;
        try {
            EventType existingType;
            if (!this.selectedStreams.isEmpty()) {
                if (var13_41 != null) {
                    if (var13_41 instanceof MapEventType && targetType instanceof MapEventType) {
                        return new EvalSelectStreamWUnderlyingRecastMap(selectExprContext, this.selectedStreams.get(0).getStreamSelected().getStreamNumber(), targetType);
                    }
                    if (var13_41 instanceof BeanEventType && targetType instanceof BeanEventType) {
                        SelectClauseExprCompiledSpec expressionAsStream = this.selectedStreams.get(0).getExpressionSelectedAsStream();
                        if (expressionAsStream != null) {
                            return new EvalSelectStreamWUnderlyingRecastBean(selectExprContext, expressionAsStream, (EventType)var13_41, targetType, exprEvaluators.length);
                        }
                        return new EvalInsertBeanRecast(targetType, this.eventAdapterService, this.selectedStreams.get(0).getStreamSelected().getStreamNumber(), this.typeService.getEventTypes());
                    }
                    EventType resultEventType = this.eventAdapterService.addWrapperType(this.insertIntoDesc.getEventTypeName(), (EventType)var13_41, selPropertyTypes, false, true);
                    return new EvalSelectStreamWUnderlying(selectExprContext, resultEventType, namedStreams, this.isUsingWildcard, unnamedStreams, singleStreamWrapper, underlyingIsFragmentEvent, underlyingStreamNumber, underlyingPropertyEventGetter, underlyingExprEvaluator);
                }
                EventType resultEventType = this.eventAdapterService.addNestableMapType(this.insertIntoDesc.getEventTypeName(), selPropertyTypes, null, false, false, false, false, true);
                return new EvalSelectStreamNoUnderlying(selectExprContext, resultEventType, namedStreams, this.isUsingWildcard);
            }
            ValueAddEventProcessor vaeProcessor = this.valueAddEventService.getValueAddProcessor(this.insertIntoDesc.getEventTypeName());
            if (this.isUsingWildcard) {
                EventType resultEventType;
                if (vaeProcessor != null) {
                    resultEventType = vaeProcessor.getValueAddEventType();
                    isRevisionEvent = true;
                    vaeProcessor.validateEventType(eventType);
                } else {
                    EventType existingType2 = this.eventAdapterService.getExistsTypeByName(this.insertIntoDesc.getEventTypeName());
                    SelectExprInsertEventBean selectExprInsertEventBean = null;
                    if (existingType2 != null) {
                        WrapperEventType wrapperType;
                        if (existingType2 instanceof BeanEventType && this.typeService.getEventTypes()[0] instanceof BeanEventType && selPropertyTypes.isEmpty()) {
                            return new EvalInsertBeanRecast(existingType2, this.eventAdapterService, 0, this.typeService.getEventTypes());
                        }
                        if (existingType2 instanceof WrapperEventType && this.typeService.getEventTypes()[0] instanceof BeanEventType && exprEvaluators.length == 0 && (wrapperType = (WrapperEventType)existingType2).getUnderlyingEventType() instanceof BeanEventType) {
                            return new EvalInsertBeanWrapRecast(wrapperType, this.eventAdapterService, 0, this.typeService.getEventTypes());
                        }
                        selectExprInsertEventBean = SelectExprInsertEventBean.getInsertUnderlying(this.eventAdapterService, existingType2);
                    }
                    if (existingType2 != null && selectExprInsertEventBean != null) {
                        selectExprInsertEventBean.initialize(this.isUsingWildcard, this.typeService, exprEvaluators, columnNames, expressionReturnTypes, this.methodResolutionService, this.eventAdapterService);
                        EventType resultEventType2 = existingType2;
                        return new EvalInsertNative(resultEventType2, selectExprInsertEventBean, this.exprEvaluatorContext);
                    }
                    if (existingType2 != null && selPropertyTypes.isEmpty() && existingType2 instanceof MapEventType) {
                        EventType resultEventType3 = existingType2;
                        return new EvalInsertMapTypeCoercion(resultEventType3, this.eventAdapterService);
                    }
                    if (selPropertyTypes.isEmpty() && eventType instanceof BeanEventType) {
                        BeanEventType beanEventType = (BeanEventType)eventType;
                        resultEventType = this.eventAdapterService.addBeanTypeByName(this.insertIntoDesc.getEventTypeName(), beanEventType.getUnderlyingType(), false);
                    } else {
                        resultEventType = this.eventAdapterService.addWrapperType(this.insertIntoDesc.getEventTypeName(), eventType, selPropertyTypes, false, true);
                    }
                }
                if (singleStreamWrapper) {
                    if (!isRevisionEvent) {
                        return new EvalInsertWildcardSSWrapper(selectExprContext, resultEventType);
                    }
                    return new EvalInsertWildcardSSWrapperRevision(selectExprContext, resultEventType, vaeProcessor);
                }
                if (joinWildcardProcessor == null) {
                    if (!isRevisionEvent) {
                        if (resultEventType instanceof WrapperEventType) {
                            return new EvalInsertWildcardWrapper(selectExprContext, resultEventType);
                        }
                        return new EvalInsertWildcardBean(selectExprContext, resultEventType);
                    }
                    return new EvalInsertWildcardRevision(selectExprContext, resultEventType, vaeProcessor);
                }
                if (!isRevisionEvent) {
                    return new EvalInsertWildcardJoin(selectExprContext, resultEventType, joinWildcardProcessor);
                }
                return new EvalInsertWildcardJoinRevision(selectExprContext, resultEventType, joinWildcardProcessor, vaeProcessor);
            }
            EventType resultEventType = null;
            if (columnNames.length == 1 && this.insertIntoDesc.getColumnNames().size() == 0 && (existingType = this.eventAdapterService.getExistsTypeByName(this.insertIntoDesc.getEventTypeName())) != null) {
                BeanEventType beanType;
                WrapperEventType wrapperType;
                Object columnOneType = expressionReturnTypes[0];
                if (existingType instanceof WrapperEventType && (wrapperType = (WrapperEventType)existingType).getUnderlyingEventType().getUnderlyingType() == columnOneType) {
                    singleColumnCoercion = true;
                    resultEventType = existingType;
                }
                if (existingType instanceof BeanEventType && columnOneType instanceof Class && JavaClassHelper.isSubclassOrImplementsInterface((Class)columnOneType, (beanType = (BeanEventType)existingType).getUnderlyingType())) {
                    singleColumnCoercion = true;
                    resultEventType = existingType;
                }
            }
            if (resultEventType == null) {
                if (vaeProcessor != null) {
                    if (this.valueAddEventService.getValueAddProcessor(this.insertIntoDesc.getEventTypeName()) == null) {
                        resultEventType = this.eventAdapterService.createAnonymousMapType(this.statementId + "_vae_" + CollectionUtil.toString(this.assignedTypeNumberStack, "_"), selPropertyTypes);
                    } else {
                        String statementName = "stmt_" + this.statementId + "_insert";
                        resultEventType = this.eventAdapterService.addNestableMapType(statementName, selPropertyTypes, null, false, false, false, false, true);
                    }
                } else {
                    existingType = this.eventAdapterService.getExistsTypeByName(this.insertIntoDesc.getEventTypeName());
                    if (existingType == null) {
                        Class clazz = null;
                        try {
                            clazz = this.methodResolutionService.resolveClass(this.insertIntoDesc.getEventTypeName());
                        }
                        catch (EngineImportException e) {
                            log.debug((Object)("Target stream name '" + this.insertIntoDesc.getEventTypeName() + "' is not resolved as a class name"));
                        }
                        if (clazz != null) {
                            existingType = this.eventAdapterService.addBeanType(clazz.getName(), clazz, false, false, false);
                        }
                    }
                    SelectExprInsertEventBean selectExprInsertEventBean = null;
                    if (existingType != null) {
                        selectExprInsertEventBean = SelectExprInsertEventBean.getInsertUnderlying(this.eventAdapterService, existingType);
                    }
                    if (existingType != null && selectExprInsertEventBean != null) {
                        selectExprInsertEventBean.initialize(this.isUsingWildcard, this.typeService, exprEvaluators, columnNames, expressionReturnTypes, this.methodResolutionService, this.eventAdapterService);
                        resultEventType = existingType;
                        return new EvalInsertNative(resultEventType, selectExprInsertEventBean, this.exprEvaluatorContext);
                    }
                    resultEventType = this.eventAdapterService.addNestableMapType(this.insertIntoDesc.getEventTypeName(), selPropertyTypes, null, false, false, false, false, true);
                }
            }
            if (vaeProcessor != null) {
                vaeProcessor.validateEventType(resultEventType);
                vaeInnerEventType = resultEventType;
                resultEventType = vaeProcessor.getValueAddEventType();
                isRevisionEvent = true;
            }
            if (singleColumnCoercion) {
                if (!isRevisionEvent) {
                    if (resultEventType instanceof MapEventType) {
                        return new EvalInsertNoWildcardSingleColCoercionMap(selectExprContext, resultEventType);
                    }
                    if (resultEventType instanceof BeanEventType) {
                        return new EvalInsertNoWildcardSingleColCoercionBean(selectExprContext, resultEventType);
                    }
                    return new EvalInsertNoWildcardSingleColCoercionBeanWrap(selectExprContext, resultEventType);
                }
                if (resultEventType instanceof MapEventType) {
                    return new EvalInsertNoWildcardSingleColCoercionRevisionMap(selectExprContext, resultEventType, vaeProcessor, vaeInnerEventType);
                }
                if (resultEventType instanceof BeanEventType) {
                    return new EvalInsertNoWildcardSingleColCoercionRevisionBean(selectExprContext, resultEventType, vaeProcessor, vaeInnerEventType);
                }
                return new EvalInsertNoWildcardSingleColCoercionRevisionBeanWrap(selectExprContext, resultEventType, vaeProcessor, vaeInnerEventType);
            }
            if (!isRevisionEvent) {
                return new EvalInsertNoWildcard(selectExprContext, resultEventType);
            }
            return new EvalInsertNoWildcardRevision(selectExprContext, resultEventType, vaeProcessor, vaeInnerEventType);
        }
        catch (EventAdapterException ex) {
            log.debug((Object)("Exception provided by event adapter: " + ex.getMessage()), (Throwable)ex);
            throw new ExprValidationException(ex.getMessage());
        }
    }

    private static void verifyInsertInto(InsertIntoDesc insertIntoDesc, List<SelectClauseExprCompiledSpec> selectionList) throws ExprValidationException {
        HashSet<String> names = new HashSet<String>();
        for (String element : insertIntoDesc.getColumnNames()) {
            if (names.contains(element)) {
                throw new ExprValidationException("Property name '" + element + "' appears more then once in insert-into clause");
            }
            names.add(element);
        }
        if (!insertIntoDesc.getColumnNames().isEmpty() && insertIntoDesc.getColumnNames().size() != selectionList.size()) {
            throw new ExprValidationException("Number of supplied values in the select clause does not match insert-into clause");
        }
    }
}

