/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core.eval;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.util.JavaClassHelper;

public class EvalInsertBeanRecast
implements SelectExprProcessor {
    private final EventType eventType;
    private final EventAdapterService eventAdapterService;
    private final int streamNumber;

    public EvalInsertBeanRecast(EventType targetType, EventAdapterService eventAdapterService, int streamNumber, EventType[] typesPerStream) throws ExprValidationException {
        this.eventType = targetType;
        this.eventAdapterService = eventAdapterService;
        this.streamNumber = streamNumber;
        EventType sourceType = typesPerStream[streamNumber];
        Class sourceClass = sourceType.getUnderlyingType();
        Class targetClass = targetType.getUnderlyingType();
        if (!JavaClassHelper.isSubclassOrImplementsInterface(sourceClass, targetClass)) {
            throw new ExprValidationException("Expression-returned event type '" + sourceType.getName() + "' with underlying type '" + sourceType.getUnderlyingType().getName() + "' cannot be converted target event type '" + targetType.getName() + "' with underlying type '" + targetType.getUnderlyingType().getName() + "'");
        }
    }

    @Override
    public EventBean process(EventBean[] eventsPerStream, boolean isNewData, boolean isSynthesize, ExprEvaluatorContext exprEvaluatorContext) {
        EventBean event = eventsPerStream[this.streamNumber];
        return this.eventAdapterService.adapterForTypedBean(event.getUnderlying(), this.eventType);
    }

    @Override
    public EventType getResultEventType() {
        return this.eventType;
    }
}

