/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.datetime.interval;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.datetime.eval.DatetimeMethodEnum;
import com.espertech.esper.epl.datetime.interval.ExprOptionalConstant;
import com.espertech.esper.epl.datetime.interval.IntervalComputer;
import com.espertech.esper.epl.datetime.interval.IntervalComputerConstantBase;
import com.espertech.esper.epl.datetime.interval.IntervalComputerExprBase;
import com.espertech.esper.epl.datetime.interval.IntervalStartEndParameterPair;
import com.espertech.esper.epl.expression.ExprConstantNode;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprTimePeriod;
import com.espertech.esper.epl.expression.ExprValidationException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IntervalComputerFactory {
    public static IntervalComputer make(DatetimeMethodEnum method, List<ExprNode> expressions) throws ExprValidationException {
        ExprOptionalConstant[] params = IntervalComputerFactory.getParameters(expressions);
        if (method == DatetimeMethodEnum.BEFORE) {
            if (params.length == 0) {
                return new IntervalComputerBeforeNoParam();
            }
            IntervalStartEndParameterPair pair = IntervalStartEndParameterPair.fromParamsWithLongMaxEnd(params);
            if (pair.isConstant()) {
                return new IntervalComputerConstantBefore(pair);
            }
            return new IntervalComputerBeforeWithDeltaExpr(pair);
        }
        if (method == DatetimeMethodEnum.AFTER) {
            if (params.length == 0) {
                return new IntervalComputerAfterNoParam();
            }
            IntervalStartEndParameterPair pair = IntervalStartEndParameterPair.fromParamsWithLongMaxEnd(params);
            if (pair.isConstant()) {
                return new IntervalComputerConstantAfter(pair);
            }
            return new IntervalComputerAfterWithDeltaExpr(pair);
        }
        if (method == DatetimeMethodEnum.COINCIDES) {
            if (params.length == 0) {
                return new IntervalComputerCoincidesNoParam();
            }
            IntervalStartEndParameterPair pair = IntervalStartEndParameterPair.fromParamsWithSameEnd(params);
            if (pair.isConstant()) {
                return new IntervalComputerConstantCoincides(pair);
            }
            return new IntervalComputerCoincidesWithDeltaExpr(pair);
        }
        if (method == DatetimeMethodEnum.DURING || method == DatetimeMethodEnum.INCLUDES) {
            if (params.length == 0) {
                if (method == DatetimeMethodEnum.DURING) {
                    return new IntervalComputerDuringNoParam();
                }
                return new IntervalComputerIncludesNoParam();
            }
            if (params.length == 1) {
                return new IntervalComputerDuringAndIncludesThreshold(method == DatetimeMethodEnum.DURING, params[0].getEvaluator());
            }
            if (params.length == 2) {
                return new IntervalComputerDuringAndIncludesMinMax(method == DatetimeMethodEnum.DURING, params[0].getEvaluator(), params[1].getEvaluator());
            }
            return new IntervalComputerDuringMinMaxStartEnd(method == DatetimeMethodEnum.DURING, params);
        }
        if (method == DatetimeMethodEnum.FINISHES) {
            if (params.length == 0) {
                return new IntervalComputerFinishesNoParam();
            }
            IntervalComputerFactory.validateConstantThreshold("finishes", params[0]);
            return new IntervalComputerFinishesThreshold(params[0].getEvaluator());
        }
        if (method == DatetimeMethodEnum.FINISHEDBY) {
            if (params.length == 0) {
                return new IntervalComputerFinishedByNoParam();
            }
            IntervalComputerFactory.validateConstantThreshold("finishedby", params[0]);
            return new IntervalComputerFinishedByThreshold(params[0].getEvaluator());
        }
        if (method == DatetimeMethodEnum.MEETS) {
            if (params.length == 0) {
                return new IntervalComputerMeetsNoParam();
            }
            IntervalComputerFactory.validateConstantThreshold("meets", params[0]);
            return new IntervalComputerMeetsThreshold(params[0].getEvaluator());
        }
        if (method == DatetimeMethodEnum.METBY) {
            if (params.length == 0) {
                return new IntervalComputerMetByNoParam();
            }
            IntervalComputerFactory.validateConstantThreshold("metBy", params[0]);
            return new IntervalComputerMetByThreshold(params[0].getEvaluator());
        }
        if (method == DatetimeMethodEnum.OVERLAPS || method == DatetimeMethodEnum.OVERLAPPEDBY) {
            if (params.length == 0) {
                if (method == DatetimeMethodEnum.OVERLAPS) {
                    return new IntervalComputerOverlapsNoParam();
                }
                return new IntervalComputerOverlappedByNoParam();
            }
            if (params.length == 1) {
                return new IntervalComputerOverlapsAndByThreshold(method == DatetimeMethodEnum.OVERLAPS, params[0].getEvaluator());
            }
            return new IntervalComputerOverlapsAndByMinMax(method == DatetimeMethodEnum.OVERLAPS, params[0].getEvaluator(), params[1].getEvaluator());
        }
        if (method == DatetimeMethodEnum.STARTS) {
            if (params.length == 0) {
                return new IntervalComputerStartsNoParam();
            }
            IntervalComputerFactory.validateConstantThreshold("starts", params[0]);
            return new IntervalComputerStartsThreshold(params[0].getEvaluator());
        }
        if (method == DatetimeMethodEnum.STARTEDBY) {
            if (params.length == 0) {
                return new IntervalComputerStartedByNoParam();
            }
            IntervalComputerFactory.validateConstantThreshold("startedBy", params[0]);
            return new IntervalComputerStartedByThreshold(params[0].getEvaluator());
        }
        throw new IllegalArgumentException("Unknown datetime method '" + (Object)((Object)method) + "'");
    }

    private static void validateConstantThreshold(String method, ExprOptionalConstant param) throws ExprValidationException {
        if (param.getOptionalConstant() != null && param.getOptionalConstant() < 0L) {
            throw new ExprValidationException("The " + method + " date-time method does not allow negative threshold value");
        }
    }

    private static ExprOptionalConstant[] getParameters(List<ExprNode> expressions) {
        ExprOptionalConstant[] params = new ExprOptionalConstant[expressions.size() - 1];
        for (int i = 1; i < expressions.size(); ++i) {
            params[i - 1] = IntervalComputerFactory.getExprOrConstant(expressions.get(i));
        }
        return params;
    }

    private static ExprOptionalConstant getExprOrConstant(ExprNode exprNode) {
        if (exprNode instanceof ExprTimePeriod) {
            Long constant = null;
            if (exprNode.isConstantResult()) {
                double sec = (Double)exprNode.getExprEvaluator().evaluate(null, true, null);
                constant = (long)(sec * 1000.0);
            }
            return new ExprOptionalConstant(exprNode.getExprEvaluator(), constant);
        }
        if (exprNode instanceof ExprConstantNode) {
            ExprConstantNode constantNode = (ExprConstantNode)exprNode;
            return new ExprOptionalConstant(constantNode.getExprEvaluator(), ((Number)constantNode.getValue()).longValue());
        }
        return new ExprOptionalConstant(exprNode.getExprEvaluator(), null);
    }

    public static class IntervalComputerStartedByThreshold
    implements IntervalComputer {
        private static final Log log = LogFactory.getLog(IntervalComputerStartedByThreshold.class);
        private final ExprEvaluator threshold;

        public IntervalComputerStartedByThreshold(ExprEvaluator threshold) {
            this.threshold = threshold;
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            Object thresholdValue = this.threshold.evaluate(eventsPerStream, newData, context);
            if (thresholdValue == null) {
                return null;
            }
            long threshold = IntervalComputerExprBase.toLong(thresholdValue);
            if (threshold < 0L) {
                log.warn((Object)"The 'finishes' date-time method does not allow negative threshold");
                return null;
            }
            long delta = Math.abs(leftStart - rightStart);
            return delta <= threshold && leftEnd > rightEnd;
        }
    }

    public static class IntervalComputerStartedByNoParam
    implements IntervalComputer {
        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return leftStart == rightStart && leftEnd > rightEnd;
        }
    }

    public static class IntervalComputerStartsThreshold
    implements IntervalComputer {
        private static final Log log = LogFactory.getLog(IntervalComputerStartsThreshold.class);
        private final ExprEvaluator threshold;

        public IntervalComputerStartsThreshold(ExprEvaluator threshold) {
            this.threshold = threshold;
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            Object thresholdValue = this.threshold.evaluate(eventsPerStream, newData, context);
            if (thresholdValue == null) {
                return null;
            }
            long threshold = IntervalComputerExprBase.toLong(thresholdValue);
            if (threshold < 0L) {
                log.warn((Object)"The 'finishes' date-time method does not allow negative threshold");
                return null;
            }
            long delta = Math.abs(leftStart - rightStart);
            return delta <= threshold && leftEnd < rightEnd;
        }
    }

    public static class IntervalComputerStartsNoParam
    implements IntervalComputer {
        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return leftStart == rightStart && leftEnd < rightEnd;
        }
    }

    public static class IntervalComputerOverlappedByNoParam
    implements IntervalComputer {
        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return rightStart < leftStart && leftStart < rightEnd && rightEnd < leftEnd;
        }
    }

    public static class IntervalComputerOverlapsAndByMinMax
    implements IntervalComputer {
        private final boolean overlaps;
        private final ExprEvaluator minEval;
        private final ExprEvaluator maxEval;

        public IntervalComputerOverlapsAndByMinMax(boolean overlaps, ExprEvaluator minEval, ExprEvaluator maxEval) {
            this.overlaps = overlaps;
            this.minEval = minEval;
            this.maxEval = maxEval;
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            Object minValue = this.minEval.evaluate(eventsPerStream, newData, context);
            if (minValue == null) {
                return null;
            }
            Object maxValue = this.maxEval.evaluate(eventsPerStream, newData, context);
            if (maxValue == null) {
                return null;
            }
            long minThreshold = IntervalComputerExprBase.toLong(minValue);
            long maxThreshold = IntervalComputerExprBase.toLong(maxValue);
            if (this.overlaps) {
                return IntervalComputerOverlapsAndByThreshold.computeInternalOverlaps(leftStart, leftEnd, rightStart, rightEnd, minThreshold, maxThreshold);
            }
            return IntervalComputerOverlapsAndByThreshold.computeInternalOverlaps(rightStart, rightEnd, leftStart, leftEnd, minThreshold, maxThreshold);
        }
    }

    public static class IntervalComputerOverlapsAndByThreshold
    implements IntervalComputer {
        private final boolean overlaps;
        private final ExprEvaluator threshold;

        public IntervalComputerOverlapsAndByThreshold(boolean overlaps, ExprEvaluator threshold) {
            this.overlaps = overlaps;
            this.threshold = threshold;
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            Object thresholdValue = this.threshold.evaluate(eventsPerStream, newData, context);
            if (thresholdValue == null) {
                return null;
            }
            long threshold = IntervalComputerExprBase.toLong(thresholdValue);
            if (this.overlaps) {
                return IntervalComputerOverlapsAndByThreshold.computeInternalOverlaps(leftStart, leftEnd, rightStart, rightEnd, 0L, threshold);
            }
            return IntervalComputerOverlapsAndByThreshold.computeInternalOverlaps(rightStart, rightEnd, leftStart, leftEnd, 0L, threshold);
        }

        public static boolean computeInternalOverlaps(long left, long leftEnd, long right, long rightEnd, long min, long max) {
            boolean match;
            boolean bl = match = left < right && right < leftEnd && leftEnd < rightEnd;
            if (!match) {
                return false;
            }
            long delta = leftEnd - right;
            return min <= delta && delta <= max;
        }
    }

    public static class IntervalComputerOverlapsNoParam
    implements IntervalComputer {
        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return leftStart < rightStart && rightStart < leftEnd && leftEnd < rightEnd;
        }
    }

    public static class IntervalComputerMetByThreshold
    implements IntervalComputer {
        private static final Log log = LogFactory.getLog(IntervalComputerMetByThreshold.class);
        private final ExprEvaluator threshold;

        public IntervalComputerMetByThreshold(ExprEvaluator threshold) {
            this.threshold = threshold;
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            Object thresholdValue = this.threshold.evaluate(eventsPerStream, newData, context);
            if (thresholdValue == null) {
                return null;
            }
            long threshold = IntervalComputerExprBase.toLong(thresholdValue);
            if (threshold < 0L) {
                log.warn((Object)"The 'finishes' date-time method does not allow negative threshold");
                return null;
            }
            long delta = Math.abs(leftStart - rightEnd);
            return delta <= threshold;
        }
    }

    public static class IntervalComputerMetByNoParam
    implements IntervalComputer {
        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return rightEnd == leftStart;
        }
    }

    public static class IntervalComputerMeetsThreshold
    implements IntervalComputer {
        private static final Log log = LogFactory.getLog(IntervalComputerMeetsThreshold.class);
        private final ExprEvaluator threshold;

        public IntervalComputerMeetsThreshold(ExprEvaluator threshold) {
            this.threshold = threshold;
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            Object thresholdValue = this.threshold.evaluate(eventsPerStream, newData, context);
            if (thresholdValue == null) {
                return null;
            }
            long threshold = IntervalComputerExprBase.toLong(thresholdValue);
            if (threshold < 0L) {
                log.warn((Object)"The 'finishes' date-time method does not allow negative threshold");
                return null;
            }
            long delta = Math.abs(rightStart - leftEnd);
            return delta <= threshold;
        }
    }

    public static class IntervalComputerMeetsNoParam
    implements IntervalComputer {
        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return leftEnd == rightStart;
        }
    }

    public static class IntervalComputerFinishedByThreshold
    implements IntervalComputer {
        private static final Log log = LogFactory.getLog(IntervalComputerFinishedByThreshold.class);
        private final ExprEvaluator threshold;

        public IntervalComputerFinishedByThreshold(ExprEvaluator threshold) {
            this.threshold = threshold;
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            Object thresholdValue = this.threshold.evaluate(eventsPerStream, newData, context);
            if (thresholdValue == null) {
                return null;
            }
            long threshold = IntervalComputerExprBase.toLong(thresholdValue);
            if (threshold < 0L) {
                log.warn((Object)"The 'finishes' date-time method does not allow negative threshold");
                return null;
            }
            if (leftStart >= rightStart) {
                return false;
            }
            long delta = Math.abs(leftEnd - rightEnd);
            return delta <= threshold;
        }
    }

    public static class IntervalComputerFinishedByNoParam
    implements IntervalComputer {
        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return leftStart < rightStart && leftEnd == rightEnd;
        }
    }

    public static class IntervalComputerFinishesThreshold
    implements IntervalComputer {
        private static final Log log = LogFactory.getLog(IntervalComputerFinishesThreshold.class);
        private final ExprEvaluator threshold;

        public IntervalComputerFinishesThreshold(ExprEvaluator threshold) {
            this.threshold = threshold;
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            Object thresholdValue = this.threshold.evaluate(eventsPerStream, newData, context);
            if (thresholdValue == null) {
                return null;
            }
            long threshold = IntervalComputerExprBase.toLong(thresholdValue);
            if (threshold < 0L) {
                log.warn((Object)"The 'finishes' date-time method does not allow negative threshold");
                return null;
            }
            if (rightStart >= leftStart) {
                return false;
            }
            long delta = Math.abs(leftEnd - rightEnd);
            return delta <= threshold;
        }
    }

    public static class IntervalComputerFinishesNoParam
    implements IntervalComputer {
        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return rightStart < leftStart && leftEnd == rightEnd;
        }
    }

    public static class IntervalComputerDuringMinMaxStartEnd
    implements IntervalComputer {
        private final boolean during;
        private final ExprEvaluator minStartEval;
        private final ExprEvaluator maxStartEval;
        private final ExprEvaluator minEndEval;
        private final ExprEvaluator maxEndEval;

        public IntervalComputerDuringMinMaxStartEnd(boolean during, ExprOptionalConstant[] params) {
            this.during = during;
            this.minStartEval = params[0].getEvaluator();
            this.maxStartEval = params[1].getEvaluator();
            this.minEndEval = params[2].getEvaluator();
            this.maxEndEval = params[3].getEvaluator();
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            Object minStartObject = this.minStartEval.evaluate(eventsPerStream, newData, context);
            if (minStartObject == null) {
                return null;
            }
            Object maxStartObject = this.maxStartEval.evaluate(eventsPerStream, newData, context);
            if (maxStartObject == null) {
                return null;
            }
            Object minEndObject = this.minEndEval.evaluate(eventsPerStream, newData, context);
            if (minEndObject == null) {
                return null;
            }
            Object maxEndObject = this.maxEndEval.evaluate(eventsPerStream, newData, context);
            if (maxEndObject == null) {
                return null;
            }
            long minStart = IntervalComputerExprBase.toLong(minStartObject);
            long maxStart = IntervalComputerExprBase.toLong(maxStartObject);
            long minEnd = IntervalComputerExprBase.toLong(minEndObject);
            long maxEnd = IntervalComputerExprBase.toLong(maxEndObject);
            if (this.during) {
                return IntervalComputerDuringAndIncludesMinMax.computeInternalDuring(leftStart, leftEnd, rightStart, rightEnd, minStart, maxStart, minEnd, maxEnd);
            }
            return IntervalComputerDuringAndIncludesMinMax.computeInternalIncludes(leftStart, leftEnd, rightStart, rightEnd, minStart, maxStart, minEnd, maxEnd);
        }
    }

    public static class IntervalComputerDuringAndIncludesMinMax
    implements IntervalComputer {
        private final boolean during;
        private final ExprEvaluator minEval;
        private final ExprEvaluator maxEval;

        public IntervalComputerDuringAndIncludesMinMax(boolean during, ExprEvaluator minEval, ExprEvaluator maxEval) {
            this.during = during;
            this.minEval = minEval;
            this.maxEval = maxEval;
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            Object minObject = this.minEval.evaluate(eventsPerStream, newData, context);
            if (minObject == null) {
                return null;
            }
            long min = IntervalComputerExprBase.toLong(minObject);
            Object maxObject = this.maxEval.evaluate(eventsPerStream, newData, context);
            if (maxObject == null) {
                return null;
            }
            long max = IntervalComputerExprBase.toLong(maxObject);
            if (this.during) {
                return IntervalComputerDuringAndIncludesMinMax.computeInternalDuring(leftStart, leftEnd, rightStart, rightEnd, min, max, min, max);
            }
            return IntervalComputerDuringAndIncludesMinMax.computeInternalIncludes(leftStart, leftEnd, rightStart, rightEnd, min, max, min, max);
        }

        public static boolean computeInternalDuring(long left, long leftEnd, long right, long rightEnd, long startMin, long startMax, long endMin, long endMax) {
            long deltaStart;
            if (startMin <= 0L) {
                startMin = 1L;
            }
            if ((deltaStart = left - right) < startMin || deltaStart > startMax) {
                return false;
            }
            long deltaEnd = rightEnd - leftEnd;
            return deltaEnd >= endMin && deltaEnd <= endMax;
        }

        public static boolean computeInternalIncludes(long left, long leftEnd, long right, long rightEnd, long startMin, long startMax, long endMin, long endMax) {
            long deltaStart;
            if (startMin <= 0L) {
                startMin = 1L;
            }
            if ((deltaStart = right - left) < startMin || deltaStart > startMax) {
                return false;
            }
            long deltaEnd = leftEnd - rightEnd;
            return deltaEnd >= endMin && deltaEnd <= endMax;
        }
    }

    public static class IntervalComputerDuringAndIncludesThreshold
    implements IntervalComputer {
        private final boolean during;
        private final ExprEvaluator threshold;

        public IntervalComputerDuringAndIncludesThreshold(boolean during, ExprEvaluator threshold) {
            this.during = during;
            this.threshold = threshold;
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            Object thresholdValue = this.threshold.evaluate(eventsPerStream, newData, context);
            if (thresholdValue == null) {
                return null;
            }
            long threshold = IntervalComputerExprBase.toLong(thresholdValue);
            if (this.during) {
                long deltaStart = leftStart - rightStart;
                if (deltaStart <= 0L || deltaStart > threshold) {
                    return false;
                }
                long deltaEnd = rightEnd - leftEnd;
                return deltaEnd > 0L && deltaEnd <= threshold;
            }
            long deltaStart = rightStart - leftStart;
            if (deltaStart <= 0L || deltaStart > threshold) {
                return false;
            }
            long deltaEnd = leftEnd - rightEnd;
            return deltaEnd > 0L && deltaEnd <= threshold;
        }
    }

    public static class IntervalComputerIncludesNoParam
    implements IntervalComputer {
        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return leftStart < rightStart && rightEnd < leftEnd;
        }
    }

    public static class IntervalComputerDuringNoParam
    implements IntervalComputer {
        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return rightStart < leftStart && leftEnd < rightEnd;
        }
    }

    public static class IntervalComputerCoincidesNoParam
    implements IntervalComputer {
        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return leftStart == rightStart && leftEnd == rightEnd;
        }
    }

    public static class IntervalComputerCoincidesWithDeltaExpr
    implements IntervalComputer {
        private static final Log log = LogFactory.getLog(IntervalComputerCoincidesWithDeltaExpr.class);
        private final ExprEvaluator start;
        private final ExprEvaluator finish;

        public IntervalComputerCoincidesWithDeltaExpr(IntervalStartEndParameterPair pair) {
            this.start = pair.getStart().getEvaluator();
            this.finish = pair.getEnd().getEvaluator();
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            Object startValue = this.start.evaluate(eventsPerStream, newData, context);
            if (startValue == null) {
                return null;
            }
            Object endValue = this.finish.evaluate(eventsPerStream, newData, context);
            if (endValue == null) {
                return null;
            }
            long start = IntervalComputerExprBase.toLong(startValue);
            long end = IntervalComputerExprBase.toLong(endValue);
            if (start < 0L || end < 0L) {
                log.warn((Object)"The coincides date-time method does not allow negative start and end values");
                return null;
            }
            return IntervalComputerConstantCoincides.computeInternal(leftStart, leftEnd, rightStart, rightEnd, start, end);
        }
    }

    public static class IntervalComputerConstantCoincides
    implements IntervalComputer {
        protected final long start;
        protected final long end;

        public IntervalComputerConstantCoincides(IntervalStartEndParameterPair pair) throws ExprValidationException {
            this.start = pair.getStart().getOptionalConstant();
            this.end = pair.getEnd().getOptionalConstant();
            if (this.start < 0L || this.end < 0L) {
                throw new ExprValidationException("The coincides date-time method does not allow negative start and end values");
            }
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return IntervalComputerConstantCoincides.computeInternal(leftStart, leftEnd, rightStart, rightEnd, this.start, this.end);
        }

        public static Boolean computeInternal(long left, long leftEnd, long right, long rightEnd, long startThreshold, long endThreshold) {
            return Math.abs(left - right) <= startThreshold && Math.abs(leftEnd - rightEnd) <= endThreshold;
        }
    }

    public static class IntervalComputerBeforeNoParam
    implements IntervalComputer {
        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return leftEnd < rightStart;
        }
    }

    public static class IntervalComputerBeforeWithDeltaExpr
    extends IntervalComputerExprBase {
        public IntervalComputerBeforeWithDeltaExpr(IntervalStartEndParameterPair pair) {
            super(pair);
        }

        @Override
        public boolean compute(long leftStartTs, long leftEnd, long rightStartTs, long rightEnd, long start, long end) {
            return IntervalComputerConstantBefore.computeInternal(leftStartTs, leftEnd, rightStartTs, start, end);
        }
    }

    public static class IntervalComputerConstantBefore
    extends IntervalComputerConstantBase
    implements IntervalComputer {
        public IntervalComputerConstantBefore(IntervalStartEndParameterPair pair) {
            super(pair, true);
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return IntervalComputerConstantBefore.computeInternal(leftStart, leftEnd, rightStart, this.start, this.end);
        }

        public static Boolean computeInternal(long left, long leftEnd, long right, long start, long end) {
            long delta = right - leftEnd;
            return start <= delta && delta <= end;
        }
    }

    public static class IntervalComputerAfterNoParam
    implements IntervalComputer {
        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return leftStart > rightEnd;
        }
    }

    public static class IntervalComputerAfterWithDeltaExpr
    extends IntervalComputerExprBase {
        public IntervalComputerAfterWithDeltaExpr(IntervalStartEndParameterPair pair) {
            super(pair);
        }

        @Override
        public boolean compute(long leftStartTs, long leftEnd, long rightStartTs, long rightEnd, long start, long end) {
            return IntervalComputerConstantAfter.computeInternal(leftStartTs, leftEnd, rightStartTs, rightEnd, start, end);
        }
    }

    public static class IntervalComputerConstantAfter
    extends IntervalComputerConstantBase
    implements IntervalComputer {
        public IntervalComputerConstantAfter(IntervalStartEndParameterPair pair) {
            super(pair, true);
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return IntervalComputerConstantAfter.computeInternal(leftStart, leftEnd, rightStart, rightEnd, this.start, this.end);
        }

        public static Boolean computeInternal(long leftStart, long leftEnd, long rightStart, long rightEnd, long start, long end) {
            long delta = leftStart - rightEnd;
            return start <= delta && delta <= end;
        }
    }
}

