/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.db;

import com.espertech.esper.antlr.NoCaseSensitiveStream;
import com.espertech.esper.client.ConfigurationDBRef;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.hook.SQLColumnTypeContext;
import com.espertech.esper.client.hook.SQLColumnTypeConversion;
import com.espertech.esper.client.hook.SQLOutputRowConversion;
import com.espertech.esper.client.hook.SQLOutputRowTypeContext;
import com.espertech.esper.core.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.epl.db.ColumnSettings;
import com.espertech.esper.epl.db.ConnectionCache;
import com.espertech.esper.epl.db.DBOutputTypeDesc;
import com.espertech.esper.epl.db.DataCache;
import com.espertech.esper.epl.db.DatabaseConfigException;
import com.espertech.esper.epl.db.DatabaseConfigService;
import com.espertech.esper.epl.db.DatabaseConnectionFactory;
import com.espertech.esper.epl.db.DatabasePollingViewable;
import com.espertech.esper.epl.db.PollExecStrategyDBQuery;
import com.espertech.esper.epl.db.QueryMetaData;
import com.espertech.esper.epl.db.SQLParameterDesc;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.generated.EsperEPL2GrammarLexer;
import com.espertech.esper.epl.spec.DBStatementStreamSpec;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.util.DatabaseTypeBinding;
import com.espertech.esper.util.DatabaseTypeEnum;
import com.espertech.esper.util.PlaceholderParseException;
import com.espertech.esper.util.PlaceholderParser;
import com.espertech.esper.util.SQLTypeMapUtil;
import com.espertech.esper.view.HistoricalEventViewable;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatabasePollingViewableFactory {
    public static final String SAMPLE_WHERECLAUSE_PLACEHOLDER = "$ESPER-SAMPLE-WHERE";
    private static final Log log = LogFactory.getLog(DatabasePollingViewableFactory.class);

    public static HistoricalEventViewable createDBStatementView(String statementId, int streamNumber, DBStatementStreamSpec databaseStreamSpec, DatabaseConfigService databaseConfigService, EventAdapterService eventAdapterService, EPStatementAgentInstanceHandle epStatementAgentInstanceHandle, SQLColumnTypeConversion columnTypeConversionHook, SQLOutputRowConversion outputRowConversionHook, boolean enableJDBCLogging) throws ExprValidationException {
        DataCache dataCache;
        ConnectionCache connectionCache;
        EventType eventType;
        QueryMetaData queryMetaData;
        String connectionClass;
        Connection connection;
        ColumnSettings metadataSetting;
        DatabaseConnectionFactory databaseConnectionFactory;
        List<PlaceholderParser.Fragment> sqlFragments;
        try {
            sqlFragments = PlaceholderParser.parsePlaceholder(databaseStreamSpec.getSqlWithSubsParams());
        }
        catch (PlaceholderParseException ex) {
            String text = "Error parsing SQL";
            throw new ExprValidationException(text + ", reason: " + ex.getMessage());
        }
        String preparedStatementText = DatabasePollingViewableFactory.createPreparedStatement(sqlFragments);
        SQLParameterDesc parameterDesc = DatabasePollingViewableFactory.getParameters(sqlFragments);
        if (log.isDebugEnabled()) {
            log.debug((Object)(".createDBEventStream preparedStatementText=" + preparedStatementText + " parameterDesc=" + parameterDesc));
        }
        String databaseName = databaseStreamSpec.getDatabaseName();
        try {
            databaseConnectionFactory = databaseConfigService.getConnectionFactory(databaseName);
            metadataSetting = databaseConfigService.getQuerySetting(databaseName);
        }
        catch (DatabaseConfigException ex) {
            String text = "Error connecting to database '" + databaseName + '\'';
            log.error((Object)text, (Throwable)ex);
            throw new ExprValidationException(text + ", reason: " + ex.getMessage());
        }
        try {
            connection = databaseConnectionFactory.getConnection();
        }
        catch (DatabaseConfigException ex) {
            String text = "Error connecting to database '" + databaseName + '\'';
            log.error((Object)text, (Throwable)ex);
            throw new ExprValidationException(text + ", reason: " + ex.getMessage());
        }
        ConfigurationDBRef.MetadataOriginEnum metaOriginPolicy = metadataSetting.getMetadataRetrievalEnum();
        if (metaOriginPolicy == ConfigurationDBRef.MetadataOriginEnum.DEFAULT && ((connectionClass = connection.getClass().getName()).toLowerCase().contains("oracle") || connectionClass.toLowerCase().contains("timesten"))) {
            metaOriginPolicy = ConfigurationDBRef.MetadataOriginEnum.SAMPLE;
        }
        try {
            if (metaOriginPolicy == ConfigurationDBRef.MetadataOriginEnum.METADATA || metaOriginPolicy == ConfigurationDBRef.MetadataOriginEnum.DEFAULT) {
                queryMetaData = DatabasePollingViewableFactory.getPreparedStmtMetadata(connection, parameterDesc.getParameters(), preparedStatementText, metadataSetting);
            } else {
                String sampleSQL;
                boolean isGivenMetadataSQL = true;
                if (databaseStreamSpec.getMetadataSQL() != null) {
                    sampleSQL = databaseStreamSpec.getMetadataSQL();
                    isGivenMetadataSQL = true;
                    if (log.isInfoEnabled()) {
                        log.info((Object)(".createDBStatementView Using provided sample SQL '" + sampleSQL + "'"));
                    }
                } else {
                    sampleSQL = DatabasePollingViewableFactory.createSamplePlaceholderStatement(sqlFragments);
                    if (log.isInfoEnabled()) {
                        log.info((Object)(".createDBStatementView Using un-lexed sample SQL '" + sampleSQL + "'"));
                    }
                    if (parameterDesc.getBuiltinIdentifiers().length != 1) {
                        sampleSQL = DatabasePollingViewableFactory.lexSampleSQL(sampleSQL);
                        if (log.isInfoEnabled()) {
                            log.info((Object)(".createDBStatementView Using lexed sample SQL '" + sampleSQL + "'"));
                        }
                    }
                }
                queryMetaData = DatabasePollingViewableFactory.getExampleQueryMetaData(connection, parameterDesc.getParameters(), sampleSQL, metadataSetting, isGivenMetadataSQL);
            }
        }
        catch (ExprValidationException ex) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw ex;
        }
        try {
            connection.close();
        }
        catch (SQLException e) {
            String text = "Error closing connection";
            log.error((Object)text, (Throwable)e);
            throw new ExprValidationException(text + ", reason: " + e.getMessage());
        }
        HashMap<String, Object> eventTypeFields = new HashMap<String, Object>();
        int columnNum = 1;
        for (Map.Entry<String, DBOutputTypeDesc> entry : queryMetaData.getOutputParameters().entrySet()) {
            Class newValue;
            String name = entry.getKey();
            DBOutputTypeDesc dbOutputDesc = entry.getValue();
            Class clazz = dbOutputDesc.getOptionalBinding() != null ? dbOutputDesc.getOptionalBinding().getType() : SQLTypeMapUtil.sqlTypeToClass(dbOutputDesc.getSqlType(), dbOutputDesc.getClassName());
            if (columnTypeConversionHook != null && (newValue = columnTypeConversionHook.getColumnType(new SQLColumnTypeContext(databaseStreamSpec.getDatabaseName(), databaseStreamSpec.getSqlWithSubsParams(), name, clazz, dbOutputDesc.getSqlType(), columnNum))) != null) {
                clazz = newValue;
            }
            eventTypeFields.put(name, clazz);
            ++columnNum;
        }
        if (outputRowConversionHook == null) {
            String outputEventType = statementId + "_dbpoll_" + streamNumber;
            eventType = eventAdapterService.createAnonymousMapType(outputEventType, eventTypeFields);
        } else {
            Class carrierClass = outputRowConversionHook.getOutputRowType(new SQLOutputRowTypeContext(databaseStreamSpec.getDatabaseName(), databaseStreamSpec.getSqlWithSubsParams(), eventTypeFields));
            if (carrierClass == null) {
                throw new ExprValidationException("Output row conversion hook returned no type");
            }
            eventType = eventAdapterService.addBeanType(carrierClass.getName(), carrierClass, false, false, false);
        }
        try {
            connectionCache = databaseConfigService.getConnectionCache(databaseName, preparedStatementText);
            dataCache = databaseConfigService.getDataCache(databaseName, epStatementAgentInstanceHandle);
        }
        catch (DatabaseConfigException e) {
            String text = "Error obtaining cache configuration";
            log.error((Object)text, (Throwable)e);
            throw new ExprValidationException(text + ", reason: " + e.getMessage());
        }
        PollExecStrategyDBQuery dbPollStrategy = new PollExecStrategyDBQuery(eventAdapterService, eventType, connectionCache, preparedStatementText, queryMetaData.getOutputParameters(), columnTypeConversionHook, outputRowConversionHook, enableJDBCLogging);
        return new DatabasePollingViewable(streamNumber, queryMetaData.getInputParameters(), dbPollStrategy, dataCache, eventType);
    }

    private static QueryMetaData getExampleQueryMetaData(Connection connection, String[] parameters, String sampleSQL, ColumnSettings metadataSetting, boolean isUsingMetadataSQL) throws ExprValidationException {
        Map<String, DBOutputTypeDesc> outputProperties;
        ResultSet result;
        Statement statement;
        LinkedList<String> inputParameters = new LinkedList<String>();
        inputParameters.addAll(Arrays.asList(parameters));
        try {
            statement = connection.createStatement();
        }
        catch (SQLException ex) {
            String text = "Error creating statement";
            log.error((Object)text, (Throwable)ex);
            throw new ExprValidationException(text + ", reason: " + ex.getMessage());
        }
        try {
            result = statement.executeQuery(sampleSQL);
        }
        catch (SQLException ex) {
            String text = isUsingMetadataSQL ? "Error compiling metadata SQL to retrieve statement metadata, using sql text '" + sampleSQL + "'" : "Error compiling metadata SQL to retrieve statement metadata, consider using the 'metadatasql' syntax, using sql text '" + sampleSQL + "'";
            try {
                statement.close();
            }
            catch (SQLException e) {
                log.info((Object)("Error closing statement: " + e.getMessage()), (Throwable)e);
            }
            log.error((Object)text, (Throwable)ex);
            throw new ExprValidationException(text + ", reason: " + ex.getMessage());
        }
        try {
            outputProperties = DatabasePollingViewableFactory.compileResultMetaData(result.getMetaData(), metadataSetting);
        }
        catch (SQLException ex) {
            try {
                result.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            try {
                statement.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            String text = "Error in statement '" + sampleSQL + "', failed to obtain result metadata";
            log.error((Object)text, (Throwable)ex);
            throw new ExprValidationException(text + ", please check the statement, reason: " + ex.getMessage());
        }
        return new QueryMetaData(inputParameters, outputProperties);
    }

    protected static String lexSampleSQL(String querySQL) throws ExprValidationException {
        StringWriter changedSQL;
        int insertIndex;
        String text;
        Token token;
        NoCaseSensitiveStream input;
        querySQL = querySQL.replaceAll("\\s\\s+|\\n|\\r", " ");
        StringReader reader = new StringReader(querySQL);
        try {
            input = new NoCaseSensitiveStream(reader);
        }
        catch (IOException ex) {
            throw new ExprValidationException("IOException lexing query SQL '" + querySQL + '\'', ex);
        }
        int whereIndex = -1;
        int groupbyIndex = -1;
        int havingIndex = -1;
        int orderByIndex = -1;
        ArrayList<Integer> unionIndexes = new ArrayList<Integer>();
        EsperEPL2GrammarLexer lex = new EsperEPL2GrammarLexer((CharStream)input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lex);
        List tokenList = tokens.getTokens();
        for (int i = 0; i < tokenList.size() && (token = (Token)tokenList.get(i)) != null && token.getText() != null; ++i) {
            text = token.getText().toLowerCase().trim();
            if (text.equals("where")) {
                whereIndex = token.getCharPositionInLine() + 1;
            }
            if (text.equals("group")) {
                groupbyIndex = token.getCharPositionInLine() + 1;
            }
            if (text.equals("having")) {
                havingIndex = token.getCharPositionInLine() + 1;
            }
            if (text.equals("order")) {
                orderByIndex = token.getCharPositionInLine() + 1;
            }
            if (!text.equals("union")) continue;
            unionIndexes.add(token.getCharPositionInLine() + 1);
        }
        if (unionIndexes.size() != 0) {
            StringWriter changedSQL2 = new StringWriter();
            int lastIndex = 0;
            for (int i = 0; i < unionIndexes.size(); ++i) {
                int index = (Integer)unionIndexes.get(i);
                String fragment = i > 0 ? querySQL.substring(lastIndex + 5, index - 1) : querySQL.substring(lastIndex, index - 1);
                String lexedFragment = DatabasePollingViewableFactory.lexSampleSQL(fragment);
                if (i > 0) {
                    changedSQL2.append("union ");
                }
                changedSQL2.append(lexedFragment);
                lastIndex = index - 1;
            }
            String fragment = querySQL.substring(lastIndex + 5, querySQL.length());
            String lexedFragment = DatabasePollingViewableFactory.lexSampleSQL(fragment);
            changedSQL2.append("union ");
            changedSQL2.append(lexedFragment);
            return changedSQL2.toString();
        }
        if (whereIndex != -1) {
            StringWriter changedSQL3 = new StringWriter();
            String prefix = querySQL.substring(0, whereIndex + 5);
            String suffix = querySQL.substring(whereIndex + 5, querySQL.length());
            changedSQL3.write(prefix);
            changedSQL3.write("1=0 and ");
            changedSQL3.write(suffix);
            return changedSQL3.toString();
        }
        if (groupbyIndex != -1) {
            insertIndex = groupbyIndex;
        } else if (havingIndex != -1) {
            insertIndex = havingIndex;
        } else if (orderByIndex != -1) {
            insertIndex = orderByIndex;
        } else {
            changedSQL = new StringWriter();
            changedSQL.write(querySQL);
            changedSQL.write(" where 1=0 ");
            return changedSQL.toString();
        }
        try {
            changedSQL = new StringWriter();
            String prefix = querySQL.substring(0, insertIndex - 1);
            changedSQL.write(prefix);
            changedSQL.write("where 1=0 ");
            String suffix = querySQL.substring(insertIndex - 1, querySQL.length());
            changedSQL.write(suffix);
            return changedSQL.toString();
        }
        catch (Exception ex) {
            text = "Error constructing sample SQL to retrieve metadata for JDBC-drivers that don't support metadata, consider using the $ESPER-SAMPLE-WHERE placeholder or providing a sample SQL";
            log.error((Object)text, (Throwable)ex);
            throw new ExprValidationException(text, ex);
        }
    }

    private static QueryMetaData getPreparedStmtMetadata(Connection connection, String[] parameters, String preparedStatementText, ColumnSettings metadataSetting) throws ExprValidationException {
        Map<String, DBOutputTypeDesc> outputProperties;
        PreparedStatement prepared;
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)(".getPreparedStmtMetadata Preparing statement '" + preparedStatementText + "'"));
            }
            prepared = connection.prepareStatement(preparedStatementText);
        }
        catch (SQLException ex) {
            String text = "Error preparing statement '" + preparedStatementText + '\'';
            log.error((Object)text, (Throwable)ex);
            throw new ExprValidationException(text + ", reason: " + ex.getMessage());
        }
        LinkedList<String> inputParameters = new LinkedList<String>();
        try {
            ParameterMetaData parameterMetaData = prepared.getParameterMetaData();
            inputParameters.addAll(Arrays.asList(parameters).subList(0, parameterMetaData.getParameterCount()));
        }
        catch (Exception ex) {
            try {
                prepared.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            String text = "Error obtaining parameter metadata from prepared statement, consider turning off metadata interrogation via configuration, for statement '" + preparedStatementText + '\'';
            log.error((Object)text, (Throwable)ex);
            throw new ExprValidationException(text + ", please check the statement, reason: " + ex.getMessage());
        }
        try {
            outputProperties = DatabasePollingViewableFactory.compileResultMetaData(prepared.getMetaData(), metadataSetting);
        }
        catch (SQLException ex) {
            try {
                prepared.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            String text = "Error in statement '" + preparedStatementText + "', failed to obtain result metadata, consider turning off metadata interrogation via configuration";
            log.error((Object)text, (Throwable)ex);
            throw new ExprValidationException(text + ", please check the statement, reason: " + ex.getMessage());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(".createDBEventStream in=" + ((Object)inputParameters).toString() + " out=" + outputProperties.toString()));
        }
        try {
            prepared.close();
        }
        catch (SQLException e) {
            String text = "Error closing prepared statement";
            log.error((Object)text, (Throwable)e);
            throw new ExprValidationException(text + ", reason: " + e.getMessage());
        }
        return new QueryMetaData(inputParameters, outputProperties);
    }

    private static String createPreparedStatement(List<PlaceholderParser.Fragment> parseFragements) {
        StringBuilder buffer = new StringBuilder();
        for (PlaceholderParser.Fragment fragment : parseFragements) {
            if (!fragment.isParameter()) {
                buffer.append(fragment.getValue());
                continue;
            }
            if (fragment.getValue().equals(SAMPLE_WHERECLAUSE_PLACEHOLDER)) continue;
            buffer.append('?');
        }
        return buffer.toString();
    }

    private static String createSamplePlaceholderStatement(List<PlaceholderParser.Fragment> parseFragements) {
        StringBuilder buffer = new StringBuilder();
        for (PlaceholderParser.Fragment fragment : parseFragements) {
            if (!fragment.isParameter()) {
                buffer.append(fragment.getValue());
                continue;
            }
            if (fragment.getValue().equals(SAMPLE_WHERECLAUSE_PLACEHOLDER)) {
                buffer.append(" where 1=0 ");
                break;
            }
            buffer.append("null");
        }
        return buffer.toString();
    }

    private static SQLParameterDesc getParameters(List<PlaceholderParser.Fragment> parseFragements) {
        LinkedList<String> eventPropertyParams = new LinkedList<String>();
        for (PlaceholderParser.Fragment fragment : parseFragements) {
            if (!fragment.isParameter() || fragment.getValue().equals(SAMPLE_WHERECLAUSE_PLACEHOLDER)) continue;
            eventPropertyParams.add(fragment.getValue());
        }
        String[] params = eventPropertyParams.toArray(new String[eventPropertyParams.size()]);
        String[] builtin = eventPropertyParams.toArray(new String[eventPropertyParams.size()]);
        return new SQLParameterDesc(params, builtin);
    }

    private static Map<String, DBOutputTypeDesc> compileResultMetaData(ResultSetMetaData resultMetaData, ColumnSettings columnSettings) throws SQLException {
        HashMap<String, DBOutputTypeDesc> outputProperties = new HashMap<String, DBOutputTypeDesc>();
        for (int i = 0; i < resultMetaData.getColumnCount(); ++i) {
            String columnName = resultMetaData.getColumnLabel(i + 1);
            if (columnName == null) {
                columnName = resultMetaData.getColumnName(i + 1);
            }
            int columnType = resultMetaData.getColumnType(i + 1);
            String javaClass = resultMetaData.getColumnTypeName(i + 1);
            ConfigurationDBRef.ColumnChangeCaseEnum caseEnum = columnSettings.getColumnCaseConversionEnum();
            if (caseEnum != null && caseEnum == ConfigurationDBRef.ColumnChangeCaseEnum.LOWERCASE) {
                columnName = columnName.toLowerCase();
            }
            if (caseEnum != null && caseEnum == ConfigurationDBRef.ColumnChangeCaseEnum.UPPERCASE) {
                columnName = columnName.toUpperCase();
            }
            DatabaseTypeBinding binding = null;
            String javaTypeBinding = null;
            if (columnSettings.getJavaSqlTypeBinding() != null) {
                javaTypeBinding = columnSettings.getJavaSqlTypeBinding().get(columnType);
            }
            if (javaTypeBinding != null) {
                binding = DatabaseTypeEnum.getEnum(javaTypeBinding).getBinding();
            }
            DBOutputTypeDesc outputType = new DBOutputTypeDesc(columnType, javaClass, binding);
            outputProperties.put(columnName, outputType);
        }
        return outputProperties;
    }
}

