/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.enummethod.dot;

import com.espertech.esper.client.EventType;
import com.espertech.esper.util.JavaClassHelper;
import java.util.Collection;

public class ExprDotEvalTypeInfo {
    private Class scalar;
    private Class component;
    private EventType eventType;
    private EventType eventTypeColl;

    private ExprDotEvalTypeInfo(Class scalar, Class component, EventType eventType, EventType eventTypeColl) {
        this.scalar = scalar;
        this.component = component;
        this.eventType = eventType;
        this.eventTypeColl = eventTypeColl;
    }

    public static ExprDotEvalTypeInfo from(Class inputType, Class collectionComponentType, EventType lambdaType) {
        ExprDotEvalTypeInfo info = new ExprDotEvalTypeInfo(null, null, null, null);
        if (lambdaType != null) {
            info.eventTypeColl = lambdaType;
        } else if (collectionComponentType != null) {
            info.scalar = Collection.class;
            info.component = collectionComponentType;
        } else {
            info.scalar = inputType;
        }
        return info;
    }

    public boolean isScalar() {
        return this.scalar != null;
    }

    public static ExprDotEvalTypeInfo scalarOrUnderlying(Class scalar) {
        return new ExprDotEvalTypeInfo(scalar, null, null, null);
    }

    public static ExprDotEvalTypeInfo componentColl(Class component) {
        return new ExprDotEvalTypeInfo(Collection.class, component, null, null);
    }

    public static ExprDotEvalTypeInfo eventColl(EventType eventColl) {
        return new ExprDotEvalTypeInfo(null, null, null, eventColl);
    }

    public static ExprDotEvalTypeInfo event(EventType event) {
        return new ExprDotEvalTypeInfo(null, null, event, null);
    }

    public Class getScalar() {
        return this.scalar;
    }

    public Class getComponent() {
        return this.component;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public EventType getEventTypeColl() {
        return this.eventTypeColl;
    }

    public String toTypeName() {
        if (this.component != null) {
            return "collection of " + this.component.getSimpleName();
        }
        if (this.eventType != null) {
            return "event type '" + this.eventType.getName() + "'";
        }
        if (this.eventTypeColl != null) {
            return "collection of events of type '" + this.eventTypeColl.getName() + "'";
        }
        if (this.scalar != null) {
            return "class " + JavaClassHelper.getClassNameFullyQualPretty(this.scalar);
        }
        return "an incompatible type";
    }
}

