/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.enummethod.eval;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.enummethod.eval.EnumEval;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class EnumEvalTake
implements EnumEval {
    private ExprEvaluator sizeEval;
    private EventBean[] events;

    public EnumEvalTake(ExprEvaluator sizeEval, int numStreams) {
        this.sizeEval = sizeEval;
        this.events = new EventBean[numStreams];
    }

    @Override
    public EventBean[] getEventsPrototype() {
        return this.events;
    }

    @Override
    public Object evaluateEnumMethod(Collection target, boolean isNewData, ExprEvaluatorContext context) {
        Object sizeObj = this.sizeEval.evaluate(this.events, isNewData, context);
        if (sizeObj == null) {
            return null;
        }
        if (target.isEmpty()) {
            return target;
        }
        int size = ((Number)sizeObj).intValue();
        if (size <= 0) {
            return Collections.emptyList();
        }
        if (target.size() < size) {
            return target;
        }
        if (size == 1) {
            return Collections.singletonList(target.iterator().next());
        }
        ArrayList result = new ArrayList(size);
        for (Object next : target) {
            if (result.size() >= size) break;
            result.add(next);
        }
        return result;
    }
}

