/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.agg.AggregationAccessType;
import com.espertech.esper.epl.agg.AggregationMethodFactory;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.expression.ExprAccessAggNodeFactory;
import com.espertech.esper.epl.expression.ExprAggregateNode;
import com.espertech.esper.epl.expression.ExprAggregateNodeBase;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprEvaluatorEnumeration;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprStreamUnderlyingNodeImpl;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.event.EventAdapterService;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class ExprAccessAggNode
extends ExprAggregateNodeBase
implements ExprEvaluatorEnumeration {
    private static final long serialVersionUID = -6088874732989061687L;
    private final AggregationAccessType accessType;
    private final boolean isWildcard;
    private final String streamWildcard;
    private transient EventType containedType;
    private transient ScalarCollectionEvaluator scalarCollectionEvaluator;

    public ExprAccessAggNode(AggregationAccessType accessType, boolean wildcard, String streamWildcard) {
        super(false);
        this.accessType = accessType;
        this.isWildcard = wildcard;
        this.streamWildcard = streamWildcard;
    }

    @Override
    public AggregationMethodFactory validateAggregationChild(StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        boolean istreamOnly;
        ExprEvaluator evaluator;
        Class resultType;
        int streamNum;
        ExprNode evaluatorIndex = null;
        if (this.isWildcard) {
            if (streamTypeService.getStreamNames().length > 1) {
                throw new ExprValidationException(this.getErrorPrefix() + " requires that in joins or subqueries the stream-wildcard (stream-alias.*) syntax is used instead");
            }
            streamNum = 0;
            if (streamTypeService.getStreamNames().length == 0) {
                throw new ExprValidationException(this.getErrorPrefix() + " requires that at least one stream is provided");
            }
            this.containedType = streamTypeService.getEventTypes()[0];
            final Class returnType = resultType = streamTypeService.getEventTypes()[0].getUnderlyingType();
            evaluator = new ExprEvaluator(){

                @Override
                public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
                    if (eventsPerStream == null || eventsPerStream[0] == null) {
                        return null;
                    }
                    return eventsPerStream[0].getUnderlying();
                }

                @Override
                public Class getType() {
                    return returnType;
                }

                @Override
                public Map<String, Object> getEventType() {
                    return null;
                }
            };
            istreamOnly = this.getIstreamOnly(streamTypeService, 0);
            if (this.accessType == AggregationAccessType.WINDOW && istreamOnly && !streamTypeService.isOnDemandStreams()) {
                throw new ExprValidationException(this.getErrorPrefix() + " requires that the aggregated events provide a remove stream; Defined a data window onto the stream or use 'firstever', 'lastever' or 'nth' instead");
            }
            this.getChildNodes().add(0, new ExprStreamUnderlyingNodeImpl(null, true, streamNum, resultType));
        } else if (this.streamWildcard != null) {
            streamNum = streamTypeService.getStreamNumForStreamName(this.streamWildcard);
            if (streamNum == -1) {
                throw new ExprValidationException(this.getErrorPrefix() + " stream wildcard '" + this.streamWildcard + "' does not resolve to any stream");
            }
            istreamOnly = this.getIstreamOnly(streamTypeService, streamNum);
            if (this.accessType == AggregationAccessType.WINDOW && istreamOnly && !streamTypeService.isOnDemandStreams()) {
                throw new ExprValidationException(this.getErrorPrefix() + " requires that the aggregated events provide a remove stream; Defined a data window onto the stream or use 'firstever', 'lastever' or 'nth' instead");
            }
            EventType type = streamTypeService.getEventTypes()[streamNum];
            resultType = type.getUnderlyingType();
            final int streamNumUsed = streamNum;
            final Class returnType = resultType;
            evaluator = new ExprEvaluator(){

                @Override
                public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
                    if (eventsPerStream == null || eventsPerStream[streamNumUsed] == null) {
                        return null;
                    }
                    return eventsPerStream[streamNumUsed].getUnderlying();
                }

                @Override
                public Class getType() {
                    return returnType;
                }

                @Override
                public Map<String, Object> getEventType() {
                    return null;
                }
            };
            this.getChildNodes().add(0, new ExprStreamUnderlyingNodeImpl(this.streamWildcard, false, streamNum, resultType));
        } else {
            if (this.getChildNodes().isEmpty()) {
                throw new ExprValidationException(this.getErrorPrefix() + " requires a expression or wildcard (*) or stream wildcard (stream-alias.*)");
            }
            ExprNode child = this.getChildNodes().get(0);
            Set<Integer> streams = ExprNodeUtility.getIdentStreamNumbers(child);
            if (streams.isEmpty() || streams.size() > 1) {
                throw new ExprValidationException(this.getErrorPrefix() + " requires that any child expressions evaluate properties of the same stream; Use 'firstever' or 'lastever' or 'nth' instead");
            }
            streamNum = streams.iterator().next();
            istreamOnly = this.getIstreamOnly(streamTypeService, streamNum);
            if (this.accessType == AggregationAccessType.WINDOW && istreamOnly && !streamTypeService.isOnDemandStreams()) {
                throw new ExprValidationException(this.getErrorPrefix() + " requires that the aggregated events provide a remove stream; Defined a data window onto the stream or use 'firstever', 'lastever' or 'nth' instead");
            }
            resultType = this.getChildNodes().get(0).getExprEvaluator().getType();
            evaluator = this.getChildNodes().get(0).getExprEvaluator();
            this.scalarCollectionEvaluator = new ScalarCollectionEvaluator(evaluator, streamNum, resultType);
        }
        if (this.getChildNodes().size() > 1) {
            if (this.accessType == AggregationAccessType.WINDOW) {
                throw new ExprValidationException(this.getErrorPrefix() + " does not accept an index expression; Use 'first' or 'last' instead");
            }
            evaluatorIndex = this.getChildNodes().get(1);
            if (evaluatorIndex.getExprEvaluator().getType() != Integer.class) {
                throw new ExprValidationException(this.getErrorPrefix() + " requires an index expression that returns an integer value");
            }
        }
        return new ExprAccessAggNodeFactory(this.accessType, resultType, streamNum, evaluator, evaluatorIndex, istreamOnly, streamTypeService.isOnDemandStreams());
    }

    private boolean getIstreamOnly(StreamTypeService streamTypeService, int streamNum) {
        if (streamNum < streamTypeService.getEventTypes().length) {
            return streamTypeService.getIStreamOnly()[streamNum];
        }
        return streamTypeService.getIStreamOnly()[0];
    }

    @Override
    protected String getAggregationFunctionName() {
        return this.accessType.toString().toLowerCase();
    }

    @Override
    public String toExpressionString() {
        StringWriter writer = new StringWriter();
        writer.append(this.accessType.toString().toLowerCase());
        writer.append('(');
        if (this.isWildcard) {
            writer.append('*');
        } else if (this.streamWildcard != null) {
            writer.append(this.streamWildcard);
            writer.append(".*");
        } else {
            writer.append(this.getChildNodes().get(0).toExpressionString());
        }
        writer.append(')');
        return writer.toString();
    }

    public AggregationAccessType getAccessType() {
        return this.accessType;
    }

    public boolean isWildcard() {
        return this.isWildcard;
    }

    public String getStreamWildcard() {
        return this.streamWildcard;
    }

    @Override
    public Collection<EventBean> evaluateGetROCollectionEvents(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return this.aggregationResultFuture.getCollection(this.column, context);
    }

    @Override
    public Collection evaluateGetROCollectionScalar(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Collection<EventBean> events = this.evaluateGetROCollectionEvents(eventsPerStream, isNewData, context);
        if (events == null) {
            return null;
        }
        if (events.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayDeque<Object> list = new ArrayDeque<Object>();
        for (EventBean bean : events) {
            list.add(this.scalarCollectionEvaluator.evaluate(bean, isNewData, context));
        }
        return list;
    }

    @Override
    public EventType getEventTypeCollection(EventAdapterService eventAdapterService) {
        if (this.accessType == AggregationAccessType.FIRST || this.accessType == AggregationAccessType.LAST) {
            return null;
        }
        return this.containedType;
    }

    @Override
    public Class getComponentTypeCollection() throws ExprValidationException {
        return this.scalarCollectionEvaluator == null ? null : this.scalarCollectionEvaluator.componentType;
    }

    @Override
    public EventType getEventTypeSingle(EventAdapterService eventAdapterService, String statementId) throws ExprValidationException {
        if (this.accessType == AggregationAccessType.FIRST || this.accessType == AggregationAccessType.LAST) {
            return this.containedType;
        }
        return null;
    }

    @Override
    public EventBean evaluateGetEventBean(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return this.aggregationResultFuture.getEventBean(this.column, context);
    }

    @Override
    protected boolean equalsNodeAggregate(ExprAggregateNode node) {
        if (this == node) {
            return true;
        }
        if (node == null || this.getClass() != node.getClass()) {
            return false;
        }
        ExprAccessAggNode that = (ExprAccessAggNode)node;
        if (this.isWildcard != that.isWildcard) {
            return false;
        }
        if (this.accessType != that.accessType) {
            return false;
        }
        return !(this.streamWildcard != null ? !this.streamWildcard.equals(that.streamWildcard) : that.streamWildcard != null);
    }

    private String getErrorPrefix() {
        return "The '" + this.accessType.toString().toLowerCase() + "' aggregation function";
    }

    private static class ScalarCollectionEvaluator {
        private final ExprEvaluator scalarEvaluator;
        private final int streamId;
        private final Class componentType;
        private final EventBean[] eventsPerStream;

        private ScalarCollectionEvaluator(ExprEvaluator scalarEvaluator, int streamId, Class componentType) {
            this.scalarEvaluator = scalarEvaluator;
            this.streamId = streamId;
            this.componentType = componentType;
            this.eventsPerStream = new EventBean[streamId + 1];
        }

        public Object evaluate(EventBean event, boolean isNewData, ExprEvaluatorContext context) {
            this.eventsPerStream[this.streamId] = event;
            return this.scalarEvaluator.evaluate(this.eventsPerStream, isNewData, context);
        }

        public Class getComponentType() {
            return this.componentType;
        }
    }
}

