/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.epl.agg.AggregationAccessType;
import com.espertech.esper.epl.agg.AggregationAccessor;
import com.espertech.esper.epl.agg.AggregationAccessorAll;
import com.espertech.esper.epl.agg.AggregationAccessorFirst;
import com.espertech.esper.epl.agg.AggregationAccessorFirstLastIndex;
import com.espertech.esper.epl.agg.AggregationAccessorLast;
import com.espertech.esper.epl.agg.AggregationMethod;
import com.espertech.esper.epl.agg.AggregationMethodFactory;
import com.espertech.esper.epl.agg.AggregationSpec;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.util.JavaClassHelper;

public class ExprAccessAggNodeFactory
implements AggregationMethodFactory {
    private final AggregationAccessType accessType;
    private final Class resultType;
    private final int streamNum;
    private final ExprEvaluator childNode;
    private final ExprNode indexEvalNode;
    private final boolean istreamOnly;
    private final boolean ondemandQuery;

    public ExprAccessAggNodeFactory(AggregationAccessType accessType, Class resultType, int streamNum, ExprEvaluator childNode, ExprNode indexEvalNode, boolean istreamOnly, boolean ondemandQuery) {
        this.accessType = accessType;
        this.resultType = resultType;
        this.streamNum = streamNum;
        this.childNode = childNode;
        this.indexEvalNode = indexEvalNode;
        this.istreamOnly = istreamOnly;
        this.ondemandQuery = ondemandQuery;
    }

    @Override
    public Class getResultType() {
        if (this.accessType == AggregationAccessType.WINDOW) {
            return JavaClassHelper.getArrayType(this.resultType);
        }
        return this.resultType;
    }

    @Override
    public AggregationSpec getSpec(boolean isMatchRecognize) {
        if (isMatchRecognize) {
            return null;
        }
        if (this.ondemandQuery && this.accessType == AggregationAccessType.WINDOW) {
            return new AggregationSpec(this.streamNum);
        }
        if (this.istreamOnly || this.ondemandQuery) {
            return null;
        }
        return new AggregationSpec(this.streamNum);
    }

    @Override
    public AggregationAccessor getAccessor() {
        if (this.indexEvalNode != null) {
            boolean isFirst = this.accessType == AggregationAccessType.FIRST;
            int constant = -1;
            if (this.indexEvalNode.isConstantResult()) {
                constant = (Integer)this.indexEvalNode.getExprEvaluator().evaluate(null, true, null);
            }
            return new AggregationAccessorFirstLastIndex(this.streamNum, this.childNode, this.indexEvalNode.getExprEvaluator(), constant, isFirst);
        }
        if (this.accessType == AggregationAccessType.FIRST) {
            return new AggregationAccessorFirst(this.streamNum, this.childNode);
        }
        if (this.accessType == AggregationAccessType.LAST) {
            return new AggregationAccessorLast(this.streamNum, this.childNode);
        }
        if (this.accessType == AggregationAccessType.WINDOW) {
            return new AggregationAccessorAll(this.streamNum, this.childNode, this.resultType);
        }
        throw new IllegalStateException("Access type is undefined or not known as code '" + (Object)((Object)this.accessType) + "'");
    }

    @Override
    public AggregationMethod make(MethodResolutionService methodResolutionService, int[] agentInstanceIds, int groupId, int aggregationId) {
        if (this.accessType == AggregationAccessType.FIRST) {
            return methodResolutionService.makeFirstEverValueAggregator(agentInstanceIds, groupId, aggregationId, this.resultType, false);
        }
        if (this.accessType == AggregationAccessType.LAST) {
            return methodResolutionService.makeLastEverValueAggregator(agentInstanceIds, groupId, aggregationId, this.resultType, false);
        }
        throw new RuntimeException("Window aggregation function is not available");
    }

    public AggregationMethodFactory getPrototypeAggregator() {
        return this;
    }
}

