/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.agg.AggregationMethodFactory;
import com.espertech.esper.epl.agg.AggregationResultFuture;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.expression.ExprAggregateNode;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeBase;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.util.JavaClassHelper;
import java.util.Map;

public abstract class ExprAggregateNodeBase
extends ExprNodeBase
implements ExprEvaluator,
ExprAggregateNode {
    private static final long serialVersionUID = 4859196214837888423L;
    protected transient AggregationResultFuture aggregationResultFuture;
    protected int column;
    private transient AggregationMethodFactory aggregationMethodFactory;
    protected boolean isDistinct;

    protected abstract String getAggregationFunctionName();

    protected abstract boolean equalsNodeAggregate(ExprAggregateNode var1);

    protected abstract AggregationMethodFactory validateAggregationChild(StreamTypeService var1, MethodResolutionService var2, ExprEvaluatorContext var3) throws ExprValidationException;

    protected ExprAggregateNodeBase(boolean distinct) {
        this.isDistinct = distinct;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public Map<String, Object> getEventType() {
        return null;
    }

    @Override
    public void validate(ExprValidationContext validationContext) throws ExprValidationException {
        this.aggregationMethodFactory = this.validateAggregationChild(validationContext.getStreamTypeService(), validationContext.getMethodResolutionService(), validationContext.getExprEvaluatorContext());
    }

    @Override
    public Class getType() {
        if (this.aggregationMethodFactory == null) {
            throw new IllegalStateException("Aggregation method has not been set");
        }
        return this.aggregationMethodFactory.getResultType();
    }

    @Override
    public AggregationMethodFactory getFactory() {
        if (this.aggregationMethodFactory == null) {
            throw new IllegalStateException("Aggregation method has not been set");
        }
        return this.aggregationMethodFactory;
    }

    @Override
    public void setAggregationResultFuture(AggregationResultFuture aggregationResultFuture, int column) {
        this.aggregationResultFuture = aggregationResultFuture;
        this.column = column;
    }

    @Override
    public final Object evaluate(EventBean[] events, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        return this.aggregationResultFuture.getValue(this.column, exprEvaluatorContext.getAgentInstanceIds());
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    @Override
    public final boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprAggregateNode)) {
            return false;
        }
        ExprAggregateNodeBase other = (ExprAggregateNodeBase)node;
        if (other.isDistinct != this.isDistinct) {
            return false;
        }
        return this.equalsNodeAggregate(other);
    }

    protected final Class validateNumericChildAllowFilter(StreamTypeService streamTypeService, boolean hasFilter) throws ExprValidationException {
        Class childType;
        if (this.getChildNodes().size() == 0 || this.getChildNodes().size() > 2) {
            throw new ExprValidationException(this.getAggregationFunctionName() + " node must have at least 1 or maximum 2 child nodes");
        }
        ExprNode child = this.getChildNodes().get(0);
        if (hasFilter) {
            this.validateFilter(this.getChildNodes().get(1).getExprEvaluator());
        }
        if (!JavaClassHelper.isNumeric(childType = child.getExprEvaluator().getType())) {
            throw new ExprValidationException("Implicit conversion from datatype '" + childType.getSimpleName() + "' to numeric is not allowed for aggregation function '" + this.getAggregationFunctionName() + "'");
        }
        return childType;
    }

    @Override
    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getAggregationFunctionName());
        buffer.append('(');
        if (this.isDistinct) {
            buffer.append("distinct ");
        }
        if (!this.getChildNodes().isEmpty()) {
            buffer.append(this.getChildNodes().get(0).toExpressionString());
        } else {
            buffer.append('*');
        }
        buffer.append(')');
        return buffer.toString();
    }

    public void validateFilter(ExprEvaluator filterEvaluator) throws ExprValidationException {
        if (JavaClassHelper.getBoxedType(filterEvaluator.getType()) != Boolean.class) {
            throw new ExprValidationException("Invalid filter expression parameter to the aggregation function '" + this.getAggregationFunctionName() + "' is expected to return a boolean value but returns " + JavaClassHelper.getClassNameFullyQualPretty(filterEvaluator.getType()));
        }
    }
}

