/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.epl.expression.ExprAggregateNode;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeInnerNodeProvider;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ExprAggregateNodeUtil {
    public static void getAggregatesBottomUp(ExprNode topNode, List<ExprAggregateNode> aggregateNodes) {
        int deepLevel;
        TreeMap<Integer, List<ExprAggregateNode>> aggregateExprPerLevel = new TreeMap<Integer, List<ExprAggregateNode>>();
        if (topNode instanceof ExprNodeInnerNodeProvider) {
            ExprNodeInnerNodeProvider parameterized = (ExprNodeInnerNodeProvider)((Object)topNode);
            List<ExprNode> additionalNodes = parameterized.getAdditionalNodes();
            for (ExprNode additionalNode : additionalNodes) {
                ExprAggregateNodeUtil.recursiveAggregateEnter(additionalNode, aggregateExprPerLevel, 1);
            }
        }
        ExprAggregateNodeUtil.recursiveAggregateEnter(topNode, aggregateExprPerLevel, 1);
        if (aggregateExprPerLevel.isEmpty()) {
            return;
        }
        for (int i = deepLevel = aggregateExprPerLevel.lastKey().intValue(); i >= 1; --i) {
            List<ExprAggregateNode> list = aggregateExprPerLevel.get(i);
            if (list == null) continue;
            aggregateNodes.addAll(list);
        }
    }

    private static void recursiveAggregateEnter(ExprNode currentNode, Map<Integer, List<ExprAggregateNode>> aggregateExprPerLevel, int currentLevel) {
        for (ExprNode node : currentNode.getChildNodes()) {
            if (node instanceof ExprNodeInnerNodeProvider) {
                ExprNodeInnerNodeProvider parameterized = (ExprNodeInnerNodeProvider)((Object)node);
                List<ExprNode> additionalNodes = parameterized.getAdditionalNodes();
                for (ExprNode additionalNode : additionalNodes) {
                    ExprAggregateNodeUtil.recursiveAggregateEnter(additionalNode, aggregateExprPerLevel, currentLevel + 1);
                }
            }
            ExprAggregateNodeUtil.recursiveAggregateEnter(node, aggregateExprPerLevel, currentLevel + 1);
        }
        if (!(currentNode instanceof ExprAggregateNode)) {
            return;
        }
        List<ExprAggregateNode> aggregates = aggregateExprPerLevel.get(currentLevel);
        if (aggregates == null) {
            aggregates = new LinkedList<ExprAggregateNode>();
            aggregateExprPerLevel.put(currentLevel, aggregates);
        }
        aggregates.add((ExprAggregateNode)currentNode);
    }
}

