/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeBase;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.type.BitWiseOpEnum;
import com.espertech.esper.util.JavaClassHelper;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExprBitWiseNode
extends ExprNodeBase
implements ExprEvaluator {
    private final BitWiseOpEnum _bitWiseOpEnum;
    private transient BitWiseOpEnum.Computer bitWiseOpEnumComputer;
    private Class resultType;
    private transient ExprEvaluator[] evaluators;
    private static final long serialVersionUID = 9035943176810365437L;
    private static final Log log = LogFactory.getLog(ExprBitWiseNode.class);

    public ExprBitWiseNode(BitWiseOpEnum bitWiseOpEnum_) {
        this._bitWiseOpEnum = bitWiseOpEnum_;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    public BitWiseOpEnum getBitWiseOpEnum() {
        return this._bitWiseOpEnum;
    }

    @Override
    public void validate(ExprValidationContext validationContext) throws ExprValidationException {
        Class childBoxedTypeTwo;
        if (this.getChildNodes().size() != 2) {
            throw new ExprValidationException("BitWise node must have 2 child nodes");
        }
        for (ExprEvaluator child : this.evaluators = ExprNodeUtility.getEvaluators(this.getChildNodes())) {
            Class childType = child.getType();
            if (JavaClassHelper.isBoolean(childType) || JavaClassHelper.isNumeric(childType)) continue;
            throw new ExprValidationException("Invalid datatype for bitwise " + childType.getName() + " is not allowed");
        }
        Class childTypeOne = this.evaluators[0].getType();
        Class childTypeTwo = this.evaluators[1].getType();
        if (JavaClassHelper.isFloatingPointClass(childTypeOne) || JavaClassHelper.isFloatingPointClass(childTypeTwo)) {
            throw new ExprValidationException("Invalid type for bitwise " + this._bitWiseOpEnum.getComputeDescription() + " operator");
        }
        Class childBoxedTypeOne = JavaClassHelper.getBoxedType(childTypeOne);
        if (childBoxedTypeOne != (childBoxedTypeTwo = JavaClassHelper.getBoxedType(childTypeTwo))) {
            throw new ExprValidationException("Both nodes muts be of the same type for bitwise " + this._bitWiseOpEnum.getComputeDescription() + " operator");
        }
        this.resultType = childBoxedTypeOne;
        this.bitWiseOpEnumComputer = this._bitWiseOpEnum.getComputer(this.resultType);
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public Class getType() {
        return this.resultType;
    }

    @Override
    public Map<String, Object> getEventType() {
        return null;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object valueChildOne = this.evaluators[0].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        Object valueChildTwo = this.evaluators[1].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        if (valueChildOne == null || valueChildTwo == null) {
            return null;
        }
        return this.bitWiseOpEnumComputer.compute(valueChildOne, valueChildTwo);
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprBitWiseNode)) {
            return false;
        }
        ExprBitWiseNode other = (ExprBitWiseNode)node;
        return other._bitWiseOpEnum == this._bitWiseOpEnum;
    }

    @Override
    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('(');
        buffer.append(this.getChildNodes().get(0).toExpressionString());
        buffer.append(this._bitWiseOpEnum.getComputeDescription());
        buffer.append(this.getChildNodes().get(1).toExpressionString());
        buffer.append(')');
        return buffer.toString();
    }
}

