/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeBase;
import com.espertech.esper.epl.expression.ExprNodeUtility;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import java.util.Map;

public class ExprConcatNode
extends ExprNodeBase
implements ExprEvaluator {
    private StringBuffer buffer = new StringBuffer();
    private transient ExprEvaluator[] evaluators;
    private static final long serialVersionUID = 5811427566733004327L;

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public Map<String, Object> getEventType() {
        return null;
    }

    @Override
    public void validate(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.getChildNodes().size() < 2) {
            throw new ExprValidationException("Concat node must have at least 2 child nodes");
        }
        this.evaluators = ExprNodeUtility.getEvaluators(this.getChildNodes());
        for (int i = 0; i < this.evaluators.length; ++i) {
            String childTypeName;
            Class childType = this.evaluators[i].getType();
            String string = childTypeName = childType == null ? "null" : childType.getSimpleName();
            if (childType == String.class) continue;
            throw new ExprValidationException("Implicit conversion from datatype '" + childTypeName + "' to string is not allowed");
        }
    }

    @Override
    public Class getType() {
        return String.class;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        this.buffer.delete(0, this.buffer.length());
        for (ExprEvaluator child : this.evaluators) {
            String result = (String)child.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (result == null) {
                return null;
            }
            this.buffer.append(result);
        }
        return this.buffer.toString();
    }

    @Override
    public String toExpressionString() {
        StringBuilder buffer = new StringBuilder();
        String delimiter = "(";
        for (ExprNode child : this.getChildNodes()) {
            buffer.append(delimiter);
            buffer.append(child.toExpressionString());
            delimiter = "||";
        }
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        return node instanceof ExprConcatNode;
    }
}

