/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprConstantNode;
import com.espertech.esper.epl.expression.ExprEvaluator;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeBase;
import com.espertech.esper.epl.expression.ExprValidationContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import java.util.Map;

public class ExprConstantNodeImpl
extends ExprNodeBase
implements ExprConstantNode,
ExprEvaluator {
    private Object value;
    private final Class clazz;
    private static final long serialVersionUID = 3154169410675962539L;

    public ExprConstantNodeImpl(Object value) {
        this.value = value;
        this.clazz = value == null ? null : value.getClass();
    }

    public ExprConstantNodeImpl(Object value, Class valueType) {
        this.value = value;
        this.clazz = value == null ? valueType : value.getClass();
    }

    public ExprConstantNodeImpl(Class clazz) {
        this.clazz = clazz;
        this.value = null;
    }

    @Override
    public void validate(ExprValidationContext validationContext) throws ExprValidationException {
    }

    @Override
    public boolean isConstantResult() {
        return true;
    }

    @Override
    public Map<String, Object> getEventType() {
        return null;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public Class getType() {
        return this.clazz;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        return this.value;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public String toExpressionString() {
        if (this.value instanceof String) {
            return "\"" + this.value + '\"';
        }
        if (this.value == null) {
            return "null";
        }
        return this.value.toString();
    }

    @Override
    public boolean equalsNode(ExprNode node) {
        if (!(node instanceof ExprConstantNodeImpl)) {
            return false;
        }
        ExprConstantNodeImpl other = (ExprConstantNodeImpl)node;
        if (other.value == null && this.value != null) {
            return false;
        }
        if (other.value != null && this.value == null) {
            return false;
        }
        if (other.value == null && this.value == null) {
            return true;
        }
        return other.value.equals(this.value);
    }
}

